/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyShellHelper {
    private static final Cache<Integer, Class<Script>> GROOVY_SCRIPT_CLASSES_CACHE = CacheBuilder.newBuilder().initialCapacity(40).maximumSize(100L).expireAfterAccess(1L, TimeUnit.DAYS).build();

    public static GroovyShellCacheDecorator wrapShellIntoCacheDecorator(GroovyShell shell) {
        return new GroovyShellCacheDecorator(shell);
    }

    public static class GroovyShellCacheDecorator {
        private GroovyShell shell;

        private GroovyShellCacheDecorator(GroovyShell shell) {
            this.shell = shell;
        }

        public Object evaluate(byte[] template) throws Exception {
            return this.evaluate(template, true);
        }

        public Object evaluate(byte[] template, boolean useCache) throws Exception {
            String templateString = new String(template, StandardCharsets.UTF_8);
            if (useCache) {
                Class scriptClass = (Class)GROOVY_SCRIPT_CLASSES_CACHE.get((Object)templateString.hashCode(), () -> this.shell.getClassLoader().parseClass(templateString));
                return InvokerHelper.createScript((Class)scriptClass, (Binding)this.shell.getContext()).run();
            }
            return this.shell.evaluate(templateString);
        }
    }
}

