/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;

public class HotelUnholdHelper {
    public static void unhold(EntityContainer<BookingFile> bfCtr, Collection<Message> messages) throws Exception {
        LockUtil.lock((EntityReference)bfCtr.toReference(), ctr -> HotelUnholdHelper.unhold((EntityContainer<BookingFile>)ctr, messages, null));
    }

    public static void unhold(EntityContainer<BookingFile> bfCtr, Logger log) {
        ArrayList<Message> messages = new ArrayList<Message>();
        HotelUnholdHelper.unhold(bfCtr, messages, log);
        bfCtr.getVersionInfo().setDataSource("auto-unhold");
        EntityStorage.get().save(bfCtr, true);
        SysLogHelper.audit(bfCtr.toReference(), "auto-unhold", messages);
    }

    private static void unhold(EntityContainer<BookingFile> bfCtr, Collection<Message> messages, Logger log) {
        String bookingFileNumber = ((BookingFile)bfCtr.getEntity()).getNumber();
        ArrayList<HotelProduct> toUnhold = new ArrayList<HotelProduct>();
        for (Reservation res : ((BookingFile)bfCtr.getEntity()).getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                HotelProduct hp;
                if (!(bp instanceof HotelProduct) || !HotelProductHelper.isOnHoldLastSell2((HotelProduct)(hp = (HotelProduct)bp))) continue;
                toUnhold.add(hp);
            }
        }
        if (toUnhold.isEmpty()) {
            if (log != null) {
                log.warn("nothing to unhold found in booking " + bookingFileNumber);
            }
            return;
        }
        for (HotelProduct hp : toUnhold) {
            String prodStr = String.format("hotel product %s in booking %s", hp.getSystemNumber(), bookingFileNumber);
            try {
                HotelProductHelper.setOnHold((HotelProduct)hp, (boolean)false);
                if (log != null) {
                    log.info("successfully unholded " + prodStr);
                }
                messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0431\u0440\u043e\u043d\u044c {0} \u0441\u043d\u044f\u0442\u0430 \u0441 \u0445\u043e\u043b\u0434\u0430", (Object[])new Object[]{hp.getSystemNumber()}));
            }
            catch (Exception e) {
                if (log != null) {
                    log.error("failed unholding " + prodStr, (Throwable)e);
                }
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043d\u044f\u0442\u0438\u0438 \u0441 \u0445\u043e\u043b\u0434\u0430 \u043e\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u0431\u0440\u043e\u043d\u0438 {0}", (Object[])new Object[]{hp.getSystemNumber()}));
            }
        }
    }
}

