/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityStatus;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndexData;
import com.gridnine.xtrip.common.model.booking.CommonProductIndexData;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationGdsNameInfo;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.statistics.ProductBillingDataChangeEntry;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProductVoidingHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexBuilderHelper {
    private static final Logger log = LoggerFactory.getLogger(IndexBuilderHelper.class);

    public static void rebuild(String entities) throws Exception {
        String[] classList;
        for (String clazz : classList = entities.split(",")) {
            IndexBuilderHelper.rebuild(XHelper.getClass((String)clazz));
        }
    }

    public static <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void rebuild(Class<E> clazz) throws Exception {
        LogicalEntityStorage entityStorage = LogicalStorage.get().getEntityStorage();
        List uids = entityStorage.getEntityUids(clazz, null, null, true, false, SortOrder.DESC, null);
        Iterator iterator = uids.iterator();
        while (iterator.hasNext()) {
            String uid;
            String containerTitle = uid = (String)iterator.next();
            try {
                EntityContainer etc = EntityStorage.get().load(clazz, uid);
                if (etc == null || etc.getStatus() == EntityStatus.VOID) continue;
                containerTitle = etc.getEntity().toString();
                entityStorage.updateIndexes(etc, null, false);
            }
            catch (Exception e) {
                log.error("unable to rebuild indexes for " + containerTitle, (Throwable)e);
            }
        }
    }

    public static boolean isInFinanceDocuments(BaseProduct product) {
        for (Payment payment : product.getReservation().getBookingFile().getPayments()) {
            for (BillingItem item : payment.getBillingItems()) {
                if (!item.getProductUids().contains(product.getUid())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInDelivery(BaseProduct product) {
        if (GeneralProductHelper.DELIVERY_DISABLED) {
            return false;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DeliveryItemIndex.Property.type.name(), (Object)DeliveryItemType.PRODUCT));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DeliveryItemIndex.Property.nestedEntityUid.name(), (Object)product.getUid()));
        query.setResultMode(ResultMode.COUNT_ONLY);
        return EntityStorage.get().search(DeliveryItemIndex.class, query).getTotalCount() > 0;
    }

    private IndexBuilderHelper() {
    }

    public static BigDecimal getVoidFeeValue(BaseProduct product, ContractType type, boolean hidden) {
        return IndexBuilderHelper.getRelatedProductValue(product, prod -> GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)prod, (ContractType)type), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)(hidden ? GeneralProductHelper.hiddenCommissionCategories : null))), (xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1}));
    }

    public static BigDecimal getVoidFeeValue(BaseProduct product, ContractType type) {
        return IndexBuilderHelper.getVoidFeeValue(product, type, false);
    }

    public static Double getVoidFeeRate(BaseProduct product, ContractType type, boolean hidden) {
        return IndexBuilderHelper.getRelatedProductValue(product, prod -> GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)ProductVoidingHelper.getUnmodifiableCommissions((ProductVoiding)prod, (ContractType)type), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)(hidden ? GeneralProductHelper.hiddenCommissionCategories : null)), (boolean)true), null);
    }

    public static Double getVoidFeeRate(BaseProduct product, ContractType type) {
        return IndexBuilderHelper.getVoidFeeRate(product, type, false);
    }

    public static List<String> getCostCodeValues(List<CostCode> costCodes, Function<CostCode, String> mapper) {
        return costCodes.stream().filter(Objects::nonNull).map(mapper).collect(Collectors.toList());
    }

    public static String getCostCodesJoinValue(List<CostCode> costCodes, Function<CostCode, String> mapper) {
        return costCodes.stream().map(mapper).collect(Collectors.joining(", "));
    }

    static <T> T getRelatedProductValue(BaseProduct prod, RelatedProductCallback<T> clb, BinaryOperator<T> adder) {
        Object result = null;
        for (BaseProduct bp : prod.getReservation().getProducts()) {
            ProductVoiding pv;
            if (!(bp instanceof ProductVoiding) || (pv = (ProductVoiding)bp).getRelatedProduct() != prod) continue;
            T value = clb.getValue(pv);
            if (adder == null) {
                return value;
            }
            result = result == null ? value : adder.apply(result, value);
        }
        return result;
    }

    public static List<GdsName> getGdsNames(Reservation reservation) {
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        return gdsNameInfo.getSystemInfos().stream().map(ReservationSystemInfo::getGdsName).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<String> getRecordLocators(Reservation reservation) {
        ArrayList<String> result = new ArrayList<String>();
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        for (ReservationSystemInfo systemInfo : gdsNameInfo.getSystemInfos()) {
            List recordLocators = systemInfo.getRecordLocators();
            for (RecordLocatorInfo recordLocatorInfo : recordLocators) {
                String value = String.format("%s%s%s%s%s", systemInfo.getGdsName() != null ? systemInfo.getGdsName().name() : null, ":", recordLocatorInfo.getType() != null ? recordLocatorInfo.getType().name() : null, "=", recordLocatorInfo.getRecordLocator());
                result.add(value);
            }
        }
        return result;
    }

    public static List<String> getBookingAgentDutyCodes(Reservation reservation) {
        ArrayList<String> result = new ArrayList<String>();
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        for (ReservationSystemInfo systemInfo : gdsNameInfo.getSystemInfos()) {
            result.add(String.format("%s%s%s", systemInfo.getGdsName() != null ? systemInfo.getGdsName().name() : null, ":", systemInfo.getBookingAgentDutyCode()));
        }
        return result;
    }

    public static List<String> getBookingPccList(Reservation reservation) {
        ArrayList<String> result = new ArrayList<String>();
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        for (ReservationSystemInfo systemInfo : gdsNameInfo.getSystemInfos()) {
            result.add(String.format("%s%s%s", systemInfo.getGdsName() != null ? systemInfo.getGdsName().name() : null, ":", systemInfo.getBookingPcc()));
        }
        return result;
    }

    public static void updateReservationGdsNameInfo(Reservation reservation, CommonProductIndexData data, DataAggregator aggregator) {
        List<GdsName> gdsNames = IndexBuilderHelper.getGdsNames(reservation);
        data.setGdsNames(gdsNames);
        List<String> recordLocators = IndexBuilderHelper.getRecordLocators(reservation);
        data.setRecordLocators(recordLocators);
        GdsName displayedGdsName = CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)reservation);
        data.setDisplayedGdsName(displayedGdsName);
        String displayedRecordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
        data.setDisplayedRecordLocator(displayedRecordLocator);
        data.setRulesGdsName(reservation.getGdsNameInfo().getRulesGdsName());
        data.setStatisticsGdsName(reservation.getGdsNameInfo().getStatisticsGdsName());
        List<String> bookingAgentDutyCodes = IndexBuilderHelper.getBookingAgentDutyCodes(reservation);
        data.setBookingAgentCodes(bookingAgentDutyCodes);
        List<String> bookingPccList = IndexBuilderHelper.getBookingPccList(reservation);
        data.setBookingPccList(bookingPccList);
        if (aggregator != null) {
            aggregator.aggregate(gdsNames);
            aggregator.aggregate(recordLocators);
            aggregator.aggregate((Enum)displayedGdsName);
            aggregator.aggregate((Object)displayedRecordLocator);
            aggregator.aggregate(bookingAgentDutyCodes);
            aggregator.aggregate(bookingPccList);
        }
    }

    public static void updateReservationGdsNameInfo(Reservation reservation, CommonProductFopIndexData data, DataAggregator aggregator) {
        List<GdsName> gdsNames = IndexBuilderHelper.getGdsNames(reservation);
        data.setGdsNames(gdsNames);
        GdsName displayedGdsName = CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)reservation);
        data.setDisplayedGdsName(displayedGdsName);
        if (aggregator != null) {
            aggregator.aggregate(gdsNames);
            aggregator.aggregate((Enum)displayedGdsName);
        }
    }

    public static void updateChangeDataSources(BaseProduct product, CommonProductIndexData data) {
        data.setChangeDataSources((Collection)product.getBillingDataChangeEntries().stream().map(ProductBillingDataChangeEntry::getSource).collect(Collectors.toSet()));
    }

    static interface RelatedProductCallback<T> {
        public T getValue(ProductVoiding var1);
    }
}

