/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationsContractRelationsHelper {
    private static final Logger log = LoggerFactory.getLogger(OrganizationsContractRelationsHelper.class);

    public static List<List<EntityReference<Organization>>> getOrganizationRelationRoutes(EntityReference<Organization> from, EntityReference<Organization> to, Date date) {
        List<OrganizationNode> organizationNodes = OrganizationsContractRelationsHelper.getOrganizationNodes(from, date);
        OrganizationGraph graph = new OrganizationGraph(organizationNodes, from, to);
        return graph.getRoutes();
    }

    public static List<List<EntityReference<Organization>>> getOrganizationRelationRoutes(EntityReference<Organization> from, EntityReference<Organization> to) {
        return OrganizationsContractRelationsHelper.getOrganizationRelationRoutes(from, to, null);
    }

    private static List<OrganizationNode> getOrganizationNodes(EntityReference<Organization> organization, Date date) {
        EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        EntityReference allClientsProfile = ProfileDao.findAllClientsProfile();
        HashMap<Object, Set> organizations = new HashMap<Object, Set>();
        Set<EntityReference<Organization>> suppliers = OrganizationsContractRelationsHelper.getSuppliers(organization, (EntityReference<Organization>)allAgenciesProfile, (EntityReference<Organization>)allClientsProfile, date);
        organizations.put(organization, new HashSet<EntityReference<Organization>>(suppliers));
        while (!suppliers.isEmpty()) {
            HashSet<EntityReference<Organization>> suppliersLevelUp = new HashSet<EntityReference<Organization>>();
            for (EntityReference<Organization> supplier : suppliers) {
                Set<EntityReference<Organization>> relatedSuppliers = OrganizationsContractRelationsHelper.getSuppliers(supplier, (EntityReference<Organization>)allAgenciesProfile, (EntityReference<Organization>)allClientsProfile, date);
                suppliersLevelUp.addAll(relatedSuppliers);
                organizations.computeIfAbsent(supplier, k -> new HashSet()).addAll(relatedSuppliers);
            }
            suppliersLevelUp.removeAll(organizations.keySet());
            suppliers = suppliersLevelUp;
        }
        return organizations.entrySet().stream().map(item -> new OrganizationNode((EntityReference<Organization>)((EntityReference)item.getKey()), (Set)item.getValue())).sorted((o1, o2) -> MiscUtil.compare((Comparable)((Object)o1.getOrganization().getUid()), (Comparable)((Object)o2.getOrganization().getUid()))).collect(Collectors.toList());
    }

    private static Set<EntityReference<Organization>> getSuppliers(EntityReference<Organization> organization, EntityReference<Organization> allAgenciesProfile, EntityReference<Organization> allClientsProfile, Date date) {
        EntityContainer organizationCtr;
        HashSet<EntityReference<Organization>> customers = new HashSet<EntityReference<Organization>>();
        customers.add(organization);
        if ((allClientsProfile != null || allAgenciesProfile != null) && (organizationCtr = EntityStorage.get().resolve(organization)) != null) {
            if (((Organization)organizationCtr.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT) && allClientsProfile != null) {
                customers.add(allClientsProfile);
            }
            if (((Organization)organizationCtr.getEntity()).getTypes().contains(OrganizationType.AGENCY) && allAgenciesProfile != null) {
                customers.add(allAgenciesProfile);
            }
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ContractIndex.Property.contractType.name(), (Object)ContractType.TECHNICAL_PROVIDER));
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)ContractIndex.Property.customer.name(), (Object[])customers.toArray()));
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)date))}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)date))}));
        }
        query.getPreferredProperties().add(ContractIndex.Property.supplier.name());
        Set<EntityReference<Organization>> suppliers = EntityStorage.get().search(ContractIndex.class, query).getData().stream().map(ContractIndex::getSupplier).filter(Objects::nonNull).collect(Collectors.toSet());
        if (suppliers.remove(allAgenciesProfile)) {
            suppliers.addAll(OrganizationsContractRelationsHelper.getAllAgencies());
        }
        suppliers.remove(organization);
        return suppliers;
    }

    private static Set<EntityReference<Organization>> getAllAgencies() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.disabled.name(), (Object)false));
        return EntityStorage.get().search(OrganizationIndex.class, query).getData().stream().map(OrganizationIndex::getSource).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static class OrganizationGraph {
        private final List<OrganizationNode> organizationNodes = new ArrayList<OrganizationNode>();
        private final EntityReference<Organization> fromOrganization;
        private final EntityReference<Organization> toOrganization;
        private final OrganizationsStack stack;

        public OrganizationGraph(List<OrganizationNode> organizationNodes, EntityReference<Organization> fromOrganization, EntityReference<Organization> toOrganization) {
            this.organizationNodes.addAll(organizationNodes);
            this.fromOrganization = fromOrganization;
            this.toOrganization = toOrganization;
            this.stack = new OrganizationsStack(organizationNodes.size());
        }

        private Integer getOrganizationIndex(EntityReference<Organization> organization) {
            for (int i = 0; i < this.organizationNodes.size(); ++i) {
                if (!this.organizationNodes.get(i).getOrganization().equals(organization)) continue;
                return i;
            }
            return null;
        }

        private int getUnvisitedBy(int i) {
            OrganizationNode previousNode = null;
            if (this.stack.top != 0) {
                int indexPreviousNode = this.stack.stackArray[this.stack.top - 1];
                previousNode = this.organizationNodes.get(indexPreviousNode);
            }
            String visitors = this.getVisitors();
            OrganizationNode organizationNode = this.organizationNodes.get(i);
            if (organizationNode != null) {
                for (int k = 0; k < this.organizationNodes.size(); ++k) {
                    OrganizationNode node = this.organizationNodes.get(k);
                    if (!organizationNode.getSuppliers().contains(node.getOrganization()) || node.equals(previousNode) || visitors == null || !node.getVisitedBy().stream().noneMatch(item -> item.equals(visitors))) continue;
                    return k;
                }
            }
            return -1;
        }

        private String getVisitors() {
            StringBuilder visitors = new StringBuilder();
            for (int k = 0; k <= this.stack.top; ++k) {
                if (visitors.length() != 0) {
                    visitors.append("_");
                }
                visitors.append(this.stack.stackArray[k]);
            }
            if (visitors.length() != 0) {
                return visitors.toString();
            }
            return null;
        }

        public List<List<EntityReference<Organization>>> getRoutes() {
            ArrayList<List<EntityReference<Organization>>> routes = new ArrayList<List<EntityReference<Organization>>>();
            Integer index = this.getOrganizationIndex(this.fromOrganization);
            if (index != null) {
                this.stack.push(index);
            }
            while (!this.stack.isEmpty()) {
                int peek = this.stack.peek();
                int i = this.getUnvisitedBy(peek);
                if (i == -1) {
                    OrganizationNode organizationNode = null;
                    Integer pop = this.stack.pop();
                    if (pop != null) {
                        organizationNode = this.organizationNodes.get(pop);
                    }
                    if (organizationNode == null || !organizationNode.getOrganization().equals(this.toOrganization)) continue;
                    routes.add(this.getRoute());
                    continue;
                }
                String visitors = this.getVisitors();
                if (visitors != null) {
                    this.organizationNodes.get(i).getVisitedBy().add(visitors);
                }
                this.stack.push(i);
            }
            routes.sort((l1, l2) -> MiscUtil.compare((int)l1.size(), (int)l2.size()));
            return routes;
        }

        private List<EntityReference<Organization>> getRoute() {
            ArrayList<EntityReference<Organization>> route = new ArrayList<EntityReference<Organization>>();
            for (int i = this.stack.top + 1; i >= 0; --i) {
                OrganizationNode organizationNode = this.organizationNodes.get(this.stack.stackArray[i]);
                if (organizationNode == null) continue;
                route.add(organizationNode.getOrganization());
            }
            return route;
        }
    }

    private static class OrganizationNode {
        private final EntityReference<Organization> organization;
        private final Set<EntityReference<Organization>> suppliers = new HashSet<EntityReference<Organization>>();
        private final List<String> visitedBy = new ArrayList<String>();

        public OrganizationNode(EntityReference<Organization> organization, Set<EntityReference<Organization>> suppliers) {
            this.organization = organization;
            this.suppliers.addAll(suppliers);
        }

        public EntityReference<Organization> getOrganization() {
            return this.organization;
        }

        public Set<EntityReference<Organization>> getSuppliers() {
            return this.suppliers;
        }

        public List<String> getVisitedBy() {
            return this.visitedBy;
        }
    }

    private static class OrganizationsStack {
        private final int[] stackArray;
        private int top;

        public OrganizationsStack(int size) {
            this.stackArray = new int[size];
            this.top = -1;
        }

        public void push(int i) {
            int n = ++this.top;
            try {
                this.stackArray[n] = i;
            }
            catch (Exception e) {
                log.error(String.format("Failed to push index %s to stackArray (length - %s, top - - %s)", i, this.stackArray.length, this.top), (Throwable)e);
            }
        }

        public Integer pop() {
            int i = this.top--;
            try {
                return this.stackArray[i];
            }
            catch (Exception e) {
                log.error(String.format("Failed to pop element from stackArray (length - %s, top - - %s)", this.stackArray.length, this.top), (Throwable)e);
                return null;
            }
        }

        public int peek() {
            return this.stackArray[this.top];
        }

        public boolean isEmpty() {
            return this.top == -1;
        }
    }
}

