/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.model.helpers.OrganizationsContractRelationsHelper;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.model.test.TestContractBuilderBuilder;
import com.gridnine.xtrip.server.model.test.TestOrganizationBuilder;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OrganizationsContractRelationsHelperTest
extends ModelTestBase {
    private EntityContainer<Organization> anyAgency;
    private EntityContainer<Organization> anyClient;
    private EntityContainer<Organization> client1;
    private EntityContainer<Organization> client2;
    private EntityContainer<Organization> subagency1;
    private EntityContainer<Organization> subagency2;
    private EntityContainer<Organization> subagency3;
    private EntityContainer<Organization> subagency4;
    private EntityContainer<Organization> subagency5;
    private EntityContainer<Organization> agency1;
    private EntityContainer<Organization> agency2;
    private EntityContainer<Organization> agency3;
    private EntityContainer<Organization> supplier1;
    private EntityContainer<Organization> supplier2;
    private EntityContainer<Organization> supplier3;
    private EntityContainer<Contract> contract01;
    private List<List<EntityReference<Organization>>> routesExpected;

    @Before
    public void init() throws Exception {
        this.routesExpected = new ArrayList<List<EntityReference<Organization>>>();
        Preference preference = new Preference();
        this.anyAgency = new EntityContainer(Organization.class);
        ((Organization)this.anyAgency.getEntity()).setCode("ANY-AGENCY");
        EntityStorage.get().save(this.anyAgency, true);
        preference.setKey(PreferenceKey.ALL_AGENCIES_PROFILE_UID);
        preference.setValue(this.anyAgency.getUid());
        DictionaryStorage.get().save((BaseDictionary)preference);
        preference = new Preference();
        this.anyClient = new EntityContainer(Organization.class);
        ((Organization)this.anyClient.getEntity()).setCode("ANY-CLIENT");
        EntityStorage.get().save(this.anyClient, true);
        preference.setKey(PreferenceKey.ALL_CLIENTS_PROFILE_UID);
        preference.setValue(this.anyClient.getUid());
        DictionaryStorage.get().save((BaseDictionary)preference);
        TestOrganizationBuilder client1Builder = new TestOrganizationBuilder();
        this.client1 = client1Builder.code("CL1").fullName("Client-1").shortName("Client-1").types(new OrganizationType[]{OrganizationType.CORPORATE_CLIENT}).create();
        TestOrganizationBuilder client2Builder = new TestOrganizationBuilder();
        this.client2 = client2Builder.code("CL2").fullName("Client-2").shortName("Client-2").types(new OrganizationType[]{OrganizationType.CORPORATE_CLIENT}).create();
        TestOrganizationBuilder subagency1Builder = new TestOrganizationBuilder();
        this.subagency1 = subagency1Builder.code("SA1").fullName("Subagency-1").shortName("Subagency-1").types(new OrganizationType[]{OrganizationType.AGENCY}).create();
        TestOrganizationBuilder subagency2Builder = new TestOrganizationBuilder();
        this.subagency2 = subagency2Builder.code("SA2").fullName("Subagency-2").shortName("Subagency-2").types(new OrganizationType[]{OrganizationType.AGENCY}).create();
        TestOrganizationBuilder subagency3Builder = new TestOrganizationBuilder();
        this.subagency3 = subagency3Builder.code("SA3").fullName("Subagency-3").shortName("Subagency-3").types(new OrganizationType[]{OrganizationType.AGENCY}).create();
        TestOrganizationBuilder subagency4Builder = new TestOrganizationBuilder();
        this.subagency4 = subagency4Builder.code("SA4").fullName("Subagency-4").shortName("Subagency-4").types(new OrganizationType[]{OrganizationType.AGENCY}).create();
        TestOrganizationBuilder subagency5Builder = new TestOrganizationBuilder();
        this.subagency5 = subagency5Builder.code("SA5").fullName("Subagency-5").shortName("Subagency-5").types(new OrganizationType[]{OrganizationType.AGENCY}).create();
        TestOrganizationBuilder agency1Builder = new TestOrganizationBuilder();
        this.agency1 = agency1Builder.code("A1").fullName("Agency-1").shortName("Agency-1").types(new OrganizationType[]{OrganizationType.AGENCY}).create();
        TestOrganizationBuilder agency2Builder = new TestOrganizationBuilder();
        this.agency2 = agency2Builder.code("A2").fullName("Agency-2").shortName("Agency-2").types(new OrganizationType[]{OrganizationType.AGENCY}).create();
        TestOrganizationBuilder agency3Builder = new TestOrganizationBuilder();
        this.agency3 = agency3Builder.code("A3").fullName("Agency-3").shortName("Agency-3").types(new OrganizationType[]{OrganizationType.AGENCY}).create();
        TestOrganizationBuilder supplier1Builder = new TestOrganizationBuilder();
        this.supplier1 = supplier1Builder.code("S1").fullName("Supplier-1").shortName("Supplier-1").types(new OrganizationType[]{OrganizationType.BLANK_OWNER, OrganizationType.AGENCY}).create();
        TestOrganizationBuilder supplier2Builder = new TestOrganizationBuilder();
        this.supplier2 = supplier2Builder.code("S2").fullName("Supplier-2").shortName("Supplier-2").types(new OrganizationType[]{OrganizationType.BLANK_OWNER}).create();
        TestOrganizationBuilder supplier3Builder = new TestOrganizationBuilder();
        this.supplier3 = supplier3Builder.code("S3").fullName("Supplier-3").shortName("Supplier-3").types(new OrganizationType[]{OrganizationType.BLANK_OWNER, OrganizationType.AGENCY}).create();
        TestContractBuilderBuilder contract01Builder = new TestContractBuilderBuilder();
        this.contract01 = contract01Builder.contractType(ContractType.CLIENT).customerNewContract(this.client1.toReference()).supplier(this.subagency1.toReference()).create();
        TestContractBuilderBuilder contract02Builder = new TestContractBuilderBuilder();
        contract02Builder.contractType(ContractType.CLIENT).customerNewContract(this.client1.toReference()).supplier(this.subagency2.toReference()).create();
        TestContractBuilderBuilder contract03Builder = new TestContractBuilderBuilder();
        contract03Builder.contractType(ContractType.CLIENT).customerNewContract(this.client1.toReference()).supplier(this.subagency3.toReference()).create();
        TestContractBuilderBuilder contract04Builder = new TestContractBuilderBuilder();
        contract04Builder.contractType(ContractType.CLIENT).customerNewContract(this.client1.toReference()).supplier(this.subagency4.toReference()).create();
        TestContractBuilderBuilder contract05Builder = new TestContractBuilderBuilder();
        contract05Builder.contractType(ContractType.CLIENT).customerNewContract(this.client1.toReference()).supplier(this.agency1.toReference()).create();
        TestContractBuilderBuilder contract06Builder = new TestContractBuilderBuilder();
        contract06Builder.contractType(ContractType.SUBAGENCY).customerNewContract(this.subagency1.toReference()).supplier(this.agency1.toReference()).create();
        TestContractBuilderBuilder contract07Builder = new TestContractBuilderBuilder();
        contract07Builder.contractType(ContractType.SUBAGENCY).customerNewContract(this.subagency2.toReference()).supplier(this.agency2.toReference()).create();
        TestContractBuilderBuilder contract08Builder = new TestContractBuilderBuilder();
        contract08Builder.contractType(ContractType.VENDOR).customerNewContract(this.subagency2.toReference()).supplier(this.supplier1.toReference()).create();
        TestContractBuilderBuilder contract09Builder = new TestContractBuilderBuilder();
        contract09Builder.contractType(ContractType.VENDOR).customerNewContract(this.subagency3.toReference()).supplier(this.supplier2.toReference()).create();
        TestContractBuilderBuilder contract10Builder = new TestContractBuilderBuilder();
        contract10Builder.contractType(ContractType.SUBAGENCY).customerNewContract(this.subagency4.toReference()).supplier(this.subagency5.toReference()).create();
        TestContractBuilderBuilder contract11Builder = new TestContractBuilderBuilder();
        contract11Builder.contractType(ContractType.SUBAGENCY).customerNewContract(this.subagency5.toReference()).supplier(this.agency1.toReference()).create();
        TestContractBuilderBuilder contract12Builder = new TestContractBuilderBuilder();
        contract12Builder.contractType(ContractType.VENDOR).customerNewContract(this.agency1.toReference()).supplier(this.supplier1.toReference()).create();
        TestContractBuilderBuilder contract13Builder = new TestContractBuilderBuilder();
        contract13Builder.contractType(ContractType.VENDOR).customerNewContract(this.agency1.toReference()).supplier(this.supplier3.toReference()).create();
        TestContractBuilderBuilder contract14Builder = new TestContractBuilderBuilder();
        contract14Builder.contractType(ContractType.VENDOR).customerNewContract(this.agency2.toReference()).supplier(this.supplier3.toReference()).create();
    }

    @Test
    public void baseTest() {
        List<EntityReference> route1 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.client1.toReference());
        List<EntityReference> route2 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency1.toReference(), this.client1.toReference());
        List<EntityReference> route3 = Arrays.asList(this.supplier3.toReference(), this.agency2.toReference(), this.subagency2.toReference(), this.client1.toReference());
        List<EntityReference> route4 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        this.routesExpected.add(route1);
        this.routesExpected.add(route2);
        this.routesExpected.add(route3);
        this.routesExpected.add(route4);
        List<List<EntityReference<Organization>>> routesResult = OrganizationsContractRelationsHelper.getOrganizationRelationRoutes((EntityReference<Organization>)this.client1.toReference(), (EntityReference<Organization>)this.supplier3.toReference());
        Assert.assertTrue((boolean)this.isRoutesEquals(this.routesExpected, routesResult));
    }

    @Test
    public void circleDependencyInRelationsTest() throws Exception {
        TestContractBuilderBuilder contract1Builder = new TestContractBuilderBuilder();
        contract1Builder.contractType(ContractType.CLIENT).customerNewContract(this.client1.toReference()).supplier(this.subagency5.toReference()).create();
        TestContractBuilderBuilder contract2Builder = new TestContractBuilderBuilder();
        contract2Builder.contractType(ContractType.SUBAGENCY).customerNewContract(this.subagency5.toReference()).supplier(this.subagency4.toReference()).create();
        TestContractBuilderBuilder contract3Builder = new TestContractBuilderBuilder();
        contract3Builder.contractType(ContractType.SUBAGENCY).customerNewContract(this.subagency4.toReference()).supplier(this.agency1.toReference()).create();
        List<EntityReference> route1 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.client1.toReference());
        List<EntityReference> route2 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency1.toReference(), this.client1.toReference());
        List<EntityReference> route3 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency4.toReference(), this.client1.toReference());
        List<EntityReference> route4 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.client1.toReference());
        List<EntityReference> route5 = Arrays.asList(this.supplier3.toReference(), this.agency2.toReference(), this.subagency2.toReference(), this.client1.toReference());
        List<EntityReference> route6 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency4.toReference(), this.subagency5.toReference(), this.client1.toReference());
        List<EntityReference> route7 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        this.routesExpected.add(route1);
        this.routesExpected.add(route2);
        this.routesExpected.add(route3);
        this.routesExpected.add(route4);
        this.routesExpected.add(route5);
        this.routesExpected.add(route6);
        this.routesExpected.add(route7);
        List<List<EntityReference<Organization>>> routesResult = OrganizationsContractRelationsHelper.getOrganizationRelationRoutes((EntityReference<Organization>)this.client1.toReference(), (EntityReference<Organization>)this.supplier3.toReference());
        Assert.assertTrue((boolean)this.isRoutesEquals(this.routesExpected, routesResult));
    }

    @Test
    public void anyClientTest() throws Exception {
        TestContractBuilderBuilder contract1Builder = new TestContractBuilderBuilder();
        contract1Builder.contractType(ContractType.CLIENT).customerNewContract(this.anyClient.toReference()).supplier(this.agency3.toReference()).create();
        TestContractBuilderBuilder contract2Builder = new TestContractBuilderBuilder();
        contract2Builder.contractType(ContractType.VENDOR).customerNewContract(this.agency3.toReference()).supplier(this.supplier3.toReference()).create();
        List<EntityReference> route1 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.client1.toReference());
        List<EntityReference> route2 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.client1.toReference());
        List<EntityReference> route3 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency1.toReference(), this.client1.toReference());
        List<EntityReference> route4 = Arrays.asList(this.supplier3.toReference(), this.agency2.toReference(), this.subagency2.toReference(), this.client1.toReference());
        List<EntityReference> route5 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        this.routesExpected.add(route1);
        this.routesExpected.add(route2);
        this.routesExpected.add(route3);
        this.routesExpected.add(route4);
        this.routesExpected.add(route5);
        List<List<EntityReference<Organization>>> routesResult = OrganizationsContractRelationsHelper.getOrganizationRelationRoutes((EntityReference<Organization>)this.client1.toReference(), (EntityReference<Organization>)this.supplier3.toReference());
        Assert.assertTrue((boolean)this.isRoutesEquals(this.routesExpected, routesResult));
    }

    @Test
    public void anyAgencyAsSupplierInClientContractTest() throws Exception {
        TestContractBuilderBuilder contract1Builder = new TestContractBuilderBuilder();
        contract1Builder.contractType(ContractType.CLIENT).customerNewContract(this.client1.toReference()).supplier(this.anyAgency.toReference()).create();
        TestContractBuilderBuilder contract2Builder = new TestContractBuilderBuilder();
        contract2Builder.contractType(ContractType.VENDOR).customerNewContract(this.agency3.toReference()).supplier(this.supplier3.toReference()).create();
        List<EntityReference> route1 = Arrays.asList(this.supplier3.toReference(), this.client1.toReference());
        List<EntityReference> route2 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.client1.toReference());
        List<EntityReference> route3 = Arrays.asList(this.supplier3.toReference(), this.agency2.toReference(), this.client1.toReference());
        List<EntityReference> route4 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.client1.toReference());
        List<EntityReference> route5 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency1.toReference(), this.client1.toReference());
        List<EntityReference> route6 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.client1.toReference());
        List<EntityReference> route7 = Arrays.asList(this.supplier3.toReference(), this.agency2.toReference(), this.subagency2.toReference(), this.client1.toReference());
        List<EntityReference> route8 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        this.routesExpected.add(route1);
        this.routesExpected.add(route2);
        this.routesExpected.add(route3);
        this.routesExpected.add(route4);
        this.routesExpected.add(route5);
        this.routesExpected.add(route6);
        this.routesExpected.add(route7);
        this.routesExpected.add(route8);
        List<List<EntityReference<Organization>>> routesResult = OrganizationsContractRelationsHelper.getOrganizationRelationRoutes((EntityReference<Organization>)this.client1.toReference(), (EntityReference<Organization>)this.supplier3.toReference());
        Assert.assertTrue((boolean)this.isRoutesEquals(this.routesExpected, routesResult));
    }

    @Test
    public void anyAgencyAsSupplierInSubagencyContractTest() throws Exception {
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        contractBuilder.contractType(ContractType.SUBAGENCY).customerNewContract(this.subagency5.toReference()).supplier(this.anyAgency.toReference()).create();
        List<EntityReference> route1 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.client1.toReference());
        List<EntityReference> route2 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency1.toReference(), this.client1.toReference());
        List<EntityReference> route3 = Arrays.asList(this.supplier3.toReference(), this.agency2.toReference(), this.subagency2.toReference(), this.client1.toReference());
        List<EntityReference> route4 = Arrays.asList(this.supplier3.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        List<EntityReference> route5 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        List<EntityReference> route6 = Arrays.asList(this.supplier3.toReference(), this.agency2.toReference(), this.subagency2.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        List<EntityReference> route7 = Arrays.asList(this.supplier3.toReference(), this.agency2.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        List<EntityReference> route8 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency1.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        this.routesExpected.add(route1);
        this.routesExpected.add(route2);
        this.routesExpected.add(route3);
        this.routesExpected.add(route4);
        this.routesExpected.add(route5);
        this.routesExpected.add(route6);
        this.routesExpected.add(route7);
        this.routesExpected.add(route8);
        List<List<EntityReference<Organization>>> routesResult = OrganizationsContractRelationsHelper.getOrganizationRelationRoutes((EntityReference<Organization>)this.client1.toReference(), (EntityReference<Organization>)this.supplier3.toReference());
        Assert.assertTrue((boolean)this.isRoutesEquals(this.routesExpected, routesResult));
    }

    @Test
    public void anyAgencyAsCustomerInSubagencyContractTest() throws Exception {
        TestContractBuilderBuilder contract1Builder = new TestContractBuilderBuilder();
        contract1Builder.contractType(ContractType.SUBAGENCY).customerNewContract(this.anyAgency.toReference()).supplier(this.agency3.toReference()).create();
        TestContractBuilderBuilder contract2Builder = new TestContractBuilderBuilder();
        contract2Builder.contractType(ContractType.VENDOR).customerNewContract(this.agency3.toReference()).supplier(this.supplier3.toReference()).create();
        List<EntityReference> route1 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.client1.toReference());
        List<EntityReference> route2 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency1.toReference(), this.client1.toReference());
        List<EntityReference> route3 = Arrays.asList(this.supplier3.toReference(), this.agency2.toReference(), this.subagency2.toReference(), this.client1.toReference());
        List<EntityReference> route4 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.subagency1.toReference(), this.client1.toReference());
        List<EntityReference> route5 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.subagency2.toReference(), this.client1.toReference());
        List<EntityReference> route6 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.subagency3.toReference(), this.client1.toReference());
        List<EntityReference> route7 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.subagency4.toReference(), this.client1.toReference());
        List<EntityReference> route8 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.agency1.toReference(), this.client1.toReference());
        List<EntityReference> route9 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        List<EntityReference> route10 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.agency1.toReference(), this.subagency1.toReference(), this.client1.toReference());
        List<EntityReference> route11 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.agency2.toReference(), this.subagency2.toReference(), this.client1.toReference());
        List<EntityReference> route12 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.supplier1.toReference(), this.agency1.toReference(), this.client1.toReference());
        List<EntityReference> route13 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.supplier1.toReference(), this.subagency2.toReference(), this.client1.toReference());
        List<EntityReference> route14 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        List<EntityReference> route15 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        List<EntityReference> route16 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.supplier1.toReference(), this.agency1.toReference(), this.subagency1.toReference(), this.client1.toReference());
        List<EntityReference> route17 = Arrays.asList(this.supplier3.toReference(), this.agency3.toReference(), this.supplier1.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        this.routesExpected.add(route1);
        this.routesExpected.add(route2);
        this.routesExpected.add(route3);
        this.routesExpected.add(route4);
        this.routesExpected.add(route5);
        this.routesExpected.add(route6);
        this.routesExpected.add(route7);
        this.routesExpected.add(route8);
        this.routesExpected.add(route9);
        this.routesExpected.add(route10);
        this.routesExpected.add(route11);
        this.routesExpected.add(route12);
        this.routesExpected.add(route13);
        this.routesExpected.add(route14);
        this.routesExpected.add(route15);
        this.routesExpected.add(route16);
        this.routesExpected.add(route17);
        List<List<EntityReference<Organization>>> routesResult = OrganizationsContractRelationsHelper.getOrganizationRelationRoutes((EntityReference<Organization>)this.client1.toReference(), (EntityReference<Organization>)this.supplier3.toReference());
        Assert.assertTrue((boolean)this.isRoutesEquals(this.routesExpected, routesResult));
    }

    @Test
    public void anyAgencyAsCustomerInVendorContractTest() throws Exception {
        TestContractBuilderBuilder contractBuilder = new TestContractBuilderBuilder();
        contractBuilder.contractType(ContractType.VENDOR).customerNewContract(this.anyAgency.toReference()).supplier(this.supplier3.toReference()).create();
        List<EntityReference> route1 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.client1.toReference());
        List<EntityReference> route2 = Arrays.asList(this.supplier3.toReference(), this.subagency1.toReference(), this.client1.toReference());
        List<EntityReference> route3 = Arrays.asList(this.supplier3.toReference(), this.subagency2.toReference(), this.client1.toReference());
        List<EntityReference> route4 = Arrays.asList(this.supplier3.toReference(), this.subagency3.toReference(), this.client1.toReference());
        List<EntityReference> route5 = Arrays.asList(this.supplier3.toReference(), this.subagency4.toReference(), this.client1.toReference());
        List<EntityReference> route6 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency1.toReference(), this.client1.toReference());
        List<EntityReference> route7 = Arrays.asList(this.supplier3.toReference(), this.agency2.toReference(), this.subagency2.toReference(), this.client1.toReference());
        List<EntityReference> route8 = Arrays.asList(this.supplier3.toReference(), this.supplier1.toReference(), this.agency1.toReference(), this.client1.toReference());
        List<EntityReference> route9 = Arrays.asList(this.supplier3.toReference(), this.supplier1.toReference(), this.subagency2.toReference(), this.client1.toReference());
        List<EntityReference> route10 = Arrays.asList(this.supplier3.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        List<EntityReference> route11 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        List<EntityReference> route12 = Arrays.asList(this.supplier3.toReference(), this.supplier1.toReference(), this.agency1.toReference(), this.subagency1.toReference(), this.client1.toReference());
        List<EntityReference> route13 = Arrays.asList(this.supplier3.toReference(), this.supplier1.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        this.routesExpected.add(route1);
        this.routesExpected.add(route2);
        this.routesExpected.add(route3);
        this.routesExpected.add(route4);
        this.routesExpected.add(route5);
        this.routesExpected.add(route6);
        this.routesExpected.add(route7);
        this.routesExpected.add(route8);
        this.routesExpected.add(route9);
        this.routesExpected.add(route10);
        this.routesExpected.add(route11);
        this.routesExpected.add(route12);
        this.routesExpected.add(route13);
        List<List<EntityReference<Organization>>> routesResult = OrganizationsContractRelationsHelper.getOrganizationRelationRoutes((EntityReference<Organization>)this.client1.toReference(), (EntityReference<Organization>)this.supplier3.toReference());
        Assert.assertTrue((boolean)this.isRoutesEquals(this.routesExpected, routesResult));
    }

    @Test
    public void anyClientAnyAgencyTest() throws Exception {
        TestContractBuilderBuilder contract1Builder = new TestContractBuilderBuilder();
        contract1Builder.contractType(ContractType.CLIENT).customerNewContract(this.anyClient.toReference()).supplier(this.anyAgency.toReference()).create();
        TestContractBuilderBuilder contract2Builder = new TestContractBuilderBuilder();
        contract2Builder.contractType(ContractType.CLIENT).customerNewContract(this.client2.toReference()).supplier(this.agency1.toReference()).create();
        List<EntityReference> route1 = Arrays.asList(this.supplier3.toReference(), this.client1.toReference());
        List<EntityReference> route2 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.client1.toReference());
        List<EntityReference> route3 = Arrays.asList(this.supplier3.toReference(), this.agency2.toReference(), this.client1.toReference());
        List<EntityReference> route4 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency1.toReference(), this.client1.toReference());
        List<EntityReference> route5 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.client1.toReference());
        List<EntityReference> route6 = Arrays.asList(this.supplier3.toReference(), this.agency2.toReference(), this.subagency2.toReference(), this.client1.toReference());
        List<EntityReference> route7 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        this.routesExpected.add(route1);
        this.routesExpected.add(route2);
        this.routesExpected.add(route3);
        this.routesExpected.add(route4);
        this.routesExpected.add(route5);
        this.routesExpected.add(route6);
        this.routesExpected.add(route7);
        List<List<EntityReference<Organization>>> routesResult = OrganizationsContractRelationsHelper.getOrganizationRelationRoutes((EntityReference<Organization>)this.client1.toReference(), (EntityReference<Organization>)this.supplier3.toReference());
        Assert.assertTrue((boolean)this.isRoutesEquals(this.routesExpected, routesResult));
    }

    @Test
    public void noRouteTest() throws Exception {
        TestContractBuilderBuilder contract1Builder = new TestContractBuilderBuilder();
        contract1Builder.contractType(ContractType.CLIENT).customerNewContract(this.client2.toReference()).supplier(this.agency2.toReference()).create();
        TestContractBuilderBuilder contract2Builder = new TestContractBuilderBuilder();
        contract2Builder.contractType(ContractType.CLIENT).customerNewContract(this.client2.toReference()).supplier(this.subagency3.toReference()).create();
        List<List<EntityReference<Organization>>> routesResult = OrganizationsContractRelationsHelper.getOrganizationRelationRoutes((EntityReference<Organization>)this.client2.toReference(), (EntityReference<Organization>)this.supplier1.toReference());
        Assert.assertTrue((boolean)routesResult.isEmpty());
    }

    @Test
    public void closedContractTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2023, 3, 12);
        Date date = calendar.getTime();
        calendar.set(2022, 11, 31);
        Date endDate = calendar.getTime();
        ((Contract)this.contract01.getEntity()).setEndDate(endDate);
        EntityStorage.get().save(this.contract01, true);
        List<EntityReference> route1 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.client1.toReference());
        List<EntityReference> route2 = Arrays.asList(this.supplier3.toReference(), this.agency2.toReference(), this.subagency2.toReference(), this.client1.toReference());
        List<EntityReference> route3 = Arrays.asList(this.supplier3.toReference(), this.agency1.toReference(), this.subagency5.toReference(), this.subagency4.toReference(), this.client1.toReference());
        this.routesExpected.add(route1);
        this.routesExpected.add(route2);
        this.routesExpected.add(route3);
        List<List<EntityReference<Organization>>> routesResult = OrganizationsContractRelationsHelper.getOrganizationRelationRoutes((EntityReference<Organization>)this.client1.toReference(), (EntityReference<Organization>)this.supplier3.toReference(), date);
        Assert.assertTrue((boolean)this.isRoutesEquals(this.routesExpected, routesResult));
    }

    private boolean isRoutesEquals(List<List<EntityReference<Organization>>> routesExpected, List<List<EntityReference<Organization>>> routesResult) {
        if (routesResult.size() != routesExpected.size()) {
            return false;
        }
        ArrayList<List<EntityReference<Organization>>> routes = new ArrayList<List<EntityReference<Organization>>>(routesExpected);
        for (List<EntityReference<Organization>> routeResult : routesResult) {
            List route = routes.stream().filter(item -> CollectionUtil.equals((Collection)item, (Collection)routeResult, (boolean)false)).findFirst().orElse(null);
            if (route == null) {
                return false;
            }
            routes.remove(route);
        }
        return routes.isEmpty();
    }
}

