/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.PaymentDocumentType;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.PaymentDocumentsProperties;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PaymentDocumentHelper {
    private static Logger log = LoggerFactory.getLogger(PaymentDocumentHelper.class);

    public static ConsecutiveNumberCategory getCategory(PaymentDocumentType type) {
        if (type == PaymentDocumentType.CREDIT_SLIP) {
            return ConsecutiveNumberCategory.PAYMENT_DOCUMENT_CREDIT_SLIP;
        }
        if (type == PaymentDocumentType.DEBIT_SLIP) {
            return ConsecutiveNumberCategory.PAYMENT_DOCUMENT_DEBIT_SLIP;
        }
        return null;
    }

    public static PaymentDocumentsProperties getPaymentDocumentsProperties(EntityReference<Organization> organization, boolean strict) {
        PaymentDocumentsProperties paymentDocumentsProperties = null;
        EntityContainer organizationContainer = EntityStorage.get().resolve(organization);
        if (organizationContainer != null) {
            paymentDocumentsProperties = ((Organization)organizationContainer.getEntity()).getPaymentDocumentProperties();
        }
        if (paymentDocumentsProperties == null && !strict) {
            EntityContainer defaultOrganizationContainer;
            EntityReference defaultOrganization = null;
            if (ProfileHelper.isOrganizationType(organization, (OrganizationType)OrganizationType.AGENCY)) {
                defaultOrganization = ProfileDao.findAllAgenciesProfile();
            } else if (ProfileHelper.isOrganizationType(organization, (OrganizationType)OrganizationType.CORPORATE_CLIENT)) {
                defaultOrganization = ProfileDao.findAllClientsProfile();
            }
            if (defaultOrganization != null && (defaultOrganizationContainer = EntityStorage.get().resolve(organization)) != null) {
                paymentDocumentsProperties = ((Organization)defaultOrganizationContainer.getEntity()).getPaymentDocumentProperties();
            }
        }
        return paymentDocumentsProperties;
    }
}

