/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonProfileLockHelper {
    private PersonProfileLockData lockData = null;
    private final Collection<EntityContainer<Person>> personContainers;
    private final Iterator<EntityContainer<Person>> personContainerIterator;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public PersonProfileLockHelper(Collection<EntityContainer<Person>> personContainers) {
        this.personContainers = personContainers.stream().sorted((o1, o2) -> TextUtil.compare((String)o1.getUid(), (String)o2.getUid(), (boolean)false, (boolean)true)).collect(Collectors.toList());
        this.personContainerIterator = this.personContainers.iterator();
    }

    public static PersonProfileLockHelper fromReferences(Collection<EntityReference<Person>> personReferences) {
        List<EntityContainer<Person>> personContainers = personReferences.stream().map(personEntityReference -> EntityStorage.get().resolve(personEntityReference)).filter(Objects::nonNull).sorted((o1, o2) -> TextUtil.compare((String)o1.getUid(), (String)o2.getUid(), (boolean)false, (boolean)true)).collect(Collectors.toList());
        return new PersonProfileLockHelper(personContainers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockNextContainer() {
        if (!this.personContainerIterator.hasNext()) {
            return;
        }
        EntityContainer<Person> personContainer = this.personContainerIterator.next();
        NamedLock lock = null;
        boolean locked = false;
        try {
            lock = LockUtil.getLockManager().getLock((Object)LockUtil.getLockKey(personContainer), TimeUnit.MINUTES.toMillis(1L));
            if (lock.tryLock(10L, TimeUnit.SECONDS)) {
                this.log.debug(String.format("successfully obtained lock for %s", personContainer.getEntity()));
                locked = true;
                EntityContainer existingContainer = EntityStorage.get().resolve(personContainer.toReference());
                if (existingContainer == null || !SystemHelper.isModifiedByThirdPartyProcess((VersionInfo)existingContainer.getVersionInfo(), (VersionInfo)personContainer.getVersionInfo())) {
                    return;
                }
                this.log.debug(String.format("person profile container %s was modified by background process %s", personContainer.getEntity(), existingContainer.getModifiedBy()));
            }
        }
        catch (InterruptedException e) {
            this.log.warn("unable to lock container " + personContainer.toReference());
        }
        finally {
            if (lock != null) {
                this.lockData = new PersonProfileLockData(lock, locked, (EntityReference<Person>)personContainer.toReference());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void unlockCurrentContainer() {
        block20: {
            if (this.lockData == null) {
                return;
            }
            if (!this.lockData.locked) break block20;
            this.lockData.lock.unlock();
            this.log.debug(String.format("lock released for profile %s", this.lockData.personReference));
        }
        try {
            this.lockData.lock.close();
            this.log.debug(String.format("lock closed for profile %s", this.lockData.personReference));
        }
        catch (Exception e) {
            this.log.error(String.format("unable to close lock for %s", this.lockData.personReference), (Throwable)e);
        }
        finally {
            this.lockData = null;
        }
        catch (Exception e) {
            try {
                this.log.error(String.format("unable to unlock %s", this.lockData.personReference), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    this.lockData.lock.close();
                    this.log.debug(String.format("lock closed for profile %s", this.lockData.personReference));
                }
                catch (Exception e2) {
                    this.log.error(String.format("unable to close lock for %s", this.lockData.personReference), (Throwable)e2);
                }
                finally {
                    this.lockData = null;
                }
                throw throwable;
            }
            try {
                this.lockData.lock.close();
                this.log.debug(String.format("lock closed for profile %s", this.lockData.personReference));
            }
            catch (Exception e3) {
                this.log.error(String.format("unable to close lock for %s", this.lockData.personReference), (Throwable)e3);
            }
            finally {
                this.lockData = null;
            }
        }
    }

    public boolean isLocked() {
        return this.lockData.locked;
    }

    public boolean hasNext() {
        return this.personContainerIterator.hasNext();
    }

    public EntityContainer<Person> getCurrentPersonContainer() {
        return this.lockData == null ? null : EntityStorage.get().resolve(this.lockData.personReference);
    }

    private static class PersonProfileLockData {
        final NamedLock lock;
        final boolean locked;
        final EntityReference<Person> personReference;

        public PersonProfileLockData(NamedLock lock, boolean locked, EntityReference<Person> personReference) {
            this.lock = lock;
            this.locked = locked;
            this.personReference = personReference;
        }
    }
}

