/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ProductSearchResult {
    private BookingFile bookingFile;
    private Reservation reservation;
    private BaseProduct product;
    private EntityContainer<BookingFile> container;
    private Map<Integer, DictionaryReference<Airline>> shareCarriersForSirena;
    private boolean unique = true;
    private boolean sabreReservation = false;

    public ProductSearchResult(BookingFile bookingFileValue, BaseProduct productValue, Reservation reservationValue, EntityContainer<BookingFile> containerValue, boolean isUnique) {
        this.bookingFile = bookingFileValue;
        this.product = productValue;
        this.reservation = reservationValue;
        this.container = containerValue;
        this.unique = isUnique;
    }

    public ProductSearchResult() {
    }

    public BookingFile getBookingFile() {
        return this.bookingFile;
    }

    public void setBookingFile(BookingFile value) {
        this.bookingFile = value;
    }

    public Reservation getReservation() {
        return this.reservation;
    }

    public void setReservation(Reservation value) {
        this.reservation = value;
    }

    public BaseProduct getProduct() {
        return this.product;
    }

    public void setProduct(BaseProduct value) {
        this.product = value;
    }

    public void setContainer(EntityContainer<BookingFile> value) {
        this.container = value;
    }

    public EntityContainer<BookingFile> getContainer() {
        return this.container;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean isUnique) {
        this.unique = isUnique;
    }

    public boolean isSabreReservation() {
        return this.sabreReservation;
    }

    public void setSabreReservation(boolean value) {
        this.sabreReservation = value;
    }

    public Map<Integer, DictionaryReference<Airline>> getShareCarriersForSirena() {
        return this.shareCarriersForSirena;
    }

    public void fillShareCarriersForSirena() {
        this.shareCarriersForSirena = new HashMap<Integer, DictionaryReference<Airline>>();
        if (this.product != null) {
            List segments = ((Product)this.product).getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).collect(Collectors.toList());
            for (Segment st2 : segments) {
                this.shareCarriersForSirena.put(st2.getRecordNumber(), (DictionaryReference<Airline>)st2.getCodeShareCarrier());
            }
        }
    }
}

