/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.helpers.ValidatorHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.GdsReferenceIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationMetadataIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ProfileDao {
    public static List<EntityContainer<SalesPoint>> getSalesPointsByValidatorAndPcc(String validator, String pcc) throws Exception {
        SearchQuery query = ProfileDao.createQueryPccValidator(pcc, validator, null);
        return StorageHelper.getEntityContainers((SearchQuery)query, SalesPointIndex.class);
    }

    public static List<EntityContainer<SalesPoint>> getSalesPointsByValidatorAndPccAndTerminal(String validator, String pcc, String terminal) throws Exception {
        SearchQuery query = ProfileDao.createQueryPccValidator(pcc, validator, terminal);
        return StorageHelper.getEntityContainers((SearchQuery)query, SalesPointIndex.class);
    }

    public static List<EntityContainer<Organization>> getBlankOwnersByAirline(DictionaryReference<Airline> ref) throws Exception {
        if (ref == null) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name()));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)OrganizationIndex.Property.airline.name(), ref), SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)ref.getCode())}));
        return StorageHelper.getEntityContainers((SearchQuery)query, OrganizationIndex.class);
    }

    public static List<EntityReference<Organization>> getBlankOwnerReferencesByAirline(DictionaryReference<Airline> ref) throws Exception {
        if (ref == null) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name()));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)OrganizationIndex.Property.airline.name(), ref), SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)ref.getCode())}));
        return StorageHelper.getEntityReferences((SearchQuery)query, OrganizationIndex.class);
    }

    public static Set<EntityReference<Organization>> getAgencyReferencesByValidator(String validator, Date issueDate) throws Exception {
        HashSet<EntityReference<Organization>> result = new HashSet<EntityReference<Organization>>();
        for (ValidatorIndex index : ValidatorHelper.getValidators((String)validator, null, (Date)issueDate)) {
            result.add((EntityReference<Organization>)index.getAgency());
        }
        return result;
    }

    public static <E extends BaseProfile, I extends EntityIndex<E>> EntityContainer<E> findProfileByCode(String code, Class<I> cls, boolean unique) throws Exception {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"code", (Object)code));
        return (EntityContainer)StorageHelper.getFirstElement((boolean)unique, (Collection)StorageHelper.getEntityContainers((SearchQuery)query, cls));
    }

    public static <E extends BaseProfile, I extends EntityIndex<E>> List<EntityReference<E>> getProfileReferenceByCode(String code, Class<I> cls) {
        if (TextUtil.isBlank((String)code)) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"code", (Object)code));
        return StorageHelper.getEntityReferences((SearchQuery)query, cls);
    }

    public static <E extends BaseProfile, I extends EntityIndex<E>> List<EntityReference<E>> getProfileReferences(SearchQuery query, Class<I> cls) throws Exception {
        return StorageHelper.getEntityReferences((SearchQuery)query, cls);
    }

    public static SearchQuery createQueryAgentByGdsName(GdsName gds, String reference, Date operationDate) {
        SearchQuery query = ProfileDao.createQueryByGdsName(gds, operationDate);
        if (!TextUtil.isBlank((String)reference)) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.reference.name(), (Object)reference));
        }
        return query;
    }

    public static SearchQuery createQueryByGdsName(GdsName gds, Date operationDate) {
        SearchQuery query = new SearchQuery();
        if (gds != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.gdsName.name(), (Object)gds));
        }
        if (operationDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)GdsReferenceIndex.Property.opened.name(), null), SearchCriterion.le((String)GdsReferenceIndex.Property.opened.name(), (Object)MiscUtil.clearTime((Date)operationDate))}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)GdsReferenceIndex.Property.closed.name(), null), SearchCriterion.ge((String)GdsReferenceIndex.Property.closed.name(), (Object)MiscUtil.setDayEndTime((Date)operationDate))}));
        }
        return query;
    }

    public static List<EntityReference<Person>> getAgentReferenceByGdsCode(GdsName gds, EntityReference<Organization> agency, String reference, Date operationDate, AtomicBoolean searchByNullAgencyCode) {
        return ProfileDao.getAgentReferenceByGdsCode(gds, agency, reference, null, operationDate, searchByNullAgencyCode);
    }

    public static List<EntityReference<Person>> getAgentReferenceByGdsCode(GdsName gds, EntityReference<Organization> agency, String reference, String agencyCode, Date operationDate, AtomicBoolean searchByNullAgencyCode) {
        if (TextUtil.isBlank((String)reference)) {
            return Collections.emptyList();
        }
        SearchQuery query = ProfileDao.createQueryAgentByGdsName(gds, reference, operationDate);
        if (agency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.agency.name(), agency));
        }
        if (TextUtil.nonBlank((String)agencyCode)) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.agencyCode.name(), (Object)agencyCode));
        }
        List references = StorageHelper.getEntityReferences((SearchQuery)query, GdsReferenceIndex.class);
        if (TextUtil.isBlank((String)agencyCode)) {
            return references;
        }
        if (references.isEmpty()) {
            SearchQuery query2 = ProfileDao.createQueryAgentByGdsName(gds, reference, operationDate);
            if (agency != null) {
                query2.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.agency.name(), agency));
            }
            query2.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.agencyCode.name(), null));
            searchByNullAgencyCode.set(true);
            return StorageHelper.getEntityReferences((SearchQuery)query2, GdsReferenceIndex.class);
        }
        return references;
    }

    public static List<EntityReference<Person>> getAgentReferenceByCodeAndAgency(String code, EntityReference<Organization> agency) throws Exception {
        if (TextUtil.isBlank((String)code)) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.code.name(), (Object)code));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.AGENT.name()));
        if (agency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)agency.getUid()));
        }
        return StorageHelper.getEntityReferences((SearchQuery)query, PersonIndex.class);
    }

    private static SearchQuery createQueryPccValidator(String pcc, String validator, String terminal) {
        SearchQuery query = new SearchQuery();
        if (!TextUtil.isBlank((String)pcc)) {
            query.getCriteria().getCriterions().add(SearchCriterion.icontains((String)SalesPointIndex.Property.pccs.name(), (String)pcc));
        }
        if (!TextUtil.isBlank((String)validator)) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)SalesPointIndex.Property.validators.name(), (Object)validator));
        }
        if (!TextUtil.isBlank((String)terminal)) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)SalesPointIndex.Property.terminals.name(), (Object)terminal));
        }
        return query;
    }

    public static List<EntityReference<SalesPoint>> getSalesPointReferencesByValidatorAndPcc(String validator, String pcc) throws Exception {
        SearchQuery query = ProfileDao.createQueryPccValidator(pcc, validator, null);
        return StorageHelper.getEntityReferences((SearchQuery)query, SalesPointIndex.class);
    }

    public static List<EntityReference<SalesPoint>> getSalesPointReferencesByValidatorAndPcc(String aValidator, String aPcc, GdsName aGDSName, Date anOperationDate) throws Exception {
        if (TextUtil.isBlank((String)aValidator) && TextUtil.isBlank((String)aPcc) && aGDSName != null) {
            return Collections.emptyList();
        }
        SearchQuery query = ProfileDao.createQueryPccValidator(aPcc, aValidator, null);
        List availableSalesPoints = StorageHelper.getEntityReferences((SearchQuery)query, SalesPointIndex.class);
        if (anOperationDate == null) {
            return availableSalesPoints;
        }
        ArrayList<EntityReference<SalesPoint>> pccSalesPoints = new ArrayList<EntityReference<SalesPoint>>();
        ArrayList<EntityReference<SalesPoint>> validatorSalesPoints = new ArrayList<EntityReference<SalesPoint>>();
        SalesPoint salesPoint = null;
        for (EntityReference salesPointRef : availableSalesPoints) {
            EntityContainer spCont = EntityStorage.get().resolve(salesPointRef);
            if (spCont == null || spCont.getEntity() == null) continue;
            salesPoint = (SalesPoint)spCont.getEntity();
            if (aPcc != null) {
                for (Pcc pcc : salesPoint.getPccs()) {
                    if (pcc.getGdsName() == null || aGDSName == null || pcc.getGdsName() != aGDSName || pcc.getCode() == null || !pcc.getCode().equalsIgnoreCase(aPcc) || pcc.getOpened() != null && pcc.getOpened().compareTo(anOperationDate) > 0 || pcc.getClosed() != null && pcc.getClosed().compareTo(anOperationDate) < 0) continue;
                    pccSalesPoints.add((EntityReference<SalesPoint>)salesPointRef);
                }
            }
            if (aValidator == null || salesPoint == null) continue;
            for (Validator validator : salesPoint.getValidators()) {
                if ((validator.getNumber() == null || !validator.getNumber().equals(aValidator) || validator.getOpened() != null) && validator.getOpened().compareTo(anOperationDate) > 0 || validator.getClosed() != null && validator.getClosed().compareTo(anOperationDate) < 0) continue;
                validatorSalesPoints.add((EntityReference<SalesPoint>)salesPointRef);
            }
        }
        if (TextUtil.isBlank((String)aValidator)) {
            return pccSalesPoints;
        }
        if (TextUtil.isBlank((String)aPcc)) {
            return validatorSalesPoints;
        }
        if (validatorSalesPoints.isEmpty()) {
            return pccSalesPoints;
        }
        if (pccSalesPoints.isEmpty()) {
            return validatorSalesPoints;
        }
        pccSalesPoints.retainAll(validatorSalesPoints);
        return pccSalesPoints;
    }

    public static List<EntityReference<SalesPoint>> getSalesPointReferencesByValidatorAndPccAndTerminal(String validator, String pcc, String terminal) throws Exception {
        SearchQuery query = ProfileDao.createQueryPccValidator(pcc, validator, terminal);
        return StorageHelper.getEntityReferences((SearchQuery)query, SalesPointIndex.class);
    }

    public static EntityReference<SalesPoint> findSalesPointReferenceByValidatorAndPcc(String validator, String pcc, Date operationDate, boolean unique) throws Exception {
        SearchQuery query = ProfileDao.createQueryPccValidator(pcc, validator, null);
        return (EntityReference)StorageHelper.getFirstElement((boolean)unique, (Collection)StorageHelper.getEntityReferences((SearchQuery)query, SalesPointIndex.class));
    }

    public static List<EntityReference<Organization>> getOrganizationsByMetadata(MetadataKey key, Object value, OrganizationType type) throws Exception {
        if (key == null) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        if (type != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationMetadataIndex.Property.types.name(), (Object)type.name()));
        }
        if (value == null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationMetadataIndex.Property.metadataBooleanValue.name(), null));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationMetadataIndex.Property.metadataDateValue.name(), null));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationMetadataIndex.Property.metadataDictValue.name(), null));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationMetadataIndex.Property.metadataDateValue.name(), null));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationMetadataIndex.Property.metadataStringValue.name(), null));
            return StorageHelper.getEntityReferences((SearchQuery)query, OrganizationMetadataIndex.class);
        }
        if (value instanceof Boolean) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationMetadataIndex.Property.metadataBooleanValue.name(), (Object)value));
            return StorageHelper.getEntityReferences((SearchQuery)query, OrganizationMetadataIndex.class);
        }
        if (value instanceof Date) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationMetadataIndex.Property.metadataDateValue.name(), (Object)value));
            return StorageHelper.getEntityReferences((SearchQuery)query, OrganizationMetadataIndex.class);
        }
        if (value instanceof DictionaryReference) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationMetadataIndex.Property.metadataDictValue.name(), (Object)((DictionaryReference)value).getCode()));
            return StorageHelper.getEntityReferences((SearchQuery)query, OrganizationMetadataIndex.class);
        }
        if (value instanceof EntityReference) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationMetadataIndex.Property.metadataEntityValue.name(), (Object)value));
            return StorageHelper.getEntityReferences((SearchQuery)query, OrganizationMetadataIndex.class);
        }
        if (value instanceof String) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationMetadataIndex.Property.metadataStringValue.name(), (Object)value));
            return StorageHelper.getEntityReferences((SearchQuery)query, OrganizationMetadataIndex.class);
        }
        throw new IllegalArgumentException("unsupported value type " + value.getClass().getName());
    }

    public static EntityReference<Organization> findAgencyByMetadata(Metadata value) throws Exception {
        if (value == null) {
            return null;
        }
        EntityReference<Organization> result = null;
        SearchQuery query = new SearchQuery();
        List agencies = StorageHelper.getEntityContainers((SearchQuery)query, OrganizationIndex.class);
        for (EntityContainer agency : agencies) {
            List metadata = ((Organization)agency.getEntity()).getMetadata();
            if (metadata.isEmpty()) continue;
            for (Metadata md : metadata) {
                if (md.getKey() == null || md.getValue() == null || !(value.getKey() == null && value.getValue() != null ? md.getValue().equals(value.getValue()) : (value.getKey() != null && value.getValue() == null ? md.getKey().equals((Object)value.getKey()) : md.getKey().equals((Object)value.getKey()) && md.getValue().equals(value.getValue())))) continue;
                return agency.toReference();
            }
        }
        return result;
    }

    public static EntityReference<Organization> getAgencyByProduct(Product product) throws Exception {
        String validatorCode = product.getValidatorCode();
        if (product.getSalesPoint() == null || TextUtil.isBlank((String)validatorCode)) {
            return null;
        }
        EntityContainer spc = EntityStorage.get().resolve(product.getSalesPoint());
        if (spc == null) {
            return null;
        }
        SalesPoint salesPoint = (SalesPoint)spc.getEntity();
        Date issueDate = product.getIssueDate();
        EntityReference agency = null;
        for (Validator validator : salesPoint.getValidators()) {
            if (!validator.getNumber().equals(validatorCode) || validator.getOpened() != null && issueDate != null && !validator.getOpened().before(issueDate) && !validator.getOpened().equals(issueDate) || validator.getClosed() != null && issueDate != null && !validator.getClosed().after(issueDate) && !validator.getClosed().equals(issueDate)) continue;
            agency = validator.getAgency();
            break;
        }
        return agency;
    }

    public static List<EntityReference<Organization>> getAgenciesByCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)code));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY.name()));
        List agencies = StorageHelper.getEntityReferences((SearchQuery)query, OrganizationIndex.class);
        return agencies.size() > 0 ? agencies : null;
    }

    public static EntityReference<Person> findPassenger(Traveller traveller) throws Exception {
        if (traveller.getPassport() == null || TextUtil.isBlank((String)traveller.getPassport().getNumber())) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.name.name(), (Object)traveller.getName()));
        List passengers = StorageHelper.getEntityContainers((SearchQuery)query, PersonIndex.class);
        for (EntityContainer passenger : passengers) {
            for (Passport passengerPassport : ((Person)passenger.getEntity()).getPassports()) {
                if (TextUtil.isBlank((String)passengerPassport.getNumber()) || !passengerPassport.getNumber().equals(traveller.getPassport().getNumber())) continue;
                return passenger.toReference();
            }
        }
        return null;
    }

    public static Set<EntityReference<Organization>> getVendorsForProduct(Product product) throws Exception {
        EntityReference airline = product.getBlankOwnerRef();
        if (airline != null) {
            return Collections.singleton(airline);
        }
        LinkedHashSet<EntityReference<Organization>> result = new LinkedHashSet<EntityReference<Organization>>();
        for (ValidatorIndex index : ValidatorHelper.getValidatorIndexes((String)product.getValidatorCode(), null, null, (Date)product.getIssueDate())) {
            if (index.getBlankOwner() == null) continue;
            result.add((EntityReference<Organization>)index.getBlankOwner());
        }
        return result;
    }

    public static EntityReference<Person> findCurrentAgent(Collection<L10nMessage> messages) throws Exception {
        String user = LogicalStorage.get().getUser();
        if (user == null) {
            throw Xeption.forDeveloper((String)"logical storage user is null", (Object[])new Object[0]);
        }
        try {
            return EntityStorage.get().findReference(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)user);
        }
        catch (Exception exception) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)user));
            query.getPreferredProperties().add(PersonIndex.Property.loginName.name());
            query.setLimit(2);
            List lst = EntityStorage.get().search(PersonIndex.class, query).getData();
            EntityReference agent = null;
            if (!lst.isEmpty()) {
                agent = ((PersonIndex)lst.get(0)).getSource();
                if (lst.size() > 1 && messages != null) {
                    messages.add(L10nResourcesManager.createL10nMessage((String)Messages.ProfileDao_foundFewAgeryWithLogin, (Object[])new Object[]{user, agent}));
                }
            }
            return agent;
        }
    }

    public static List<EntityContainer<SalesPoint>> findSalesPointsByValidatorAndPCC(String validatorCode, String pcc, Date operationDate) throws Exception {
        List<EntityContainer<SalesPoint>> spList = ProfileDao.getSalesPointsByValidatorAndPcc(validatorCode, pcc);
        ArrayList<EntityContainer<SalesPoint>> result = new ArrayList<EntityContainer<SalesPoint>>();
        for (EntityContainer<SalesPoint> ec : spList) {
            SalesPoint sp = (SalesPoint)ec.getEntity();
            for (Pcc item : sp.getPccs()) {
                if (pcc != null && (item.getCode() == null || !item.getCode().equalsIgnoreCase(pcc)) || item.getOpened() != null && item.getOpened().compareTo(operationDate) > 0 || item.getClosed() != null && item.getClosed().compareTo(operationDate) < 0) continue;
                result.add(ec);
            }
        }
        return result;
    }

    public static List<EntityContainer<SalesPoint>> findSalesPointsByValidatorAndPCCAndTerminal(String validatorCode, String pcc, String terminal, Date operationDate) throws Exception {
        List<EntityContainer<SalesPoint>> spList = ProfileDao.getSalesPointsByValidatorAndPcc(validatorCode, pcc);
        if (spList.size() == 1) {
            return spList;
        }
        ArrayList<EntityContainer<SalesPoint>> result = new ArrayList<EntityContainer<SalesPoint>>();
        boolean checkPCC = !TextUtil.isBlank((String)pcc);
        boolean checkTerminal = !TextUtil.isBlank((String)terminal);
        for (EntityContainer<SalesPoint> ec : spList) {
            SalesPoint sp = (SalesPoint)ec.getEntity();
            boolean found = false;
            for (Pcc item : sp.getPccs()) {
                if (checkPCC && !TextUtil.isBlank((String)item.getCode()) && !item.getCode().equalsIgnoreCase(pcc)) continue;
                if (operationDate != null) {
                    boolean afterClose;
                    boolean beforeOpen = item.getOpened() != null && operationDate.compareTo(MiscUtil.clearTime((Date)item.getOpened())) < 0;
                    boolean bl = afterClose = item.getClosed() != null && operationDate.compareTo(MiscUtil.setDayEndTime((Date)item.getClosed())) > 0;
                    if (beforeOpen || afterClose) continue;
                }
                if (checkTerminal && (item.getTerminalNames().isEmpty() || !item.getTerminalNames().isEmpty() && !item.getTerminalNames().contains(terminal))) continue;
                found = true;
            }
            if (!found) continue;
            result.add(ec);
        }
        return result;
    }

    public static UserAccount findAccount(String loginName) throws Exception {
        if (TextUtil.isBlank((String)loginName)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UserAccount.Property.loginName.name(), (Object)loginName));
        List data = AssetsStorage.get().search(UserAccount.class, query).getData();
        return data.isEmpty() ? null : (UserAccount)data.get(0);
    }

    public static GdsReferenceIndex getGdsReferenceIndex(GdsName gdsName, EntityReference<Organization> agency, EntityReference<SalesPoint> salesPoint, String agentReference, Date date) throws Exception {
        List<GdsReferenceIndex> gdsReferenceIndexes = ProfileDao.getGdsReferenceIndexes(gdsName, agency, salesPoint, agentReference, date);
        return gdsReferenceIndexes.isEmpty() ? null : gdsReferenceIndexes.get(0);
    }

    public static List<GdsReferenceIndex> getGdsReferenceIndexes(GdsName gdsName, EntityReference<Organization> agency, EntityReference<SalesPoint> salesPoint, String agentReference, Date date) throws Exception {
        if (TextUtil.isBlank((String)agentReference)) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        if (gdsName != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.gdsName.name(), (Object)gdsName));
        }
        if (agency != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.agency.name(), agency));
        }
        if (salesPoint != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.salesPoint.name(), salesPoint));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GdsReferenceIndex.Property.reference.name(), (Object)agentReference));
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)GdsReferenceIndex.Property.opened.name(), (Object)date), SearchCriterion.eq((String)GdsReferenceIndex.Property.opened.name(), null)}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)GdsReferenceIndex.Property.closed.name(), (Object)date), SearchCriterion.eq((String)GdsReferenceIndex.Property.closed.name(), null)}));
        }
        List gdsReferenceIndexes = EntityStorage.get().search(GdsReferenceIndex.class, query).getData();
        return gdsReferenceIndexes;
    }

    public static List<EntityReference<SalesPoint>> findSalesPointsByCode(String salesPointCode) {
        ArrayList<EntityReference<SalesPoint>> res = new ArrayList<EntityReference<SalesPoint>>();
        if (TextUtil.isBlank((String)salesPointCode)) {
            return res;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SalesPointIndex.Property.code.name(), (Object)salesPointCode));
        List indices = EntityStorage.get().search(SalesPointIndex.class, query).getData();
        for (SalesPointIndex ind : indices) {
            res.add((EntityReference<SalesPoint>)ind.getSource());
        }
        return res;
    }

    public static List<EntityReference<Person>> findAgentsByCode(String agentCode) {
        if (TextUtil.isBlank((String)agentCode)) {
            return Collections.emptyList();
        }
        List<EntityReference<Person>> agentRefs = new ArrayList<EntityReference<Person>>();
        try {
            agentRefs = ProfileDao.getAgentReferenceByCodeAndAgency(agentCode, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return agentRefs;
    }

    public static EntityReference<Person> findAgent(String login) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)login));
        List searchResult = EntityStorage.get().search(PersonIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
        if (searchResult.size() != 1) {
            return null;
        }
        PersonIndex idx = (PersonIndex)searchResult.get(0);
        if (!idx.getTypes().contains(PersonType.AGENT)) {
            return null;
        }
        return idx.getSource();
    }
}

