/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.FinanceProductProxyFopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.booking.finance.FinanceProductProxy;
import com.gridnine.xtrip.common.model.booking.finance.FinanceProductProxyCommission;
import com.gridnine.xtrip.common.model.booking.finance.FinanceProductProxyContractRelation;
import com.gridnine.xtrip.common.model.booking.finance.FinanceProductProxyFop;
import com.gridnine.xtrip.common.model.booking.finance.FinanceProductProxyTraveller;
import com.gridnine.xtrip.common.model.booking.finance.FinanceProductProxyVendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.XCompareHelper;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.ContractorDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.ShipmentProperties;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShipmentHelper {
    private static Logger log = LoggerFactory.getLogger(ShipmentHelper.class);

    public static ShipmentProperties getShipmentsProperties(EntityReference<Organization> organization, boolean strict) {
        ShipmentProperties shipmentsProperties = null;
        EntityContainer organizationContainer = EntityStorage.get().resolve(organization);
        if (organizationContainer != null) {
            shipmentsProperties = ((Organization)organizationContainer.getEntity()).getShipmentProperties();
        }
        if (shipmentsProperties == null && !strict) {
            EntityContainer defaultOrganizationContainer;
            EntityReference defaultOrganization = null;
            if (ProfileHelper.isOrganizationType(organization, (OrganizationType)OrganizationType.AGENCY)) {
                defaultOrganization = ProfileDao.findAllAgenciesProfile();
            } else if (ProfileHelper.isOrganizationType(organization, (OrganizationType)OrganizationType.CORPORATE_CLIENT)) {
                defaultOrganization = ProfileDao.findAllClientsProfile();
            }
            if (defaultOrganization != null && (defaultOrganizationContainer = EntityStorage.get().resolve(organization)) != null) {
                shipmentsProperties = ((Organization)defaultOrganizationContainer.getEntity()).getShipmentProperties();
            }
        }
        return shipmentsProperties;
    }

    public static EntityReference<Organization> getPayerOrganization(EntityReference<? extends BaseProfile> payer) {
        if (payer.getType().isAssignableFrom(Person.class)) {
            return Optional.ofNullable(ProfileHelper.getRetailProfileContainer()).map(item -> item.toReference()).orElse(null);
        }
        if (payer.getType().isAssignableFrom(Organization.class)) {
            return payer;
        }
        return null;
    }

    public static boolean hasRelatedShipment(BaseProduct prod) {
        return prod.getFopDetalizations().values().stream().flatMap(fd -> fd.getComponents().stream()).map(FopComponent::getShipment).anyMatch(Objects::nonNull);
    }

    public static boolean hasClientRelatedShipment(BaseProduct prod) {
        return ShipmentHelper.hasRelatedShipment(prod, GeneralProductHelper.getClientFops((BaseProduct)prod));
    }

    public static boolean hasSubagentRelatedShipment(BaseProduct prod) {
        return ShipmentHelper.hasRelatedShipment(prod, GeneralProductHelper.getSubagentFops((BaseProduct)prod));
    }

    public static boolean hasRelatedShipment(BaseProduct prod, Collection<GeneralProductFop> fops) {
        Set fopsUids = fops.stream().map(BaseIdentity::getUid).collect(Collectors.toSet());
        return prod.getFopDetalizations().entrySet().stream().filter(it -> fopsUids.contains(it.getKey())).flatMap(it -> ((FopDetalization)it.getValue()).getComponents().stream()).anyMatch(it -> it.getShipment() != null);
    }

    public static Set<EntityContainer<Shipment>> getClientRelatedShipments(BaseProduct product) {
        return ShipmentHelper.getRelatedShipments(product, GeneralProductHelper.getClientFops((BaseProduct)product));
    }

    public static Set<EntityContainer<Shipment>> getSubagentRelatedShipments(BaseProduct product) {
        return ShipmentHelper.getRelatedShipments(product, GeneralProductHelper.getSubagentFops((BaseProduct)product));
    }

    public static Set<EntityContainer<Shipment>> getRelatedShipments(BaseProduct product, Collection<GeneralProductFop> fops) {
        Set fopsUids = fops.stream().map(BaseIdentity::getUid).collect(Collectors.toSet());
        return product.getFopDetalizations().entrySet().stream().filter(it -> fopsUids.contains(it.getKey())).flatMap(it -> ((FopDetalization)it.getValue()).getComponents().stream()).map(FopComponent::getShipment).filter(Objects::nonNull).distinct().map(EntityStorageHelper::resolve).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static void checkDeletionFops(Set<EntityContainer<Shipment>> shipments, BaseProduct product, EntityStorageContext storageContext, String message, Object ... parameters) {
        List fopComponentUids = product.getFopDetalizations().values().stream().flatMap(item -> item.getComponents().stream()).map(BaseIdentity::getUid).collect(Collectors.toList());
        for (EntityContainer<Shipment> shipment : shipments) {
            List<BillingItem> billingItems = FinanceDocumentHelper.getBillingItems(((Shipment)shipment.getEntity()).getBillingItems(), storageContext);
            List fopComponents = billingItems.stream().filter(bi -> bi.getProduct() != null && bi.getProduct().getNestedEntityUid().equals(product.getUid())).flatMap(bi -> bi.getFopComponents().stream()).collect(Collectors.toList());
            for (NestedEntityReference fopComponent : fopComponents) {
                if (fopComponentUids.contains(fopComponent.getNestedEntityUid())) continue;
                throw Xeption.forEndUser((String)message, (Object[])parameters);
            }
        }
    }

    public static XCompareHelper.Difference getFinanceDifference(BaseProduct oldProduct, BaseProduct newProduct) throws Exception {
        FinanceProductProxyFopComponent componentProxy;
        FinanceProductProxyFop fopProxy;
        FinanceProductProxyContractRelation relation;
        FinanceProductProxy oldProxy = ShipmentHelper.createProxy(oldProduct, false);
        boolean hasNomenclature = oldProxy.getRelations().stream().flatMap(rel -> rel.getFops().stream()).flatMap(fop -> fop.getComponents().stream()).anyMatch(comp -> comp.getNomenclature() != null);
        HashSet<String> componentsWithShipmentUids = new HashSet<String>();
        Iterator relationIt = oldProxy.getRelations().iterator();
        while (relationIt.hasNext()) {
            FinanceProductProxyContractRelation relation2 = (FinanceProductProxyContractRelation)relationIt.next();
            boolean hasFop = false;
            Iterator fopIt = relation2.getFops().iterator();
            while (fopIt.hasNext()) {
                FinanceProductProxyFop fopProxy2 = (FinanceProductProxyFop)fopIt.next();
                boolean hasShipment = false;
                Iterator componentIt = fopProxy2.getComponents().iterator();
                while (componentIt.hasNext()) {
                    FinanceProductProxyFopComponent componentProxy2 = (FinanceProductProxyFopComponent)componentIt.next();
                    boolean componentHasShipment = ((FopDetalization)oldProduct.getFopDetalizations().get(fopProxy2.getUid())).getComponents().stream().filter(comp -> componentProxy2.getUid().equals(comp.getUid())).anyMatch(comp -> comp.getShipment() != null);
                    if (!componentHasShipment) {
                        componentIt.remove();
                        continue;
                    }
                    hasShipment = true;
                    componentsWithShipmentUids.add(componentProxy2.getUid());
                }
                if (!hasShipment) {
                    fopIt.remove();
                    continue;
                }
                hasFop = true;
            }
            if (hasFop) continue;
            relationIt.remove();
        }
        FinanceProductProxy newProxy = ShipmentHelper.createProxy(newProduct, !hasNomenclature);
        HashSet<String> newComponentsWithoutShipmentUids = new HashSet<String>();
        Iterator relationIt2 = newProxy.getRelations().iterator();
        while (relationIt2.hasNext()) {
            relation = (FinanceProductProxyContractRelation)relationIt2.next();
            boolean hasFop = false;
            Iterator fopIt = relation.getFops().iterator();
            while (fopIt.hasNext()) {
                fopProxy = (FinanceProductProxyFop)fopIt.next();
                boolean hasComponent = false;
                Iterator componentIt = fopProxy.getComponents().iterator();
                while (componentIt.hasNext()) {
                    componentProxy = (FinanceProductProxyFopComponent)componentIt.next();
                    if (!componentsWithShipmentUids.contains(componentProxy.getUid())) {
                        componentIt.remove();
                        continue;
                    }
                    boolean componentHasShipment = ((FopDetalization)newProduct.getFopDetalizations().get(fopProxy.getUid())).getComponents().stream().filter(comp -> componentProxy.getUid().equals(comp.getUid())).anyMatch(comp -> comp.getShipment() != null);
                    if (!componentHasShipment) {
                        newComponentsWithoutShipmentUids.add(componentProxy.getUid());
                        componentIt.remove();
                        continue;
                    }
                    hasComponent = true;
                }
                if (!hasComponent) {
                    fopIt.remove();
                    continue;
                }
                hasFop = true;
            }
            if (hasFop) continue;
            relationIt2.remove();
        }
        relationIt2 = oldProxy.getRelations().iterator();
        while (relationIt2.hasNext()) {
            relation = (FinanceProductProxyContractRelation)relationIt2.next();
            boolean hasFop = false;
            Iterator fopIt = relation.getFops().iterator();
            while (fopIt.hasNext()) {
                fopProxy = (FinanceProductProxyFop)fopIt.next();
                boolean hasComponent = false;
                Iterator componentIt = fopProxy.getComponents().iterator();
                while (componentIt.hasNext()) {
                    componentProxy = (FinanceProductProxyFopComponent)componentIt.next();
                    if (newComponentsWithoutShipmentUids.contains(componentProxy.getUid())) {
                        componentIt.remove();
                        continue;
                    }
                    hasComponent = true;
                }
                if (!hasComponent) {
                    fopIt.remove();
                    continue;
                }
                hasFop = true;
            }
            if (hasFop) continue;
            relationIt2.remove();
        }
        XCompareHelper.Difference diff = XCompareHelper.compare((Object)oldProxy, (Object)newProxy, Collections.emptySet(), Collections.emptySet());
        return diff;
    }

    private static FinanceProductProxy createProxy(BaseProduct prod, boolean setNullForNomeclature) throws Exception {
        FinanceProductProxy proxy = new FinanceProductProxy();
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)prod);
        proxy.setAgent(handler.findIssuingAgent(prod));
        proxy.setIssueDate(handler.findIssueDate(prod));
        proxy.setMcoCategory(handler.getMCOCategory(prod));
        proxy.setProductCategory(handler.getProductCategory(prod));
        for (Traveller trav : handler.getTravellers(prod)) {
            FinanceProductProxyTraveller proxyTrav = new FinanceProductProxyTraveller();
            proxyTrav.setTravellerUid(trav.getUid());
            proxy.getTravellers().add(proxyTrav);
        }
        SalesChain salesChain = handler.getSalesChain(prod);
        if (salesChain != null) {
            for (Contractor contractor : salesChain.getContractors()) {
                EntityContainer description;
                if (contractor.getDescription() == null || (description = EntityStorage.get().resolve(contractor.getDescription())) != null && PredefinedContractorType.TECHNICAL_PROVIDER.equals((Object)((ContractorDescription)description.getEntity()).getPredefinedType())) continue;
                proxy.getContractors().add(contractor);
            }
        }
        for (GeneralProductContractRelationData productRelation : GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)prod)) {
            if (GeneralProductHelper.getContractType((EntityReference)productRelation.getDescription()) == ContractType.VENDOR) continue;
            FinanceProductProxyContractRelation proxyRelation = new FinanceProductProxyContractRelation();
            proxyRelation.setUid(productRelation.getUid());
            proxy.getRelations().add(proxyRelation);
            proxyRelation.setDescription(productRelation.getDescription());
            proxyRelation.getServiceData().setTotalPrice(productRelation.getServiceData().getTotalPrice());
            for (GeneralProductCommission comm : productRelation.getCommissions()) {
                FinanceProductProxyCommission proxyComm = new FinanceProductProxyCommission();
                proxyComm.setUid(comm.getUid());
                proxyComm.setCommissionProperties(comm.getCommissionProperties());
                proxyComm.setEquivalentAmount(comm.getEquivalentAmount());
                proxyRelation.getCommissions().add(proxyComm);
            }
            for (GeneralProductFop fop : productRelation.getFops()) {
                FinanceProductProxyFop proxyFop = new FinanceProductProxyFop();
                proxyFop.setUid(fop.getUid());
                proxyRelation.getFops().add(proxyFop);
                proxyFop.setEquivalentAmount(fop.getEquivalentAmount());
                proxyFop.setPayer(fop.getPayer());
                proxyFop.setType(fop.getType());
                FopDetalization fopDetalization = (FopDetalization)prod.getFopDetalizations().get(fop.getUid());
                if (fopDetalization == null) continue;
                for (FopComponent fopComponent : fopDetalization.getComponents()) {
                    FinanceProductProxyFopComponent proxyFopComponent = new FinanceProductProxyFopComponent();
                    proxyFopComponent.setUid(fopComponent.getUid());
                    proxyFopComponent.setAmount(fopComponent.getAmount());
                    proxyFopComponent.setTravellerUid(fopComponent.getTraveller() == null ? null : fopComponent.getTraveller().getUid());
                    proxyFopComponent.setType(fopComponent.getType());
                    proxyFopComponent.setVatAmount(fopComponent.getVatAmount());
                    proxyFopComponent.setVatRate(fopComponent.getVatRate());
                    proxyFop.getComponents().add(proxyFopComponent);
                    if (setNullForNomeclature) continue;
                    proxyFopComponent.setNomenclature(fopComponent.getNomenclature());
                }
            }
        }
        for (VendorFinanceDocumentData data : prod.getVendorFinanceDocumentsData()) {
            FinanceProductProxyVendorFinanceDocumentData proxyData = new FinanceProductProxyVendorFinanceDocumentData();
            proxyData.setType(data.getType());
            proxyData.setVendorNumber(data.getVendorNumber());
            proxyData.setVendorDate(data.getVendorDate());
            proxyData.setVendorShippingDocumentNumber(data.getVendorShippingDocumentNumber());
            proxyData.setVendorShippingDocumentDate(data.getVendorShippingDocumentDate());
            proxy.getVendorFinanceDocumentsData().add(proxyData);
        }
        return proxy;
    }

    public static boolean isShipmentPayed(Shipment shipment, EntityStorageContext ctx) {
        BigDecimal totalAmount = MiscUtil.guarded((BigDecimal)shipment.getTotalAmountCachedValue());
        return shipment.isAmountChecked() || MiscUtil.equals((Object)totalAmount, (Object)MiscUtil.guarded((BigDecimal)shipment.getPayedAmountCachedValue()));
    }

    public static BigDecimal calculatePayedAmount(Shipment shipment, EntityStorageContext ctx) {
        BigDecimal totalPayedAmount = BigDecimal.ZERO;
        for (NestedEntityReference item : shipment.getPaymentItems()) {
            PaymentItem pi = (PaymentItem)EntityStorageHelper.resolve((NestedEntityReference)item, (EntityStorageContext)ctx);
            if (pi == null || pi.getAmount() == null || pi.getAmount().getValue() == null) continue;
            totalPayedAmount = totalPayedAmount.add(pi.getAmount().getValue());
        }
        return totalPayedAmount;
    }

    public static BigDecimal calculateTotalAmount(Shipment shipment, EntityStorageContext ctx) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (BillingItem item : FinanceDocumentHelper.getBillingItems(shipment.getBillingItems(), ctx)) {
            if (item.getAmount() == null || item.getAmount().getTotal() == null) continue;
            totalAmount = totalAmount.add(item.getAmount().getTotal());
        }
        return totalAmount;
    }

    public static BigDecimal calculateTotalVatAmount(Shipment shipment, EntityStorageContext ctx) {
        BigDecimal vatAmount = null;
        for (BillingItem item : FinanceDocumentHelper.getBillingItems(shipment.getBillingItems(), ctx)) {
            if (item.getAmount() == null) continue;
            vatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{vatAmount, item.getAmount().getVatAmount()});
        }
        return vatAmount;
    }
}

