/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankIndex;
import com.gridnine.xtrip.common.model.stockcontrol.UsageStatus;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StockControlDao {
    public static List<StockBlank> getBlanksByProductUid(String productUid) throws Exception {
        if (TextUtil.isBlank((String)productUid)) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockBlankIndex.Property.productUid.name(), (Object)productUid));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.NEW), SearchCriterion.eq((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.SELL)}));
        ArrayList<StockBlank> result = new ArrayList<StockBlank>();
        for (EntityContainer container : StorageHelper.getEntityContainers((SearchQuery)query, StockBlankIndex.class)) {
            result.add((StockBlank)container.getEntity());
        }
        return result;
    }

    public static EntityContainer<StockBlank> findBlankByScn(String number, boolean includeVoid) throws Exception {
        if (TextUtil.isBlank((String)number)) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)StockBlankIndex.Property.number.name(), (Object)number));
        SearchCriterion criterion = SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.NEW), SearchCriterion.eq((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.SELL)});
        query.getCriteria().getCriterions().add(includeVoid ? SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)StockBlankIndex.Property.usageStatus.name(), (Object)UsageStatus.VOID), criterion}) : criterion);
        List containers = StorageHelper.getEntityContainers((SearchQuery)query, StockBlankIndex.class);
        if (containers.isEmpty()) {
            return null;
        }
        if (containers.size() == 1) {
            return (EntityContainer)containers.get(0);
        }
        for (EntityContainer blank : containers) {
            if (((StockBlank)blank.getEntity()).getUsageStatus() != UsageStatus.NEW) continue;
            return blank;
        }
        return (EntityContainer)containers.get(0);
    }

    private StockControlDao() {
    }
}

