/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SysLogHelper {
    private static final Logger log = LoggerFactory.getLogger(SysLogHelper.class);

    public static void audit(EntityReference<?> ref, String tag, MessageType type, String ... texts) {
        Message[] messages = new Message[texts.length];
        for (int i = 0; i < texts.length; ++i) {
            messages[i] = SystemHelper.createMessage((MessageType)type, (String)texts[i], (Object[])new Object[0]);
        }
        SysLogHelper.audit(ref, tag, messages);
    }

    public static void audit(EntityReference<?> ref, String tag, Collection<Message> messages) {
        SysLogHelper.audit(ref, tag, messages.toArray(new Message[messages.size()]));
    }

    public static void audit(EntityReference<?> ref, String tag, Message ... messages) {
        if (messages.length == 0) {
            return;
        }
        ArrayList<SysLogItem> lst = new ArrayList<SysLogItem>();
        for (Message message : messages) {
            lst.add(com.gridnine.xtrip.common.model.standard.helpers.SysLogHelper.newAuditItem(ref, (String)tag, (Message)message));
        }
        try {
            AssetsStorage.get().save(lst);
        }
        catch (Exception e) {
            log.error("unable to create log item for object " + ref, (Throwable)e);
        }
    }

    private SysLogHelper() {
    }
}

