/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.profile.TrashBinItem;
import com.gridnine.xtrip.common.model.profile.TrashBinItemType;
import com.gridnine.xtrip.common.model.system.ArchivedEntity;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.LoggerFactory;

public final class TrashBinHelper {
    private static final String CREATED_TRASH_BIN_ITEMS_KEY = "createdTrashBinItems";
    private static ThreadLocal<Boolean> ignoreTrashBinFlags = new ThreadLocal();

    public static boolean isIgnoreTrashBin() {
        return Boolean.TRUE.equals(ignoreTrashBinFlags.get());
    }

    public static void setIgnoreTrashBin(boolean value) {
        ignoreTrashBinFlags.set(value);
    }

    public static void clearFlagInfo() {
        ignoreTrashBinFlags.remove();
    }

    private static <E extends BaseEntity> ArchivedEntity createArchive(EntityContainer<E> data) throws Exception {
        ArchivedEntity ett = new ArchivedEntity();
        EntityContainer copy = new EntityContainer(data.getEntityType());
        XCloneModelHelper.copy(data, (BaseEntity)copy);
        copy.setVersionsCount(1);
        copy.getVersionInfo().setVersionNumber(0);
        ett.getVersions().add(data);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SysLogItem.Property.referenceUid.name(), (Object)data.getUid()));
        for (SysLogItem logItem : AssetsStorage.get().search(SysLogItem.class, query).getData()) {
            ett.getAssets().add(logItem);
            AssetsStorage.get().delete((BaseAsset)logItem, true);
        }
        return ett;
    }

    private static boolean isTrashBinItemCreated(TrashBinItemType type, EntityReference<?> ref) {
        Set types = (Set)LogicalStorage.get().getEntityStorage().getLocalOperationContext(ref).getParameters().get(CREATED_TRASH_BIN_ITEMS_KEY);
        if (types == null) {
            return false;
        }
        return types.contains(type);
    }

    private static void registerTrashBinItem(TrashBinItemType type, EntityReference<?> ref) {
        HashSet<TrashBinItemType> types = (HashSet<TrashBinItemType>)LogicalStorage.get().getEntityStorage().getLocalOperationContext(ref).getParameters().get(CREATED_TRASH_BIN_ITEMS_KEY);
        if (types == null) {
            types = new HashSet<TrashBinItemType>();
            LogicalStorage.get().getEntityStorage().getLocalOperationContext(ref).getParameters().put(CREATED_TRASH_BIN_ITEMS_KEY, types);
        }
        types.add(type);
    }

    private TrashBinHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends BaseEntity> EntityContainer<E> restoreTrashBinItem(EntityContainer<TrashBinItem> trashBinItemCtr) {
        TrashBinItem trashBinItem = (TrashBinItem)trashBinItemCtr.getEntity();
        EntityContainer ctr = null;
        LogicalSession ls = LogicalStorage.get().beginUnitOfWork();
        try {
            if (trashBinItem.getRestoreData() == null) {
                LogicalStorage.get().getEntityStorage().restore(trashBinItem.getOriginalEntity());
            } else {
                ctr = (EntityContainer)trashBinItem.getRestoreData().getVersions().get(0);
                LogicalEntityStorage.clearRevision((EntityContainer)ctr);
                ctr.getVersionInfo().setDataSource("trash-bin-restore");
                ctr.getVersionInfo().setVersionNumber(0);
                ctr.setVersionsCount(1);
                EntityStorage.get().save(ctr, false);
                for (BaseAsset item : trashBinItem.getRestoreData().getAssets()) {
                    LogicalStorage.get().getAssetStorage().save(item);
                }
            }
            LogicalStorage.get().getEntityStorage().delete(trashBinItemCtr);
            LogicalStorage.get().endUnitOfWork(ls, true);
        }
        finally {
            LogicalStorage.get().cancelUnitOfWork(ls);
        }
        return ctr;
    }

    public static void createTrashBinItem(TrashBinItemType type, EntityContainer<?> data, SessionCallback ss) throws Exception {
        if (TrashBinHelper.isTrashBinItemCreated(type, data.toReference())) {
            return;
        }
        TrashBinItem result = new TrashBinItem();
        result.setCreated(data.getCreated());
        result.setCreatedBy(data.getCreatedBy());
        result.setDeleted(new Date());
        result.setDeletedBy(LogicalStorage.get().getUser());
        result.setOriginalEntity(data.toReference());
        result.setDescription(data.getEntity().toString());
        result.setAggregatedData(data.getEntity().toString());
        result.setRestoreData(TrashBinHelper.createArchive(data));
        result.setType(type);
        if (data.getEntity() instanceof CompositeNumber) {
            result.setNumber(((CompositeNumber)data.getEntity()).getNumber());
        }
        if (data.getEntity() instanceof Shipment) {
            result.setDocumentDate(((Shipment)data.getEntity()).getDate());
            result.setSupplier(((Shipment)data.getEntity()).getSupplier());
        }
        final EntityContainer ctr = EntityContainer.create((BaseEntity)result);
        ctr.getVersionInfo().setDataSource("trash-bin-create");
        ss.addCallback(new Callback(){
            private static final long serialVersionUID = 1105573670064472434L;

            public void execute(SessionCallback ss1) {
                try {
                    ctr.getVersionInfo().setDataSource("trash bin interceptor");
                    EntityStorage.get().save(ctr, false);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("unable to save trash item " + ctr.getEntity(), (Throwable)e);
                }
            }
        });
        TrashBinHelper.registerTrashBinItem(type, data.toReference());
    }
}

