/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.List;
import java.util.Map;

public class AdditionalServiceProductCloneHelper {
    public static void clone(AdditionalServiceProduct source, AdditionalServiceProduct target) throws Exception {
        ProductCloneHelper.clone(source, target, new AdditionalServiceProductCloneSourceHandler(), new AdditionalServiceProductCloneTargetHandler());
    }

    public static void clone(AdditionalServiceProduct source, AdditionalServiceProduct target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new AdditionalServiceProductCloneSourceHandler());
    }

    public static class AdditionalServiceProductCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<AdditionalServiceProduct> {
        @Override
        public void update(AdditionalServiceProduct product) {
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class AdditionalServiceProductCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<AdditionalServiceProduct> {
        private Reservation reservation;
        private List<Traveller> travellers;

        @Override
        public void before(AdditionalServiceProduct product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.travellers.clear();
            this.travellers.addAll(product.getTravellers());
            product.setReservation(null);
            if (!cloneTraveller) {
                product.getTravellers().clear();
            }
        }

        @Override
        public void after(AdditionalServiceProduct product) {
            product.setReservation(this.reservation);
            product.getTravellers().clear();
            product.getTravellers().addAll(this.travellers);
        }
    }
}

