/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.Map;

public class AeroexpressTicketCloneHelper {
    public static void clone(AeroexpressTicket source, AeroexpressTicket target) throws Exception {
        ProductCloneHelper.clone(source, target, new AeroexpressTicketCloneSourceHandler(), new AeroexpressTicketCloneTargetHandler());
    }

    public static void clone(AeroexpressTicket source, AeroexpressTicket target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new AeroexpressTicketCloneSourceHandler());
    }

    public static class AeroexpressTicketCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<AeroexpressTicket> {
        @Override
        public void update(AeroexpressTicket product) {
            product.setPenalty(null);
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class AeroexpressTicketCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<AeroexpressTicket> {
        private Reservation reservation;
        private AeroexpressTicket previousProduct;
        private AeroexpressTicket nextProduct;
        private Product relatedProduct;
        private Traveller traveller;

        @Override
        public void before(AeroexpressTicket product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.previousProduct = product.getPreviousProduct();
            this.nextProduct = product.getNextProduct();
            this.relatedProduct = product.getRelatedProduct();
            this.traveller = product.getTraveller();
            product.setReservation(null);
            product.setPreviousProduct(null);
            product.setNextProduct(null);
            product.setRelatedProduct(null);
            if (!cloneTraveller) {
                product.setTraveller(null);
            }
        }

        @Override
        public void after(AeroexpressTicket product) {
            product.setReservation(this.reservation);
            product.setPreviousProduct(this.previousProduct);
            product.setNextProduct(this.nextProduct);
            product.setRelatedProduct(this.relatedProduct);
            product.setTraveller(this.traveller);
        }
    }
}

