/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.Map;

public class AgencyMemoProductCloneHelper {
    public static void clone(AgencyMemoProduct source, AgencyMemoProduct target) throws Exception {
        ProductCloneHelper.clone(source, target, new AgencyMemoProductCloneSourceHandler(), new AgencyMemoProductCloneTargetHandler());
    }

    public static void clone(AgencyMemoProduct source, AgencyMemoProduct target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new AgencyMemoProductCloneSourceHandler());
    }

    public static class AgencyMemoProductCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<AgencyMemoProduct> {
        @Override
        public void update(AgencyMemoProduct product) {
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class AgencyMemoProductCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<AgencyMemoProduct> {
        private Reservation reservation;

        @Override
        public void before(AgencyMemoProduct product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            product.setReservation(null);
        }

        @Override
        public void after(AgencyMemoProduct product) {
            product.setReservation(this.reservation);
        }
    }
}

