/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.misc.AgentTouch;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.Map;

public class AgentTouchCloneHelper {
    public static void clone(AgentTouch source, AgentTouch target) throws Exception {
        ProductCloneHelper.clone(source, target, new AgentTouchCloneSourceHandler(), new AgentTouchCloneTargetHandler());
    }

    public static void clone(AgentTouch source, AgentTouch target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new AgentTouchCloneSourceHandler());
    }

    public static class AgentTouchCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<AgentTouch> {
        @Override
        public void update(AgentTouch product) {
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class AgentTouchCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<AgentTouch> {
        private Reservation reservation;

        @Override
        public void before(AgentTouch product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            product.setReservation(null);
        }

        @Override
        public void after(AgentTouch product) {
            product.setReservation(this.reservation);
        }
    }
}

