/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AirProductCloneHelper {
    public static void clone(Product source, Product target) throws Exception {
        ProductCloneHelper.clone(source, target, new AirProductCloneSourceHandler(), new AirProductCloneTargetHandler());
    }

    public static void clone(Product source, Product target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new AirProductCloneSourceHandler());
    }

    public static class AirProductCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<Product> {
        @Override
        public void update(Product product) {
            product.setPenalty(null);
            product.setTotalVendorEquivalentVatAmount(null);
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class AirProductCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<Product> {
        private Reservation reservation;
        private Product previousProduct;
        private Product nextProduct;
        private Traveller traveller;
        private final List<Product> relatedProducts = new ArrayList<Product>();

        @Override
        public void before(Product product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.previousProduct = product.getPreviousProduct();
            this.nextProduct = product.getNextProduct();
            this.traveller = product.getTraveller();
            this.relatedProducts.clear();
            this.relatedProducts.addAll(product.getRelatedProducts());
            product.setReservation(null);
            product.setPreviousProduct(null);
            product.setNextProduct(null);
            if (!cloneTraveller) {
                product.setTraveller(null);
            }
            product.getRelatedProducts().clear();
        }

        @Override
        public void after(Product product) {
            product.setReservation(this.reservation);
            product.setPreviousProduct(this.previousProduct);
            product.setNextProduct(this.nextProduct);
            product.setTraveller(this.traveller);
            product.getRelatedProducts().clear();
            product.getRelatedProducts().addAll(this.relatedProducts);
        }
    }
}

