/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.Map;

public class CarRentalProductCloneHelper {
    public static void clone(CarRentalProduct source, CarRentalProduct target) throws Exception {
        ProductCloneHelper.clone(source, target, new CarRentalProductCloneSourceHandler(), new CarRentalProductCloneTargetHandler());
    }

    public static void clone(CarRentalProduct source, CarRentalProduct target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new CarRentalProductCloneSourceHandler());
    }

    public static class CarRentalProductCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<CarRentalProduct> {
        @Override
        public void update(CarRentalProduct product) {
            product.setPenalty(null);
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class CarRentalProductCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<CarRentalProduct> {
        private Reservation reservation;
        private CarRentalProduct previousProduct;
        private CarRentalProduct nextProduct;

        @Override
        public void before(CarRentalProduct product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.previousProduct = product.getPreviousProduct();
            this.nextProduct = product.getNextProduct();
            product.setReservation(null);
            product.setPreviousProduct(null);
            product.setNextProduct(null);
        }

        @Override
        public void after(CarRentalProduct product) {
            product.setReservation(this.reservation);
            product.setPreviousProduct(this.previousProduct);
            product.setNextProduct(this.nextProduct);
        }
    }
}

