/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.Map;

public class DeliveryCloneHelper {
    public static void clone(Delivery source, Delivery target) throws Exception {
        ProductCloneHelper.clone(source, target, new DeliveryCloneSourceHandler(), new DeliveryCloneTargetHandler());
    }

    public static void clone(Delivery source, Delivery target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new DeliveryCloneSourceHandler());
    }

    public static class DeliveryCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<Delivery> {
        @Override
        public void update(Delivery product) {
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class DeliveryCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<Delivery> {
        private Reservation reservation;
        private Delivery previousProduct;
        private Delivery nextProduct;

        @Override
        public void before(Delivery product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.previousProduct = product.getPreviousProduct();
            this.nextProduct = product.getNextProduct();
            product.setReservation(null);
            product.setPreviousProduct(null);
            product.setNextProduct(null);
        }

        @Override
        public void after(Delivery product) {
            product.setReservation(this.reservation);
            product.setPreviousProduct(this.previousProduct);
            product.setNextProduct(this.nextProduct);
        }
    }
}

