/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.clone.HotelProductUpdateHandler;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HotelProductCloneHelper {
    public static void clone(HotelProduct source, HotelProduct target) throws Exception {
        ProductCloneHelper.clone(source, target, new HotelProductCloneSourceHandler(), new HotelProductCloneTargetHandler());
    }

    public static void clone(HotelProduct source, HotelProduct target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new HotelProductCloneSourceHandler());
    }

    public static class HotelProductCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<HotelProduct> {
        @Override
        public void update(HotelProduct product) {
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.setDescription(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
            ServerHandlersRegistry registry = (ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class);
            for (HotelProductUpdateHandler handler : registry.getAllHotelProductUpdateHandlers()) {
                handler.update(product);
            }
        }
    }

    public static class HotelProductCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<HotelProduct> {
        private Reservation reservation;
        private HotelProduct previousProduct;
        private HotelProduct nextProduct;
        private final List<Traveller> travellers = new ArrayList<Traveller>();

        @Override
        public void before(HotelProduct product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.previousProduct = product.getPreviousProduct();
            this.nextProduct = product.getNextProduct();
            this.travellers.clear();
            this.travellers.addAll(product.getTravellers());
            product.setReservation(null);
            product.setPreviousProduct(null);
            product.setNextProduct(null);
            if (!cloneTraveller) {
                product.getTravellers().clear();
            }
        }

        @Override
        public void after(HotelProduct product) {
            product.setReservation(this.reservation);
            product.setPreviousProduct(this.previousProduct);
            product.setNextProduct(this.nextProduct);
            product.getTravellers().clear();
            product.getTravellers().addAll(this.travellers);
        }
    }
}

