/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.Map;

public class InsuranceAccidentCloneHelper {
    public static void clone(InsuranceAccident source, InsuranceAccident target) throws Exception {
        ProductCloneHelper.clone(source, target, new InsuranceAccidentCloneSourceHandler(), new InsuranceAccidentCloneTargetHandler());
    }

    public static void clone(InsuranceAccident source, InsuranceAccident target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new InsuranceAccidentCloneSourceHandler());
    }

    public static class InsuranceAccidentCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<InsuranceAccident> {
        @Override
        public void update(InsuranceAccident product) {
            product.setRelatedProductUid(null);
            product.setTravellerUid(null);
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class InsuranceAccidentCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<InsuranceAccident> {
        private Reservation reservation;
        private InsuranceAccident previousProduct;
        private InsuranceAccident nextProduct;

        @Override
        public void before(InsuranceAccident product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.previousProduct = product.getPreviousProduct();
            this.nextProduct = product.getNextProduct();
            product.setReservation(null);
            product.setPreviousProduct(null);
            product.setNextProduct(null);
        }

        @Override
        public void after(InsuranceAccident product) {
            product.setReservation(this.reservation);
            product.setPreviousProduct(this.previousProduct);
            product.setNextProduct(this.nextProduct);
        }
    }
}

