/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.Map;

public class InsuranceTouristicCloneHelper {
    public static void clone(InsuranceTouristic source, InsuranceTouristic target) throws Exception {
        ProductCloneHelper.clone(source, target, new InsuranceTouristicCloneSourceHandler(), new InsuranceTouristicCloneTargetHandler());
    }

    public static void clone(InsuranceTouristic source, InsuranceTouristic target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new InsuranceTouristicCloneSourceHandler());
    }

    public static class InsuranceTouristicCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<InsuranceTouristic> {
        @Override
        public void update(InsuranceTouristic product) {
            product.setRelatedProductUid(null);
            product.setRelatedProductType(null);
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getTravellersUids().clear();
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class InsuranceTouristicCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<InsuranceTouristic> {
        private Reservation reservation;
        private InsuranceTouristic previousProduct;
        private InsuranceTouristic nextProduct;

        @Override
        public void before(InsuranceTouristic product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.previousProduct = product.getPreviousProduct();
            this.nextProduct = product.getNextProduct();
            product.setReservation(null);
            product.setPreviousProduct(null);
            product.setNextProduct(null);
        }

        @Override
        public void after(InsuranceTouristic product) {
            product.setReservation(this.reservation);
            product.setPreviousProduct(this.previousProduct);
            product.setNextProduct(this.nextProduct);
        }
    }
}

