/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class McoFeesCloneHelper {
    public static void clone(MCOFees source, MCOFees target) throws Exception {
        ProductCloneHelper.clone(source, target, new McoFeesCloneSourceHandler(), new McoFeesCloneTargetHandler());
    }

    public static void clone(MCOFees source, MCOFees target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new McoFeesCloneSourceHandler());
    }

    public static class McoFeesCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<MCOFees> {
        @Override
        public void update(MCOFees product) {
            product.setTravellerUid(null);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class McoFeesCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<MCOFees> {
        private Reservation reservation;
        private MCOFees previousProduct;
        private MCOFees nextProduct;
        private final List<MCOFeesSource> sources = new ArrayList<MCOFeesSource>();

        @Override
        public void before(MCOFees product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.previousProduct = product.getPreviousMCO();
            this.nextProduct = product.getNextMCO();
            this.sources.clear();
            this.sources.addAll(product.getSources());
            product.setReservation(null);
            product.setPreviousMCO(null);
            product.setNextMCO(null);
            product.getSources().clear();
        }

        @Override
        public void after(MCOFees product) {
            product.setReservation(this.reservation);
            product.setPreviousMCO(this.previousProduct);
            product.setNextMCO(this.nextProduct);
            product.getSources().clear();
            product.getSources().addAll(this.sources);
        }
    }
}

