/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;

public class ProductCloneHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P extends BaseProduct> void clone(P source, P target, ProductCloneSourceHandler<P> sourceHandler, ProductCloneTargetHandler<P> targetHandler) throws Exception {
        sourceHandler.before(source, false);
        try {
            ProductHandler sourceProductHandler = ProductHandler.of(source);
            HashSet excludedUids = new HashSet();
            if (sourceProductHandler.getStatisticalData(source) != null) {
                excludedUids.addAll(sourceProductHandler.getStatisticalData(source).getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).map(costCode -> costCode.getCostCodeProperties().getUid()).collect(Collectors.toSet()));
                excludedUids.addAll(sourceProductHandler.getStatisticalData(source).getTravellerCostCodes().stream().filter(travellerCostCode -> travellerCostCode.getTraveller() != null).map(travellerCostCodes -> travellerCostCodes.getTraveller().getUid()).collect(Collectors.toSet()));
            }
            XCloneModelHelper.copy(source, target, (boolean)true, excludedUids);
            targetHandler.update(target);
        }
        finally {
            sourceHandler.after(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P extends BaseProduct> void clone(P source, P target, Map<String, String> uidsMapping, ProductCloneSourceHandler<P> sourceHandler) throws Exception {
        sourceHandler.before(source, true);
        try {
            XCloneModelHelper.copy(source, target, (boolean)true, uidsMapping);
        }
        finally {
            sourceHandler.after(source);
        }
    }

    public static interface ProductCloneTargetHandler<P extends BaseProduct> {
        public void update(P var1);
    }

    public static interface ProductCloneSourceHandler<P extends BaseProduct> {
        public void before(P var1, boolean var2);

        public void after(P var1);
    }
}

