/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.Map;

public class ProductVoidingCloneHelper {
    public static void clone(ProductVoiding source, ProductVoiding target) throws Exception {
        ProductCloneHelper.clone(source, target, new ProductVoidingCloneSourceHandler(), new ProductVoidingCloneTargetHandler());
    }

    public static void clone(ProductVoiding source, ProductVoiding target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new ProductVoidingCloneSourceHandler());
    }

    public static class ProductVoidingCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<ProductVoiding> {
        @Override
        public void update(ProductVoiding product) {
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class ProductVoidingCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<ProductVoiding> {
        private Reservation reservation;
        private BaseProduct relatedProduct;

        @Override
        public void before(ProductVoiding product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.relatedProduct = product.getRelatedProduct();
            product.setReservation(null);
            product.setRelatedProduct(null);
        }

        @Override
        public void after(ProductVoiding product) {
            product.setReservation(this.reservation);
            product.setRelatedProduct(this.relatedProduct);
        }
    }
}

