/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TaxiCloneHelper {
    public static void clone(TaxiProduct source, TaxiProduct target) throws Exception {
        ProductCloneHelper.clone(source, target, new TaxiProductCloneSourceHandler(), new TaxiProductCloneTargetHandler());
    }

    public static void clone(TaxiProduct source, TaxiProduct target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new TaxiProductCloneSourceHandler());
    }

    public static class TaxiProductCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<TaxiProduct> {
        @Override
        public void update(TaxiProduct product) {
            product.setPenalty(null);
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class TaxiProductCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<TaxiProduct> {
        private Reservation reservation;
        private TaxiProduct previousProduct;
        private TaxiProduct nextProduct;
        private final List<Traveller> travellers = new ArrayList<Traveller>();

        @Override
        public void before(TaxiProduct product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.previousProduct = product.getPreviousProduct();
            this.nextProduct = product.getNextProduct();
            this.travellers.clear();
            this.travellers.addAll(product.getTravellers());
            product.setReservation(null);
            product.setPreviousProduct(null);
            product.setNextProduct(null);
            if (!cloneTraveller) {
                product.getTravellers().clear();
            }
        }

        @Override
        public void after(TaxiProduct product) {
            product.setReservation(this.reservation);
            product.setPreviousProduct(this.previousProduct);
            product.setNextProduct(this.nextProduct);
            product.getTravellers().clear();
            product.getTravellers().addAll(this.travellers);
        }
    }
}

