/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TransferCloneHelper {
    public static void clone(Transfer source, Transfer target) throws Exception {
        ProductCloneHelper.clone(source, target, new TransferCloneSourceHandler(), new TransferCloneTargetHandler());
    }

    public static void clone(Transfer source, Transfer target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new TransferCloneSourceHandler());
    }

    public static class TransferCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<Transfer> {
        @Override
        public void update(Transfer product) {
            product.setPenalty(null);
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class TransferCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<Transfer> {
        private Reservation reservation;
        private Transfer previousProduct;
        private Transfer nextProduct;
        private final List<Traveller> travellers = new ArrayList<Traveller>();

        @Override
        public void before(Transfer product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.previousProduct = product.getPreviousProduct();
            this.nextProduct = product.getNextProduct();
            this.travellers.clear();
            this.travellers.addAll(product.getTravellers());
            product.setReservation(null);
            product.setPreviousProduct(null);
            product.setNextProduct(null);
            if (!cloneTraveller) {
                product.getTravellers().clear();
            }
        }

        @Override
        public void after(Transfer product) {
            product.setReservation(this.reservation);
            product.setPreviousProduct(this.previousProduct);
            product.setNextProduct(this.nextProduct);
            product.getTravellers().clear();
            product.getTravellers().addAll(this.travellers);
        }
    }
}

