/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UniversalProductCloneHelper {
    public static void clone(UniversalProduct source, UniversalProduct target) throws Exception {
        ProductCloneHelper.clone(source, target, new UniversalProductCloneSourceHandler(), new UniversalProductCloneTargetHandler());
    }

    public static void clone(UniversalProduct source, UniversalProduct target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new UniversalProductCloneSourceHandler());
    }

    public static class UniversalProductCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<UniversalProduct> {
        @Override
        public void update(UniversalProduct product) {
            product.setPenalty(null);
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getTravellersUids().clear();
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
            product.getRelatedDocuments().clear();
        }
    }

    public static class UniversalProductCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<UniversalProduct> {
        private Reservation reservation;
        private UniversalProduct previousProduct;
        private UniversalProduct nextProduct;
        private List<String> travellersUids = new ArrayList<String>();

        @Override
        public void before(UniversalProduct product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.previousProduct = product.getPreviousProduct();
            this.nextProduct = product.getNextProduct();
            product.setReservation(null);
            product.setPreviousProduct(null);
            product.setNextProduct(null);
            this.travellersUids.clear();
            this.travellersUids.addAll(product.getTravellersUids());
            if (!cloneTraveller) {
                product.getTravellersUids().clear();
            }
        }

        @Override
        public void after(UniversalProduct product) {
            product.setReservation(this.reservation);
            product.setPreviousProduct(this.previousProduct);
            product.setNextProduct(this.nextProduct);
            product.getTravellersUids().clear();
            product.getTravellersUids().addAll(this.travellersUids);
        }
    }
}

