/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.clone;

import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VisaProductCloneHelper {
    public static void clone(VisaProduct source, VisaProduct target) throws Exception {
        ProductCloneHelper.clone(source, target, new VisaProductCloneSourceHandler(), new VisaProductCloneTargetHandler());
    }

    public static void clone(VisaProduct source, VisaProduct target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone(source, target, uidsMapping, new VisaProductCloneSourceHandler());
    }

    public static class VisaProductCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<VisaProduct> {
        @Override
        public void update(VisaProduct product) {
            product.setPenalty(null);
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.setShipmentsDateSubagent(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class VisaProductCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<VisaProduct> {
        private Reservation reservation;
        private VisaProduct previousProduct;
        private VisaProduct nextProduct;
        private List<Traveller> travellers;

        @Override
        public void before(VisaProduct product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.previousProduct = product.getPreviousProduct();
            this.nextProduct = product.getNextProduct();
            this.travellers = new ArrayList<Traveller>(product.getTravellers());
            product.setReservation(null);
            product.setPreviousProduct(null);
            product.setNextProduct(null);
            if (!cloneTraveller) {
                product.getTravellers().clear();
            }
        }

        @Override
        public void after(VisaProduct product) {
            product.setReservation(this.reservation);
            product.setPreviousProduct(this.previousProduct);
            product.setNextProduct(this.nextProduct);
            product.getTravellers().addAll(this.travellers);
        }
    }
}

