/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.erasure;

import com.gridnine.xtrip.common.model.erasure.ErasureSearchCriterionType;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.server.model.helpers.erasure.PassportInfo;
import com.gridnine.xtrip.server.model.helpers.erasure.PersonalData;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractPersonalData
implements PersonalData {
    private Set<String> lastNameVariants;
    private Set<String> firstNameVariants;
    private LocalDate birthDate;
    private List<PassportInfo> passportInfos;
    private Set<String> emails;
    private Set<String> phones;

    @Override
    public boolean contains(ErasureSearchCriterionType type) {
        boolean result = false;
        switch (type) {
            case BIRTH_DATE: {
                result = this.getBirthDate() != null;
                break;
            }
            case PERSON_NAME: {
                result = !this.getLastNameVariants().isEmpty() && !this.getFirstNameVariants().isEmpty();
                break;
            }
            case PASSPORT: {
                result = !this.getPassportInfos().isEmpty();
                break;
            }
            case EMAIL: {
                result = !this.getEmails().isEmpty();
                break;
            }
            case PHONE: {
                result = !this.getPhones().isEmpty();
                break;
            }
        }
        return result;
    }

    @Override
    public Set<String> getLastNameVariants() {
        this.lastNameVariants = this.lastNameVariants == null ? this.calculateLastNameVariants() : this.lastNameVariants;
        return this.lastNameVariants;
    }

    protected abstract Set<String> calculateLastNameVariants();

    protected Set<String> lastNameVariantsFromPassports() {
        return this.getPassports().stream().map(p -> p.getLastName()).filter(n -> StringUtils.isNotBlank((String)n)).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getFirstNameVariants() {
        this.firstNameVariants = this.firstNameVariants == null ? this.calculateFirstNameVariants() : this.firstNameVariants;
        return this.firstNameVariants;
    }

    protected abstract Set<String> calculateFirstNameVariants();

    protected Set<String> firstNameVariantsFromPassports() {
        return this.getPassports().stream().map(p -> p.getFirstName()).filter(n -> StringUtils.isNotBlank((String)n)).collect(Collectors.toSet());
    }

    protected Set<String> middleNameVariantsFromPassports() {
        return this.getPassports().stream().flatMap(p -> Arrays.asList(p.getMiddleName(), p.getSecondName()).stream()).filter(n -> StringUtils.isNotBlank((String)n)).collect(Collectors.toSet());
    }

    @Override
    public LocalDate getBirthDate() {
        this.birthDate = this.birthDate == null ? this.calculateBirthDate() : this.birthDate;
        return this.birthDate;
    }

    protected abstract LocalDate calculateBirthDate();

    protected Date birthDateFromPassports() {
        return this.getPassports().stream().map(p -> p.getBirthday()).filter(d -> d != null).findFirst().orElse(null);
    }

    @Override
    public List<PassportInfo> getPassportInfos() {
        if (this.passportInfos == null) {
            List<Passport> passports = this.getPassports();
            this.passportInfos = new ArrayList<PassportInfo>(passports.size());
            for (Passport passport : passports) {
                PassportInfo passportInfo = this.passportInfo(passport);
                if (passportInfo == null) continue;
                this.passportInfos.add(passportInfo);
            }
        }
        return this.passportInfos;
    }

    protected PassportInfo passportInfo(Passport passport) {
        PassportInfo result = passport != null && !StringUtils.isBlank((String)passport.getNumber()) && passport.getType() != null ? new PassportInfo(passport.getNumber(), passport.getType()) : null;
        return result;
    }

    protected abstract List<Passport> getPassports();

    @Override
    public Set<String> getEmails() {
        this.emails = this.emails == null ? this.emails(this.getCommunications()) : this.emails;
        return this.emails;
    }

    protected <T extends Communication> Set<String> emails(List<T> communications) {
        return communications.stream().map(c -> this.email((Communication)c)).filter(n -> n != null).collect(Collectors.toSet());
    }

    protected abstract String email(Communication var1);

    @Override
    public Set<String> getPhones() {
        this.phones = this.phones == null ? this.phones(this.getCommunications()) : this.phones;
        return this.phones;
    }

    protected <T extends Communication> Set<String> phones(List<T> communications) {
        return ProfileHelper.getPhoneCommunications(communications).stream().map(c -> this.phone((Communication)c)).filter(n -> n != null).collect(Collectors.toSet());
    }

    protected abstract String phone(Communication var1);

    protected abstract <T extends Communication> List<T> getCommunications();
}

