/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.erasure;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.misc.StorageUtil;
import com.gridnine.xtrip.common.model.erasure.BatchErasureParams;
import com.gridnine.xtrip.common.model.erasure.BirthDateCriterion;
import com.gridnine.xtrip.common.model.erasure.Correspondence;
import com.gridnine.xtrip.common.model.erasure.EmailCriterion;
import com.gridnine.xtrip.common.model.erasure.ErasureRequest;
import com.gridnine.xtrip.common.model.erasure.ErasureRequestIndex;
import com.gridnine.xtrip.common.model.erasure.ErasureRequestStatus;
import com.gridnine.xtrip.common.model.erasure.ErasureSearchCriterion;
import com.gridnine.xtrip.common.model.erasure.ErasureSearchCriterionType;
import com.gridnine.xtrip.common.model.erasure.GenericErasureParams;
import com.gridnine.xtrip.common.model.erasure.IndividualErasureParams;
import com.gridnine.xtrip.common.model.erasure.PassportCriterion;
import com.gridnine.xtrip.common.model.erasure.PersonNameCriterion;
import com.gridnine.xtrip.common.model.erasure.PersonRefCriterion;
import com.gridnine.xtrip.common.model.erasure.PhoneCriterion;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.model.helpers.erasure.AbstractPersonalData;
import com.gridnine.xtrip.server.model.helpers.erasure.PersonalData;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class ErasureHelper {
    public static ErasureHelper getInstance() {
        return (ErasureHelper)Environment.getPublished(ErasureHelper.class);
    }

    public EntityContainer<ErasureRequest> createAndSaveRequest(GenericErasureParams params) {
        ErasureRequest request = this.buildErasureRequest(params);
        EntityContainer result = EntityContainer.create((BaseEntity)request);
        result = StorageUtil.save((EntityContainer)result, (String)"creating-request", (boolean)true);
        return result;
    }

    private ErasureRequest buildErasureRequest(GenericErasureParams params) {
        ErasureRequest result = new ErasureRequest();
        result.setNumber(this.newNumber());
        result.setStatus(ErasureRequestStatus.INITIAL);
        result.setParams(params);
        return result;
    }

    public void validate(BatchErasureParams params) {
        if (params == null) {
            throw new IllegalArgumentException("parameter must not be null");
        }
        if (params.getCompany() == null) {
            throw new IllegalArgumentException("organization is required");
        }
    }

    public void validate(IndividualErasureParams params) {
        if (params == null) {
            throw new IllegalArgumentException("parameter must not be null");
        }
        boolean passport = false;
        for (ErasureSearchCriterion criterion : params.getCriteria()) {
            switch (criterion.getType()) {
                case PERSON_NAME: {
                    this.validate((PersonNameCriterion)criterion);
                    break;
                }
                case PASSPORT: {
                    this.validate((PassportCriterion)criterion);
                    passport = true;
                    break;
                }
            }
        }
        if (!passport) {
            throw new IllegalArgumentException("document is required");
        }
    }

    public void validate(PersonNameCriterion name) {
        if (StringUtils.isBlank((String)name.getLastName())) {
            throw new IllegalArgumentException("lastname is required");
        }
        if (StringUtils.isBlank((String)name.getFirstName())) {
            throw new IllegalArgumentException("firstname is required");
        }
    }

    public void validate(PassportCriterion criterion) {
        if (StringUtils.isBlank((String)criterion.getNumber())) {
            throw new IllegalArgumentException("document number is required");
        }
    }

    public <T extends ErasureSearchCriterion> List<T> criterions(IndividualErasureParams params, ErasureSearchCriterionType type) {
        ArrayList<ErasureSearchCriterion> result = new ArrayList<ErasureSearchCriterion>();
        for (ErasureSearchCriterion criterion : params.getCriteria()) {
            if (type != criterion.getType()) continue;
            result.add(criterion);
        }
        return result;
    }

    public void reset(ErasureRequest request) {
        request.getSearchResult().clear();
        GenericErasureParams params = request.getParams();
        switch (params.getType()) {
            case INDIVIDUAL: {
                this.reset((IndividualErasureParams)params);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(IndividualErasureParams params) {
        IndividualErasureParams individualErasureParams = params;
        synchronized (individualErasureParams) {
            Iterator iterator = params.getCriteria().iterator();
            while (iterator.hasNext()) {
                ErasureSearchCriterion criterion = (ErasureSearchCriterion)iterator.next();
                if (criterion.isPrimary()) continue;
                iterator.remove();
            }
        }
    }

    private String newNumber() {
        try {
            String result = SequenceNumberHelper.generateNumber(ErasureRequest.class, ErasureRequestIndex.class, (String)ErasureRequestIndex.Property.number.name());
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected PersonalData newPersonalData(final EntityContainer<Person> ctr) {
        return new AbstractPersonalData(){

            @Override
            protected LocalDate calculateBirthDate() {
                Date date = ((Person)ctr.getEntity()).getBirthday();
                date = date == null ? this.birthDateFromPassports() : date;
                return MiscUtil.toLocalDate((Date)date);
            }

            @Override
            protected Set<String> calculateLastNameVariants() {
                HashSet<String> result = new HashSet<String>(this.nameVariants(((Person)ctr.getEntity()).getLastName()));
                result.addAll(this.lastNameVariantsFromPassports());
                return result;
            }

            @Override
            protected Set<String> calculateFirstNameVariants() {
                HashSet<String> result = new HashSet<String>(this.nameVariants(((Person)ctr.getEntity()).getFirstName()));
                result.addAll(this.firstNameVariantsFromPassports());
                return result;
            }

            @Override
            public EntityReference<Person> getProfile() {
                return ctr.toReference();
            }

            @Override
            public Set<String> getMiddleNameVariants() {
                HashSet<String> result = new HashSet<String>();
                result.addAll(this.nameVariants(((Person)ctr.getEntity()).getMiddleName()));
                result.addAll(this.nameVariants(((Person)ctr.getEntity()).getSecondName()));
                result.addAll(this.middleNameVariantsFromPassports());
                return result;
            }

            @Override
            protected String email(Communication communication) {
                return ErasureHelper.this.email(communication);
            }

            @Override
            protected String phone(Communication communication) {
                return ErasureHelper.this.phone(communication);
            }

            protected List<PersonCommunication> getCommunications() {
                return ((Person)ctr.getEntity()).getCommunications();
            }

            @Override
            protected List<Passport> getPassports() {
                return ((Person)ctr.getEntity()).getPassports();
            }

            Set<String> nameVariants(L10nString l10n) {
                HashSet result = l10n != null ? new HashSet(l10n.getValues().values()) : Collections.emptySet();
                return result;
            }
        };
    }

    protected PersonalData newPersonalData(final Customer customer) {
        return new AbstractPersonalData(){

            @Override
            protected LocalDate calculateBirthDate() {
                Passport passport = customer.getPassport();
                Date date = passport != null ? passport.getBirthday() : null;
                return date != null ? MiscUtil.toLocalDate((Date)date) : null;
            }

            @Override
            protected Set<String> calculateLastNameVariants() {
                HashSet<String> result = new HashSet<String>(this.lastNameVariantsFromPassports());
                return result;
            }

            @Override
            protected Set<String> calculateFirstNameVariants() {
                HashSet<String> result = new HashSet<String>(this.firstNameVariantsFromPassports());
                return result;
            }

            @Override
            public EntityReference<Person> getProfile() {
                return customer.getProfile();
            }

            @Override
            public Set<String> getMiddleNameVariants() {
                HashSet<String> result = new HashSet<String>(this.middleNameVariantsFromPassports());
                return result;
            }

            @Override
            protected String email(Communication communication) {
                return ErasureHelper.this.email(communication);
            }

            @Override
            protected String phone(Communication communication) {
                return ErasureHelper.this.phone(communication);
            }

            protected List<Communication> getCommunications() {
                return customer.getCommunications();
            }

            @Override
            protected List<Passport> getPassports() {
                return Arrays.asList(customer.getPassport());
            }
        };
    }

    protected PersonalData newPersonalData(final Traveller traveller) {
        return new AbstractPersonalData(){

            @Override
            protected LocalDate calculateBirthDate() {
                Date date = traveller.getBirthday();
                date = date == null ? this.birthDateFromPassports() : date;
                return date != null ? MiscUtil.toLocalDate((Date)date) : null;
            }

            @Override
            protected Set<String> calculateLastNameVariants() {
                HashSet<String> result = new HashSet<String>(this.lastNameVariantsFromPassports());
                return result;
            }

            @Override
            protected Set<String> calculateFirstNameVariants() {
                HashSet<String> result = new HashSet<String>(this.firstNameVariantsFromPassports());
                return result;
            }

            @Override
            public EntityReference<Person> getProfile() {
                return traveller.getPassenger();
            }

            @Override
            public Set<String> getMiddleNameVariants() {
                HashSet<String> result = new HashSet<String>(this.middleNameVariantsFromPassports());
                return result;
            }

            @Override
            protected String email(Communication communication) {
                return ErasureHelper.this.email(communication);
            }

            @Override
            protected String phone(Communication communication) {
                return ErasureHelper.this.phone(communication);
            }

            protected List<Communication> getCommunications() {
                return traveller.getCommunications();
            }

            @Override
            protected List<Passport> getPassports() {
                return Arrays.asList(traveller.getPassport());
            }
        };
    }

    public String email(Communication communication) {
        String result = null;
        switch (communication.getType()) {
            case EMAIL: {
                result = communication.getSense();
                result = StringUtils.isBlank((String)result) ? null : result;
                break;
            }
        }
        return result;
    }

    public String phone(Communication communication) {
        String result = null;
        switch (communication.getType()) {
            case CELL: 
            case MOBILE: 
            case WORK_PHONE: 
            case HOME_PHONE: {
                result = ProfileHelper.getCommunicationPhone((Communication)communication);
                result = StringUtils.isBlank((String)result) ? null : result;
                break;
            }
        }
        return result;
    }

    public List<Correspondence> compare(EntityContainer<Person> personCtr, IndividualErasureParams params) {
        return this.compare(this.newPersonalData(personCtr), params);
    }

    public List<Correspondence> compare(Customer customer, IndividualErasureParams params) {
        return this.compare(this.newPersonalData(customer), params);
    }

    public List<Correspondence> compare(Traveller traveller, IndividualErasureParams params) {
        return this.compare(this.newPersonalData(traveller), params);
    }

    protected List<Correspondence> compare(PersonalData personalData, IndividualErasureParams params) {
        ErasureSearchCriterionType[] types;
        ArrayList<Correspondence> result = null;
        boolean noCriteria = true;
        boolean enough = false;
        for (ErasureSearchCriterionType type : types = new ErasureSearchCriterionType[]{ErasureSearchCriterionType.PERSON_REF, ErasureSearchCriterionType.BIRTH_DATE, ErasureSearchCriterionType.PASSPORT, ErasureSearchCriterionType.EMAIL, ErasureSearchCriterionType.PHONE, ErasureSearchCriterionType.PERSON_NAME}) {
            ArrayList criteria = new ArrayList(ErasureHelper.getInstance().criterions(params, type));
            if (criteria.isEmpty()) continue;
            noCriteria = false;
            List<Correspondence> correspondences = this.compare(personalData, type, criteria);
            if (correspondences == null) {
                result = null;
                break;
            }
            result = result == null ? new ArrayList<Correspondence>() : result;
            result.addAll(correspondences);
            boolean bl = enough = type == ErasureSearchCriterionType.PERSON_REF && !correspondences.isEmpty();
            if (enough) break;
        }
        if (noCriteria) {
            Correspondence correspondence = ErasureHelper.newCorrespondence(Messages.ErasureItemKey_NoCriteria, null, null);
            result = new ArrayList<Correspondence>(1);
            result.add(correspondence);
        }
        return result == null || result.isEmpty() ? null : result;
    }

    protected <T extends ErasureSearchCriterion> List<Correspondence> compare(PersonalData personalData, ErasureSearchCriterionType type, List<T> criteria) {
        List<Correspondence> result;
        if (personalData.contains(type)) {
            result = new ArrayList();
            for (ErasureSearchCriterion criterion : criteria) {
                Correspondence correspondence = null;
                switch (type) {
                    case PERSON_REF: {
                        correspondence = this.compare(personalData, (PersonRefCriterion)criterion);
                        break;
                    }
                    case BIRTH_DATE: {
                        correspondence = this.compare(personalData, (BirthDateCriterion)criterion);
                        break;
                    }
                    case PERSON_NAME: {
                        correspondence = this.compare(personalData, (PersonNameCriterion)criterion);
                        break;
                    }
                    case PASSPORT: {
                        correspondence = this.compare(personalData, (PassportCriterion)criterion);
                        break;
                    }
                    case EMAIL: {
                        correspondence = this.compare(personalData, (EmailCriterion)criterion);
                        break;
                    }
                    case PHONE: {
                        correspondence = this.compare(personalData, (PhoneCriterion)criterion);
                        break;
                    }
                }
                if (correspondence == null) continue;
                result.add(correspondence);
                break;
            }
            result = result.isEmpty() ? null : result;
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    protected Correspondence compare(PersonalData personalData, PersonRefCriterion criterion) {
        EntityReference<Person> profile = personalData.getProfile();
        Correspondence result = criterion.getProfile().equals(profile) ? ErasureHelper.newCorrespondence(Messages.ErasureItemKey_PersonRef, "UID=" + profile.getUid(), (ErasureSearchCriterion)criterion) : null;
        return result;
    }

    protected Correspondence compare(PersonalData personalData, BirthDateCriterion criterion) {
        LocalDate birthDate = personalData.getBirthDate();
        Correspondence result = birthDate.equals(criterion.getDay()) ? ErasureHelper.newCorrespondence(Messages.ErasureItemKey_BirthDate, birthDate.toString(), (ErasureSearchCriterion)criterion) : null;
        return result;
    }

    protected Correspondence compare(PersonalData personalData, PersonNameCriterion criterion) {
        return null;
    }

    protected Correspondence compare(PersonalData personalData, PassportCriterion criterion) {
        return null;
    }

    protected Correspondence compare(PersonalData personalData, EmailCriterion criterion) {
        return null;
    }

    protected Correspondence compare(PersonalData personalData, PhoneCriterion criterion) {
        return null;
    }

    public static Correspondence newCorrespondence(String key, String value, ErasureSearchCriterion criterion) {
        Correspondence result = new Correspondence();
        result.setKey(key);
        result.setValue(value);
        result.setCriterion(criterion);
        return result;
    }

    public static String toIndexValue(LongRunningTaskInfo taskInfo) {
        JSONObject jo = new JSONObject();
        jo.put("uid", (Object)taskInfo.getUid());
        jo.put("serverId", (Object)taskInfo.getServerId());
        jo.put("taskClassName", (Object)taskInfo.getTaskClassName());
        jo.put("description", (Object)taskInfo.getDescription());
        Date startDate = taskInfo.getStartDate();
        jo.put("startDate", (Object)(startDate != null ? MiscUtil.toLocalDateTime((Date)startDate) : null));
        return jo.toString();
    }
}

