/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.erasure.util;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.entity.misc.StorageUtil;
import com.gridnine.xtrip.common.model.erasure.BatchErasureParams;
import com.gridnine.xtrip.common.model.erasure.ErasureRequest;
import com.gridnine.xtrip.common.model.erasure.GenericErasureParams;
import com.gridnine.xtrip.common.model.erasure.IndividualErasureParams;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.model.helpers.erasure.ErasureHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTasksManager;
import com.gridnine.xtrip.server.model.tasks.standard.AbstractErasureTask;
import com.gridnine.xtrip.server.model.tasks.standard.ErasureSearchingTask;
import java.util.Date;

public class Util {
    public static EntityContainer<ErasureRequest> newErasureRequest(BatchErasureParams params) {
        ErasureHelper helper = ErasureHelper.getInstance();
        helper.validate(params);
        EntityContainer<ErasureRequest> result = Util.startTask(helper.createAndSaveRequest((GenericErasureParams)params), ErasureSearchingTask.class);
        return result;
    }

    public static EntityContainer<ErasureRequest> newErasureRequest(IndividualErasureParams params) {
        ErasureHelper helper = ErasureHelper.getInstance();
        helper.validate(params);
        EntityContainer<ErasureRequest> result = Util.startTask(helper.createAndSaveRequest((GenericErasureParams)params), ErasureSearchingTask.class);
        return result;
    }

    public static EntityContainer<ErasureRequest> startTask(EntityContainer<ErasureRequest> ctr, Class<? extends AbstractErasureTask> taskClass) {
        try {
            LongRunningTaskInfo taskInfo = ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(taskClass, new Date(), ctr.toReference());
            ((ErasureRequest)ctr.getEntity()).setActiveTask((BaseAsset)taskInfo);
            EntityContainer result = StorageUtil.save(ctr, (String)"start-searching", (boolean)true);
            return result;
        }
        catch (Exception e) {
            try {
                String s = XSUtil.toString(ctr);
                IncidentsLog.reportStackTrace((String)s);
            }
            catch (Exception ex) {
                IncidentsLog.reportException((String)"failed to serialize erasure", (Throwable)ex);
            }
            throw new RuntimeException(e);
        }
    }
}

