/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.fopDetalization;

import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.TaxesFopComponent;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public abstract class BaseFopDetalizationBuilderTest {
    protected void assertFopComponents(List<FopComponent> fopComponentsExp, List<FopComponent> fopComponentsAct) {
        Assert.assertEquals((long)fopComponentsExp.size(), (long)fopComponentsAct.size());
        fopComponentsExp.sort(Comparator.comparing(FopComponent::getAmount));
        fopComponentsAct.sort(Comparator.comparing(FopComponent::getAmount));
        for (int i = 0; i < fopComponentsExp.size(); ++i) {
            FopComponent fcExp = fopComponentsExp.get(i);
            FopComponent fcAct = fopComponentsAct.get(i);
            double delta = 1.0E-4;
            Assert.assertEquals((String)"amount", (double)fcExp.getAmount().doubleValue(), (double)fcAct.getAmount().doubleValue(), (double)delta);
            Assert.assertEquals((String)"no vat", (Object)(fcExp.getVatAmount() == null ? 1 : 0), (Object)(fcAct.getVatAmount() == null ? 1 : 0));
            Assert.assertEquals((String)"vatAmount", (double)MiscUtil.guarded((BigDecimal)fcExp.getVatAmount()).doubleValue(), (double)MiscUtil.guarded((BigDecimal)fcAct.getVatAmount()).doubleValue(), (double)delta);
            Assert.assertEquals((String)"not vatRate", (Object)(fcExp.getVatRate() == null ? 1 : 0), (Object)(fcAct.getVatRate() == null ? 1 : 0));
            Assert.assertEquals((String)"vatRate", (double)MiscUtil.guarded((Double)fcExp.getVatRate()), (double)MiscUtil.guarded((Double)fcAct.getVatRate()), (double)delta);
            Assert.assertEquals((Object)fcExp.getType().name(), (Object)fcAct.getType().name());
            Assert.assertEquals((String)"hidden", (Object)fcExp.isHidden(), (Object)fcAct.isHidden());
        }
    }

    @Ignore
    @Test
    public void testFake() {
    }

    static class TaxesFopComponentBuilder
    extends BaseFopComponentBuilder<TaxesFopComponent, TaxesFopComponentBuilder> {
        TaxesFopComponentBuilder() {
        }

        @Override
        TaxesFopComponent newInstance() {
            return new TaxesFopComponent();
        }

        @Override
        protected TaxesFopComponentBuilder self() {
            return this;
        }

        public TaxesFopComponentBuilder setTaxes(String taxes) {
            ((TaxesFopComponent)this.fc).setTaxes(taxes);
            return this;
        }
    }

    static class FopComponentBuilder
    extends BaseFopComponentBuilder<FopComponent, FopComponentBuilder> {
        FopComponentBuilder() {
        }

        @Override
        FopComponent newInstance() {
            return new FopComponent();
        }

        @Override
        protected FopComponentBuilder self() {
            return this;
        }
    }

    static abstract class BaseFopComponentBuilder<FC extends FopComponent, B extends BaseFopComponentBuilder> {
        protected FC fc = this.newInstance();

        abstract FC newInstance();

        protected abstract B self();

        public BaseFopComponentBuilder() {
            this.fc.setType(FopComponentType.PRODUCT);
        }

        public B setAmount(BigDecimal value) {
            this.fc.setAmount(value);
            return this.self();
        }

        public B setVatAmount(BigDecimal value) {
            this.fc.setVatAmount(value);
            return this.self();
        }

        public B setVatRate(double value) {
            this.fc.setVatRate(Double.valueOf(value));
            return this.self();
        }

        public B setType(FopComponentType fct) {
            this.fc.setType(fct);
            return this.self();
        }

        public B setHidden() {
            this.fc.setHidden(true);
            return this.self();
        }

        public FC build() {
            return this.fc;
        }
    }

    static class GeneralProductFopBuilder {
        private GeneralProductFop fop = new GeneralProductFop();

        GeneralProductFopBuilder() {
        }

        public GeneralProductFopBuilder setEquivalentAmount(BigDecimal value) {
            this.fop.setEquivalentAmount(value);
            return this;
        }

        public GeneralProductFopBuilder setType(PaymentType value) {
            this.fop.setType(value);
            return this;
        }

        public GeneralProductFopBuilder addCommission(BigDecimal value) {
            GeneralProductCommission com = new GeneralProductCommission();
            com.setEquivalentAmount(value);
            this.fop.getCommissions().add(com);
            return this;
        }

        public GeneralProductFopBuilder addCommission(GeneralProductCommission com) {
            this.fop.getCommissions().add(com);
            return this;
        }

        public GeneralProductFop build() {
            return this.fop;
        }
    }
}

