/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.fopDetalization;

import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class FeeVatRates {
    private final ProductStatus productStatus;
    private final double[] feeVatRates;
    private Map<Double, BigDecimal> rateAndAmounts = new HashMap<Double, BigDecimal>();

    public FeeVatRates(ProductStatus productStatus, double[] feeVatRates) {
        this.productStatus = productStatus;
        this.feeVatRates = feeVatRates;
    }

    public void clearAmounts() {
        this.rateAndAmounts.clear();
    }

    public void addFeeAmount(BigDecimal feeAmount, BaseCommissionProperties feeProp, BaseCommission commission) {
        Double vatRate = this.getVatRate(feeProp, commission);
        BigDecimal amount = MiscUtil.guarded((BigDecimal)this.rateAndAmounts.get(vatRate));
        this.rateAndAmounts.put(vatRate, MiscUtil.sum((BigDecimal[])new BigDecimal[]{amount, feeAmount}));
    }

    public Double getVatRate(BaseCommissionProperties commissionProp, BaseCommission commission) {
        if (!(commissionProp instanceof FeeProperties)) {
            return this.feeVatRates == null ? null : Double.valueOf(this.feeVatRates[0]);
        }
        FeeProperties feeProp = (FeeProperties)commissionProp;
        if (commission != null && commission.isTransferred() && feeProp.isRecalculateVatForAllContractTypes()) {
            return commission.getVatRate();
        }
        if (feeProp.isExternalFee()) {
            return feeProp.getExternalFeeVatRate();
        }
        return GeneralProductHelper.getFeeVatRate((double[])this.feeVatRates, (FeeProperties)feeProp, (ProductStatus)this.productStatus);
    }

    public Map<Double, BigDecimal> getRateAndAmounts() {
        return this.rateAndAmounts;
    }
}

