/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.fopDetalization;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.CategoryFopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.BaseCategorizedCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.FeeVatRates;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.StandardFopDetalizationHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FeesFopDetalizationBuilder {
    private List<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
    private Collection<Traveller> travellers = new ArrayList<Traveller>();
    private Collection<Traveller> adults = new ArrayList<Traveller>();
    private double[] vendorFeeVatRates;
    private double[] feeVatRates;
    private List<GeneralProductCommission> ownFeesCommissions = new ArrayList<GeneralProductCommission>();
    private ProductStatus productStatus = null;

    public FeesFopDetalizationBuilder(List<GeneralProductFop> _fops, Collection<Traveller> _travellers, double[] vendorFeeVatRates, double[] feeVatRates) {
        this.fops = _fops;
        if (_travellers != null) {
            this.travellers.addAll(_travellers);
        }
        this.vendorFeeVatRates = vendorFeeVatRates;
        this.feeVatRates = feeVatRates;
    }

    public FeesFopDetalizationBuilder addAdults(Collection<Traveller> adults) {
        this.adults.addAll(adults);
        return this;
    }

    public FeesFopDetalizationBuilder addOwnFeesCommissions(List<GeneralProductCommission> ownFeesCommissions) {
        this.ownFeesCommissions.addAll(ownFeesCommissions);
        return this;
    }

    public FeesFopDetalizationBuilder setProductStatus(ProductStatus productStatus) {
        this.productStatus = productStatus;
        return this;
    }

    public Map<String, FopDetalization> build() throws Exception {
        HashMap<String, FopDetalization> result = new HashMap<String, FopDetalization>();
        Iterator<GeneralProductFop> fopsIt = this.fops.iterator();
        Map<GeneralProductCommission, BigDecimal> commissionRemainders = ((Stream)this.fops.stream().flatMap(fop -> fop.getCommissions().stream()).unordered()).distinct().collect(Collectors.toMap(Function.identity(), BaseCommission::getEquivalentAmount));
        while (fopsIt.hasNext()) {
            GeneralProductFop fop2 = fopsIt.next();
            FopDetalization fopDetalization = new FopDetalization();
            result.put(fop2.getUid(), fopDetalization);
            Map<Supplier<FopComponent>, Collection<FeeVatRates>> fopFees = this.composeFopFees(fop2, commissionRemainders);
            for (Map.Entry<Supplier<FopComponent>, Collection<FeeVatRates>> entry : fopFees.entrySet()) {
                Supplier<FopComponent> fopComponentSupplier = entry.getKey();
                Collection<FeeVatRates> feeVatRates = entry.getValue();
                for (FeeVatRates fvr : feeVatRates) {
                    for (Map.Entry<Double, BigDecimal> fvrEntry : fvr.getRateAndAmounts().entrySet()) {
                        Double rate = fvrEntry.getKey();
                        BigDecimal amount = fvrEntry.getValue();
                        if (MiscUtil.isZero((BigDecimal)amount, (boolean)true)) continue;
                        BigDecimal vatAmount = StandardFopDetalizationHelper.getVatAmount(amount, rate);
                        fopDetalization.getComponents().addAll(StandardFopDetalizationHelper.buildDetailsItems(amount, vatAmount, rate, false, this.travellers, this.adults, null, fopComponentSupplier));
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Supplier<FopComponent>, Collection<FeeVatRates>> composeFopFees(GeneralProductFop fop, Map<GeneralProductCommission, BigDecimal> commissionRemainders) {
        BigDecimal fopRemainder = MiscUtil.guarded((BigDecimal)fop.getEquivalentAmount());
        BigDecimal ownFees = BigDecimal.ZERO;
        HashMap<DictionaryReference<CommissionCategory>, FeeVatRates> ownFeesMap = new HashMap<DictionaryReference<CommissionCategory>, FeeVatRates>();
        HashMap<DictionaryReference<CommissionCategory>, FeeVatRates> vendorFeesMap = new HashMap<DictionaryReference<CommissionCategory>, FeeVatRates>();
        for (GeneralProductCommission commission : fop.getCommissions()) {
            HashMap<DictionaryReference<CommissionCategory>, FeeVatRates> feesMap = vendorFeesMap;
            double[] dArray = this.vendorFeeVatRates;
            if (this.ownFeesCommissions.contains(commission)) {
                ownFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{ownFees, commission.getEquivalentAmount()});
                feesMap = ownFeesMap;
                double[] dArray2 = this.feeVatRates;
            }
            BigDecimal commissionRemainder = commissionRemainders.get(commission);
            BigDecimal amount = MiscUtil.isNegative((BigDecimal)commission.getEquivalentAmount()) ? MiscUtil.maximum((BigDecimal[])new BigDecimal[]{fopRemainder, commissionRemainder}) : MiscUtil.minimum((BigDecimal[])new BigDecimal[]{fopRemainder, commissionRemainder});
            if (MiscUtil.isZero((BigDecimal)amount, (boolean)true)) continue;
            BaseCommissionProperties commissionProp = this.getCommissionProperties(commission);
            DictionaryReference<CommissionCategory> categoryRef = this.getCommissionCategory(commissionProp);
            FeeVatRates categoryFeeVatRates = (FeeVatRates)feesMap.get(categoryRef);
            if (categoryFeeVatRates == null) {
                void var10_10;
                categoryFeeVatRates = new FeeVatRates(this.productStatus, (double[])var10_10);
                feesMap.put(categoryRef, categoryFeeVatRates);
            }
            fopRemainder = MiscUtil.sub((BigDecimal)fopRemainder, (BigDecimal[])new BigDecimal[]{amount});
            commissionRemainders.put(commission, MiscUtil.sub((BigDecimal)commissionRemainder, (BigDecimal[])new BigDecimal[]{amount}));
            categoryFeeVatRates.addFeeAmount(amount, commissionProp, (BaseCommission)commission);
            if (!MiscUtil.isZero((BigDecimal)fopRemainder, (boolean)true)) continue;
            break;
        }
        if (!MiscUtil.isZero((BigDecimal)fopRemainder, (boolean)true)) {
            FeesFopDetalizationBuilder.correctFeesMap(vendorFeesMap, fopRemainder, this.vendorFeeVatRates);
        }
        HashMap<DictionaryReference<CommissionCategory>, FeeVatRates> technicalFeesMap = new HashMap<DictionaryReference<CommissionCategory>, FeeVatRates>();
        HashMap<DictionaryReference<CommissionCategory>, FeeVatRates> resultVendorFeesMap = new HashMap<DictionaryReference<CommissionCategory>, FeeVatRates>();
        for (Map.Entry entry : vendorFeesMap.entrySet()) {
            if (entry.getKey() != null && "TECHNICAL_FEE".equals(((DictionaryReference)entry.getKey()).getCode())) {
                technicalFeesMap.put((DictionaryReference<CommissionCategory>)entry.getKey(), (FeeVatRates)entry.getValue());
                continue;
            }
            resultVendorFeesMap.put((DictionaryReference<CommissionCategory>)entry.getKey(), (FeeVatRates)entry.getValue());
        }
        HashMap<Supplier<FopComponent>, Collection<FeeVatRates>> result = new HashMap<Supplier<FopComponent>, Collection<FeeVatRates>>();
        this.processCategoryComponents(result, resultVendorFeesMap, FopComponentType.VENDOR_FEES);
        this.processCategoryComponents(result, technicalFeesMap, FopComponentType.TECHNICAL_PROVIDER_FEES);
        this.processCategoryComponents(result, ownFeesMap, FopComponentType.OWN_FEES);
        return result;
    }

    private void processCategoryComponents(Map<Supplier<FopComponent>, Collection<FeeVatRates>> result, Map<DictionaryReference<CommissionCategory>, FeeVatRates> feesMap, FopComponentType fopComponentType) {
        feesMap.forEach((k, v) -> result.put(() -> {
            CategoryFopComponent fc = new CategoryFopComponent();
            fc.setType(fopComponentType);
            fc.setCategory(k);
            return fc;
        }, Collections.singleton(v)));
    }

    protected BaseCommissionProperties getCommissionProperties(GeneralProductCommission commission) {
        EntityContainer ctr = EntityStorage.get().resolve(commission.getCommissionProperties());
        return ctr == null ? null : (BaseCommissionProperties)ctr.getEntity();
    }

    private DictionaryReference<CommissionCategory> getCommissionCategory(BaseCommissionProperties commissionProp) {
        if (commissionProp instanceof BaseCategorizedCommissionProperties) {
            BaseCategorizedCommissionProperties prop = (BaseCategorizedCommissionProperties)commissionProp;
            return prop.getCategory();
        }
        return null;
    }

    private static void correctFeesMap(Map<DictionaryReference<CommissionCategory>, FeeVatRates> feesMap, BigDecimal totalFees, double[] vatRates) {
        BigDecimal fees = feesMap.values().stream().flatMap(vr -> vr.getRateAndAmounts().values().stream()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal remainder = totalFees.subtract(fees);
        if (!MiscUtil.isZero((BigDecimal)remainder, (boolean)true)) {
            FeeVatRates vr2 = new FeeVatRates(null, vatRates);
            vr2.addFeeAmount(remainder, null, null);
            feesMap.put(null, vr2);
        }
    }
}

