/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.fopDetalization;

import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.CommissionCategoryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.BaseFopDetalizationBuilderTest;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.FeesFopDetalizationBuilder;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.StandardFopDetalizationHelper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public class FeesFopDetalizationBuilderTest
extends BaseFopDetalizationBuilderTest {
    @Test
    public void testVendorFees() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        double vatRate = 10.0;
        double[] feeVatRate = new double[]{10.0, 10.0};
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new FeesFopDetalizationBuilder(fops, travellers, feeVatRate, null).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount)).setVatRate(10.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(fopAmount, 10.0))).setType(FopComponentType.VENDOR_FEES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testVendorFeesNoTraveller() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        double vatRate = 10.0;
        double[] feeVatRate = new double[]{10.0, 10.0};
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        Collection<Traveller> travellers = null;
        Map<String, FopDetalization> fopDetalizationMap = new FeesFopDetalizationBuilder(fops, travellers, feeVatRate, null).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount)).setVatRate(10.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(fopAmount, 10.0))).setType(FopComponentType.VENDOR_FEES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOwnFees() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        double vatRate = 10.0;
        double[] feeVatRate = new double[]{10.0, 10.0};
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).addCommission(fopAmount).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        GeneralProductFop fop = fops.get(0);
        Map<String, FopDetalization> fopDetalizationMap = new FeesFopDetalizationBuilder(fops, travellers, null, feeVatRate){

            @Override
            protected BaseCommissionProperties getCommissionProperties(GeneralProductCommission commission) {
                return new FeeProperties();
            }
        }.addOwnFeesCommissions(fop.getCommissions()).build();
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount)).setVatRate(10.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(fopAmount, 10.0))).setType(FopComponentType.OWN_FEES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOwnPaymentFees() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        double vatRate = 10.0;
        double[] feeVatRate = new double[]{10.0, 10.0};
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).addCommission(fopAmount).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        GeneralProductFop fop = fops.get(0);
        Map<String, FopDetalization> fopDetalizationMap = new FeesFopDetalizationBuilder(fops, travellers, null, feeVatRate){

            @Override
            protected BaseCommissionProperties getCommissionProperties(GeneralProductCommission commission) {
                return new PaymentFeeProperties();
            }
        }.addOwnFeesCommissions(fop.getCommissions()).build();
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount)).setVatRate(10.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(fopAmount, 10.0))).setType(FopComponentType.OWN_FEES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testVendorAndOwnFees() throws Exception {
        BigDecimal vendorAmount = BigDecimal.valueOf(600L);
        double vendorVatRate = 10.0;
        BigDecimal ownAmount = BigDecimal.valueOf(400L);
        double ownVatRate = 18.0;
        double[] vendorVatRates = new double[]{10.0, 10.0};
        double[] ownVatRates = new double[]{18.0, 18.0};
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{vendorAmount, ownAmount})).addCommission(ownAmount).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        GeneralProductFop fop = fops.get(0);
        Map<String, FopDetalization> fopDetalizationMap = new FeesFopDetalizationBuilder(fops, travellers, vendorVatRates, ownVatRates){

            @Override
            protected BaseCommissionProperties getCommissionProperties(GeneralProductCommission commission) {
                return new FeeProperties();
            }
        }.addOwnFeesCommissions(fop.getCommissions()).build();
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vendorAmount)).setVatRate(10.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(vendorAmount, 10.0))).setType(FopComponentType.VENDOR_FEES)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(ownAmount)).setVatRate(18.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(ownAmount, 18.0))).setType(FopComponentType.OWN_FEES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testTwoVendorFops() throws Exception {
        BigDecimal fop1Amount = BigDecimal.valueOf(600L);
        BigDecimal fop2Amount = BigDecimal.valueOf(400L);
        BigDecimal vendorAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{fop1Amount, fop2Amount});
        double vendorVatRate = 10.0;
        double[] vendorVatRates = new double[]{10.0, 10.0};
        double[] ownVatRates = null;
        GeneralProductCommission com = new GeneralProductCommission();
        com.setEquivalentAmount(vendorAmount);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fop1Amount).addCommission(com).build(), new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fop2Amount).addCommission(com).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new FeesFopDetalizationBuilder(fops, travellers, vendorVatRates, ownVatRates){

            @Override
            protected BaseCommissionProperties getCommissionProperties(GeneralProductCommission commission) {
                return new FeeProperties();
            }
        }.build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fop1Amount)).setVatRate(10.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(fop1Amount, 10.0))).setType(FopComponentType.VENDOR_FEES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
        fop = fops.get(1);
        fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fop2Amount)).setVatRate(10.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(fop2Amount, 10.0))).setType(FopComponentType.VENDOR_FEES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testTwoOwnFops() throws Exception {
        BigDecimal fop1Amount = BigDecimal.valueOf(600L);
        BigDecimal fop2Amount = BigDecimal.valueOf(400L);
        BigDecimal ownAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{fop1Amount, fop2Amount});
        double ownVatRate = 10.0;
        double[] vendorVatRates = null;
        double[] ownVatRates = new double[]{10.0, 10.0};
        GeneralProductCommission com = new GeneralProductCommission();
        com.setEquivalentAmount(ownAmount);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fop1Amount).addCommission(com).build(), new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fop2Amount).addCommission(com).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new FeesFopDetalizationBuilder(fops, travellers, vendorVatRates, ownVatRates){

            @Override
            protected BaseCommissionProperties getCommissionProperties(GeneralProductCommission commission) {
                return new FeeProperties();
            }
        }.addOwnFeesCommissions(Arrays.asList(com)).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fop1Amount)).setVatRate(10.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(fop1Amount, 10.0))).setType(FopComponentType.OWN_FEES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
        fop = fops.get(1);
        fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fop2Amount)).setVatRate(10.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(fop2Amount, 10.0))).setType(FopComponentType.OWN_FEES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testTwoFops() throws Exception {
        BigDecimal fop1Amount = BigDecimal.valueOf(600L);
        BigDecimal fop2Amount = BigDecimal.valueOf(400L);
        BigDecimal vendorAmount = fop1Amount;
        double vendorVatRate = 18.0;
        BigDecimal ownAmount = fop2Amount;
        double ownVatRate = 10.0;
        double[] vendorVatRates = new double[]{18.0, 18.0};
        double[] ownVatRates = new double[]{10.0, 10.0};
        GeneralProductCommission vendorCom = new GeneralProductCommission();
        vendorCom.setEquivalentAmount(vendorAmount);
        GeneralProductCommission ownCom = new GeneralProductCommission();
        ownCom.setEquivalentAmount(ownAmount);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fop1Amount).addCommission(vendorCom).addCommission(ownCom).build(), new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fop2Amount).addCommission(vendorCom).addCommission(ownCom).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new FeesFopDetalizationBuilder(fops, travellers, vendorVatRates, ownVatRates){

            @Override
            protected BaseCommissionProperties getCommissionProperties(GeneralProductCommission commission) {
                return new FeeProperties();
            }
        }.addOwnFeesCommissions(Arrays.asList(ownCom)).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vendorAmount)).setVatRate(18.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(vendorAmount, 18.0))).setType(FopComponentType.VENDOR_FEES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
        fop = fops.get(1);
        fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(ownAmount)).setVatRate(10.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(ownAmount, 10.0))).setType(FopComponentType.OWN_FEES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testTwoRefundFops() throws Exception {
        BigDecimal fop1Amount = BigDecimal.valueOf(-600L);
        BigDecimal fop2Amount = BigDecimal.valueOf(-400L);
        BigDecimal vendorAmount = fop1Amount;
        double vendorVatRate = 18.0;
        BigDecimal ownAmount = fop2Amount;
        double ownVatRate = 10.0;
        double[] vendorVatRates = new double[]{18.0, 18.0};
        double[] ownVatRates = new double[]{10.0, 10.0};
        GeneralProductCommission vendorCom = new GeneralProductCommission();
        vendorCom.setEquivalentAmount(vendorAmount);
        GeneralProductCommission ownCom = new GeneralProductCommission();
        ownCom.setEquivalentAmount(ownAmount);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fop1Amount).addCommission(vendorCom).addCommission(ownCom).build(), new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fop2Amount).addCommission(vendorCom).addCommission(ownCom).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new FeesFopDetalizationBuilder(fops, travellers, vendorVatRates, ownVatRates){

            @Override
            protected BaseCommissionProperties getCommissionProperties(GeneralProductCommission commission) {
                return new FeeProperties();
            }
        }.addOwnFeesCommissions(Arrays.asList(ownCom)).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vendorAmount)).setVatRate(18.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(vendorAmount, 18.0))).setType(FopComponentType.VENDOR_FEES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
        fop = fops.get(1);
        fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(ownAmount)).setVatRate(10.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(ownAmount, 10.0))).setType(FopComponentType.OWN_FEES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testCategoriesFops() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(600L);
        BigDecimal com1Amount = BigDecimal.valueOf(400L);
        BigDecimal com2Amount = fopAmount.subtract(com1Amount);
        double vendorVatRate = 18.0;
        double[] vendorVatRates = new double[]{18.0, 18.0};
        double[] ownVatRates = null;
        final GeneralProductCommission com1 = new GeneralProductCommission();
        com1.setEquivalentAmount(com1Amount);
        final GeneralProductCommission com2 = new GeneralProductCommission();
        com2.setEquivalentAmount(com2Amount);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).addCommission(com1).addCommission(com2).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new FeesFopDetalizationBuilder(fops, travellers, vendorVatRates, ownVatRates){

            @Override
            protected BaseCommissionProperties getCommissionProperties(GeneralProductCommission commission) {
                FeeProperties feeProperties = new FeeProperties();
                if (MiscUtil.equals((Object)commission, (Object)com1)) {
                    feeProperties.setCategory((DictionaryReference)new CommissionCategoryReference("code1"));
                } else if (MiscUtil.equals((Object)commission, (Object)com2)) {
                    feeProperties.setCategory((DictionaryReference)new CommissionCategoryReference("code2"));
                }
                return feeProperties;
            }
        }.build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(com1Amount)).setVatRate(18.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(com1Amount, 18.0))).setType(FopComponentType.VENDOR_FEES)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(com2Amount)).setVatRate(18.0)).setVatAmount(StandardFopDetalizationHelper.getVatAmount(com2Amount, 18.0))).setType(FopComponentType.VENDOR_FEES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }
}

