/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.fopDetalization;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.AddServiceTypeFopComponent;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.TaxesFopComponent;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.FeeVatRates;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.StandardFopDetalizationHelper;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.VatComponentWrapper;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ProductFopDetalizationBuilder {
    protected List<GeneralProductFop> _fops = new ArrayList<GeneralProductFop>();
    private List<VatComponentWrapper> _vatComponents = new ArrayList<VatComponentWrapper>();
    private List<Traveller> _travellers = new ArrayList<Traveller>();
    private List<Traveller> adults = new ArrayList<Traveller>();
    private BigDecimal serviceAmount = BigDecimal.ZERO;
    private BigDecimal penalty = BigDecimal.ZERO;
    private BigDecimal deduction = BigDecimal.ZERO;
    private FeeVatRates feeVatRates = new FeeVatRates(null, null);
    private BigDecimal taxesAmount = BigDecimal.ZERO;
    private boolean createComponentsForZeroFop = false;
    protected BaseProduct previousProduct = null;
    protected ContractType contractType = null;

    public ProductFopDetalizationBuilder(List<GeneralProductFop> fops, List<VatComponentWrapper> vatComponents, Collection<Traveller> travellers) {
        this._fops.addAll(fops);
        this._vatComponents.addAll(vatComponents);
        if (travellers != null) {
            this._travellers.addAll(travellers);
        }
    }

    public ProductFopDetalizationBuilder addAdults(Collection<Traveller> adults) {
        this.adults.addAll(adults);
        return this;
    }

    public ProductFopDetalizationBuilder setServiceAmount(BigDecimal value) {
        this.serviceAmount = MiscUtil.guarded((BigDecimal)value);
        return this;
    }

    public ProductFopDetalizationBuilder setPenalty(BigDecimal value) {
        this.penalty = MiscUtil.guarded((BigDecimal)value);
        return this;
    }

    public ProductFopDetalizationBuilder setDeduction(BigDecimal value) {
        this.deduction = MiscUtil.guarded((BigDecimal)value);
        return this;
    }

    public ProductFopDetalizationBuilder setFeeVatRate(FeeVatRates value) {
        this.feeVatRates = value;
        return this;
    }

    public ProductFopDetalizationBuilder separateTaxes(BigDecimal taxesAmount) {
        this.taxesAmount = MiscUtil.guarded((BigDecimal)taxesAmount);
        return this;
    }

    public ProductFopDetalizationBuilder setCreateComponentsForZeroFop(boolean value) {
        this.createComponentsForZeroFop = value;
        return this;
    }

    public ProductFopDetalizationBuilder setPreviousProduct(BaseProduct value) {
        this.previousProduct = value;
        return this;
    }

    public ProductFopDetalizationBuilder setContractType(ContractType value) {
        this.contractType = value;
        return this;
    }

    public Map<String, FopDetalization> build() throws Exception {
        HashMap<String, FopDetalization> result = new HashMap<String, FopDetalization>();
        BigDecimal fopsAmount = this.calcFopsAmount(this._fops, true);
        fopsAmount = fopsAmount.subtract(this.penalty);
        fopsAmount = fopsAmount.subtract(this.deduction);
        BigDecimal currentTaxesAmount = this.taxesAmount;
        BigDecimal currentServiceAmount = this.serviceAmount;
        BigDecimal currentSpecialTaxesAmount = this.calcVatComponentsAmount(this::isSeparatedTax);
        BigDecimal currentSpecialServicesAmount = this.calcVatComponentsAmount(this::isSeparatedService);
        if (!MiscUtil.isZero((BigDecimal)currentTaxesAmount, (boolean)true)) {
            currentTaxesAmount = currentTaxesAmount.subtract(currentSpecialTaxesAmount);
        }
        if (!MiscUtil.isZero((BigDecimal)currentServiceAmount, (boolean)true)) {
            currentServiceAmount = currentServiceAmount.subtract(currentSpecialServicesAmount);
        }
        fopsAmount = fopsAmount.subtract(currentTaxesAmount);
        fopsAmount = fopsAmount.subtract(currentServiceAmount);
        fopsAmount = fopsAmount.subtract(currentSpecialTaxesAmount);
        fopsAmount = fopsAmount.subtract(currentSpecialServicesAmount);
        ArrayList<VatComponentWrapper> productVatComponents = new ArrayList<VatComponentWrapper>();
        ArrayList<VatComponentWrapper> taxesVatComponents = new ArrayList<VatComponentWrapper>();
        ArrayList<VatComponentWrapper> specialTaxesVatComponents = new ArrayList<VatComponentWrapper>();
        ArrayList<VatComponentWrapper> serviceVatComponents = new ArrayList<VatComponentWrapper>();
        ArrayList<VatComponentWrapper> specialServiceVatComponents = new ArrayList<VatComponentWrapper>();
        ArrayList<VatComponentWrapper> penaltyVatComponents = new ArrayList<VatComponentWrapper>();
        ArrayList<VatComponentWrapper> deductionVatComponents = new ArrayList<VatComponentWrapper>();
        HashMap<VatComponentWrapper, BigDecimal> vatsRemainders = new HashMap<VatComponentWrapper, BigDecimal>();
        this._vatComponents.forEach(vc -> {
            if (this.isSeparatedTax((VatComponentWrapper)vc)) {
                specialTaxesVatComponents.add((VatComponentWrapper)vc);
                return;
            }
            if (this.isSeparatedService((VatComponentWrapper)vc)) {
                specialServiceVatComponents.add((VatComponentWrapper)vc);
                return;
            }
            switch (vc.getBasisType()) {
                case TAXES: {
                    taxesVatComponents.add((VatComponentWrapper)vc);
                    break;
                }
                case SERVICE: {
                    serviceVatComponents.add((VatComponentWrapper)vc);
                    break;
                }
                case PENALTY: {
                    penaltyVatComponents.add((VatComponentWrapper)vc);
                    break;
                }
                case DEDUCTION: {
                    deductionVatComponents.add((VatComponentWrapper)vc);
                    break;
                }
                default: {
                    productVatComponents.add((VatComponentWrapper)vc);
                }
            }
        });
        this.correctVatComponents(productVatComponents, fopsAmount, VatBasisType.FARE);
        this.correctVatComponents(specialTaxesVatComponents, currentSpecialTaxesAmount, VatBasisType.TAXES);
        this.correctVatComponents(taxesVatComponents, currentTaxesAmount, VatBasisType.TAXES);
        this.correctVatComponents(specialServiceVatComponents, currentSpecialServicesAmount, VatBasisType.SERVICE);
        this.correctVatComponents(serviceVatComponents, currentServiceAmount, VatBasisType.SERVICE);
        this.correctVatComponents(penaltyVatComponents, this.penalty, VatBasisType.PENALTY);
        this.correctVatComponents(deductionVatComponents, this.deduction, VatBasisType.DEDUCTION);
        List ticketFops = this._fops.stream().filter(fop -> fop.getType() == PaymentType.TICKET).collect(Collectors.toList());
        for (GeneralProductFop fop2 : ticketFops) {
            FopDetalization fopDetalization;
            FopDetalization prevFopDetalization = this.getPreviousFopDetalization(fop2, this.contractType);
            if (prevFopDetalization == null || !this.correctVatComponents(fopDetalization = this.cloneDetalization(prevFopDetalization), productVatComponents, taxesVatComponents, serviceVatComponents, penaltyVatComponents, deductionVatComponents, specialTaxesVatComponents, specialServiceVatComponents)) continue;
            result.put(fop2.getUid(), fopDetalization);
            BigDecimal fopAmount = this.calcFopAmount(fop2, true);
            BigDecimal fopTaxes = this.calcFopComponentTypeAmount(prevFopDetalization, FopComponentType.TAXES);
            BigDecimal fopSpecialTaxes = this.calcFopComponentSpecialAmount(prevFopDetalization, TaxesFopComponent.class);
            fopTaxes = MiscUtil.sub((BigDecimal)fopTaxes, (BigDecimal[])new BigDecimal[]{fopSpecialTaxes});
            BigDecimal fopService = this.calcFopComponentTypeAmount(prevFopDetalization, FopComponentType.SERVICE);
            BigDecimal fopSpecialServices = this.calcFopComponentSpecialAmount(prevFopDetalization, AddServiceTypeFopComponent.class);
            fopService = MiscUtil.sub((BigDecimal)fopService, (BigDecimal[])new BigDecimal[]{fopSpecialServices});
            fopAmount = fopAmount.subtract(fopTaxes);
            currentTaxesAmount = currentTaxesAmount.subtract(fopTaxes);
            fopAmount = fopAmount.subtract(fopService);
            currentServiceAmount = currentServiceAmount.subtract(fopService);
            fopAmount = fopAmount.subtract(fopSpecialTaxes);
            currentSpecialTaxesAmount = currentSpecialTaxesAmount.subtract(fopSpecialTaxes);
            fopAmount = fopAmount.subtract(fopSpecialServices);
            currentSpecialServicesAmount = currentSpecialServicesAmount.subtract(fopSpecialServices);
            fopsAmount = fopsAmount.subtract(fopAmount);
        }
        this.clearZeroVatComponents(productVatComponents);
        if (this.createComponentsForZeroFop && productVatComponents.isEmpty()) {
            VatComponentWrapper vc2 = new VatComponentWrapper();
            vc2.setBasis(BigDecimal.ZERO);
            vc2.setBasisType(VatBasisType.FARE);
            productVatComponents.add(vc2);
        }
        this.clearZeroVatComponents(taxesVatComponents);
        this.clearZeroVatComponents(serviceVatComponents);
        this.clearZeroVatComponents(penaltyVatComponents);
        this.clearZeroVatComponents(deductionVatComponents);
        this.clearZeroVatComponents(specialTaxesVatComponents);
        this.clearZeroVatComponents(specialServiceVatComponents);
        Iterator<GeneralProductFop> fopsIt = this._fops.iterator();
        boolean penaltyAdded = false;
        boolean reservedSeatsDeductionAdded = false;
        boolean taxesAdded = false;
        boolean serviceAdded = false;
        boolean specialTaxesAdded = false;
        boolean specialServicesAdded = false;
        while (fopsIt.hasNext()) {
            GeneralProductFop fop3 = fopsIt.next();
            if (result.containsKey(fop3.getUid())) continue;
            FopDetalization fopDetalization = new FopDetalization();
            result.put(fop3.getUid(), fopDetalization);
            BigDecimal hiddenFeesAmount = this.calcFopComissionsAmount(fop3);
            BigDecimal currentFopAmount = MiscUtil.guarded((BigDecimal)fop3.getEquivalentAmount()).subtract(hiddenFeesAmount);
            if (!MiscUtil.isZero((BigDecimal)this.penalty, (boolean)true) && !penaltyAdded && fop3.getType() != PaymentType.TICKET) {
                this.buildFopDetailsItems(fopDetalization, this.penalty, this.penalty, false, penaltyVatComponents, new HashMap<VatComponentWrapper, BigDecimal>(), this.fopComponentSupplier(FopComponentType.PENALTY));
                currentFopAmount = currentFopAmount.subtract(this.penalty);
                penaltyAdded = true;
            }
            if (!MiscUtil.isZero((BigDecimal)this.deduction, (boolean)true) && !reservedSeatsDeductionAdded) {
                this.buildFopDetailsItems(fopDetalization, this.deduction, this.deduction, false, deductionVatComponents, new HashMap<VatComponentWrapper, BigDecimal>(), this.fopComponentSupplier(FopComponentType.DEDUCTION));
                currentFopAmount = currentFopAmount.subtract(this.deduction);
                reservedSeatsDeductionAdded = true;
            }
            if (!MiscUtil.isZero((BigDecimal)currentSpecialTaxesAmount, (boolean)true) && !specialTaxesAdded) {
                this.buildFopDetailsItems(fopDetalization, currentSpecialTaxesAmount, currentSpecialTaxesAmount, false, specialTaxesVatComponents, new HashMap<VatComponentWrapper, BigDecimal>(), () -> {
                    TaxesFopComponent fc = new TaxesFopComponent();
                    fc.setType(FopComponentType.TAXES);
                    return fc;
                });
                currentFopAmount = currentFopAmount.subtract(currentSpecialTaxesAmount);
                specialTaxesAdded = true;
            }
            if (!MiscUtil.isZero((BigDecimal)currentSpecialServicesAmount, (boolean)true) && !specialServicesAdded) {
                this.buildFopDetailsItems(fopDetalization, currentSpecialServicesAmount, currentSpecialServicesAmount, false, specialServiceVatComponents, new HashMap<VatComponentWrapper, BigDecimal>(), () -> {
                    AddServiceTypeFopComponent fc = new AddServiceTypeFopComponent();
                    fc.setType(FopComponentType.SERVICE);
                    return fc;
                });
                currentFopAmount = currentFopAmount.subtract(currentSpecialServicesAmount);
                specialServicesAdded = true;
            }
            if (!MiscUtil.isZero((BigDecimal)currentTaxesAmount, (boolean)true) && !taxesAdded) {
                this.buildFopDetailsItems(fopDetalization, currentTaxesAmount, currentTaxesAmount, false, taxesVatComponents, new HashMap<VatComponentWrapper, BigDecimal>(), this.fopComponentSupplier(FopComponentType.TAXES));
                currentFopAmount = currentFopAmount.subtract(currentTaxesAmount);
                taxesAdded = true;
            }
            if (!MiscUtil.isZero((BigDecimal)currentServiceAmount, (boolean)true) && !serviceAdded) {
                this.buildFopDetailsItems(fopDetalization, currentServiceAmount, currentServiceAmount, false, serviceVatComponents, new HashMap<VatComponentWrapper, BigDecimal>(), this.fopComponentSupplier(FopComponentType.SERVICE));
                currentFopAmount = currentFopAmount.subtract(currentServiceAmount);
                serviceAdded = true;
            }
            if (!MiscUtil.isZero((BigDecimal)hiddenFeesAmount, (boolean)true)) {
                for (Map.Entry<Double, BigDecimal> fvrEntry : this.feeVatRates.getRateAndAmounts().entrySet()) {
                    Double rate = fvrEntry.getKey();
                    BigDecimal amount = fvrEntry.getValue();
                    if (MiscUtil.isZero((BigDecimal)amount, (boolean)true)) continue;
                    BigDecimal vatAmount = StandardFopDetalizationHelper.getVatAmount(amount, rate);
                    fopDetalization.getComponents().addAll(StandardFopDetalizationHelper.buildDetailsItems(FopComponentType.PRODUCT, hiddenFeesAmount, vatAmount, rate, true, this._travellers, this.adults));
                }
            }
            this.buildFopDetailsItems(fopDetalization, fopsAmount, currentFopAmount, fopsIt.hasNext(), productVatComponents, vatsRemainders, this.fopComponentSupplier(FopComponentType.PRODUCT));
        }
        return result;
    }

    private BigDecimal calcVatComponentsAmount(Predicate<VatComponentWrapper> filter) {
        return this._vatComponents.stream().filter(filter).map(VatComponentWrapper::getBasis).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private boolean isSeparatedTax(VatComponentWrapper vc) {
        return vc.isSeparated() && vc.getBasisType() == VatBasisType.TAXES;
    }

    private boolean isSeparatedService(VatComponentWrapper vc) {
        return vc.isSeparated() && vc.getBasisType() == VatBasisType.SERVICE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FopDetalization cloneDetalization(FopDetalization prevFopDetalization) throws Exception {
        FopDetalization result = new FopDetalization();
        for (FopComponent comp : prevFopDetalization.getComponents()) {
            Traveller traveller = comp.getTraveller();
            try {
                comp.setTraveller(null);
                FopComponent clone = (FopComponent)XCloneHelper.cloneObject((Object)comp, (boolean)true, new HashMap());
                clone.setTraveller(traveller);
                result.getComponents().add(clone);
            }
            finally {
                comp.setTraveller(traveller);
            }
        }
        return result;
    }

    protected BigDecimal calcFopComponentTypeAmount(FopDetalization fopDetalization, FopComponentType fopComponentType) {
        return fopDetalization.getComponents().stream().filter(fc -> fc.getType() == fopComponentType).map(FopComponent::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal calcFopComponentSpecialAmount(FopDetalization fopDetalization, Class<? extends FopComponent> clazz) {
        return fopDetalization.getComponents().stream().filter(clazz::isInstance).map(FopComponent::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal calcFopsAmount(Collection<GeneralProductFop> fops, boolean excludeCommissions) {
        return fops.stream().map(fop -> this.calcFopAmount((GeneralProductFop)fop, excludeCommissions)).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    protected BigDecimal calcFopAmount(GeneralProductFop fop, boolean excludeCommissions) {
        BigDecimal result = MiscUtil.guarded((BigDecimal)fop.getEquivalentAmount());
        if (excludeCommissions) {
            result = result.subtract(this.calcFopComissionsAmount(fop));
        }
        return result;
    }

    private BigDecimal calcFopComissionsAmount(GeneralProductFop fop) {
        this.feeVatRates.clearAmounts();
        BigDecimal result = BigDecimal.ZERO;
        for (GeneralProductCommission commission : fop.getCommissions()) {
            BigDecimal amount = commission.getEquivalentAmount();
            if (MiscUtil.isZero((BigDecimal)amount, (boolean)true)) continue;
            result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, amount});
            FeeProperties feeProp = this.getFeeProperties(commission);
            this.feeVatRates.addFeeAmount(amount, (BaseCommissionProperties)feeProp, (BaseCommission)commission);
        }
        return result;
    }

    protected FeeProperties getFeeProperties(GeneralProductCommission commission) {
        EntityContainer ctr = EntityStorage.get().resolve(commission.getCommissionProperties());
        if (ctr != null && ctr.getEntity() instanceof FeeProperties) {
            return (FeeProperties)ctr.getEntity();
        }
        return null;
    }

    protected void correctVatComponents(List<VatComponentWrapper> vatComponents, BigDecimal totalBasis, VatBasisType vatBasisType) {
        boolean isVatsNegate;
        BigDecimal vatsBasis = vatComponents.stream().map(VatComponentWrapper::getBasis).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        boolean isTotalNegate = totalBasis.compareTo(BigDecimal.ZERO) < 0;
        boolean bl = isVatsNegate = vatsBasis.compareTo(BigDecimal.ZERO) < 0;
        if (isTotalNegate != isVatsNegate) {
            vatComponents.forEach(vc -> {
                if (vc != null) {
                    vc.setBasis(MiscUtil.negate((BigDecimal)vc.getBasis()));
                    vc.setSum(MiscUtil.negate((BigDecimal)vc.getSum()));
                }
            });
            vatsBasis = vatsBasis.negate();
        }
        if (totalBasis.compareTo(vatsBasis) != 0) {
            VatComponentWrapper vc2 = new VatComponentWrapper();
            vc2.setBasis(totalBasis.subtract(vatsBasis));
            vc2.setSum(null);
            vc2.setBasisType(vatBasisType);
            vatComponents.add(vc2);
        }
    }

    private void clearZeroVatComponents(List<VatComponentWrapper> vatComponents) {
        vatComponents.removeIf(vc -> MiscUtil.isZero((BigDecimal)vc.getBasis(), (boolean)true));
    }

    private void buildFopDetailsItems(FopDetalization fopDetalization, BigDecimal allFopsAmount, BigDecimal fopAmount, Boolean fopsHasNext, List<VatComponentWrapper> vatComponents, Map<VatComponentWrapper, BigDecimal> vatsRemainders, Supplier<FopComponent> fopComponentSupplier) {
        BigDecimal fopsRemainder = fopAmount;
        Iterator<VatComponentWrapper> vatIt = vatComponents.iterator();
        while (vatIt.hasNext()) {
            BigDecimal vatFopAmount;
            BigDecimal vatKoef;
            VatComponentWrapper vatComponent = vatIt.next();
            BigDecimal basis = MiscUtil.guarded((BigDecimal)vatComponent.getBasis());
            BigDecimal fopKoef = vatComponents.size() == 1 ? BigDecimal.valueOf(1L) : (MiscUtil.isZero((BigDecimal)allFopsAmount, (boolean)true) ? BigDecimal.ZERO : basis.divide(allFopsAmount, MathContext.DECIMAL64));
            BigDecimal bigDecimal = vatKoef = MiscUtil.isZero((BigDecimal)allFopsAmount, (boolean)true) ? BigDecimal.ZERO : fopAmount.divide(allFopsAmount, MathContext.DECIMAL64);
            if (fopsHasNext.booleanValue() || vatIt.hasNext()) {
                vatFopAmount = StandardFopDetalizationHelper.round(fopAmount.multiply(fopKoef));
                fopsRemainder = fopsRemainder.subtract(vatFopAmount);
            } else {
                vatFopAmount = fopsRemainder;
            }
            Double vatRate = null;
            BigDecimal vatAmount = null;
            if (vatComponent.getSum() != null) {
                vatRate = vatComponent.getRate();
                BigDecimal vatSum = vatComponent.getSum();
                if (fopsHasNext.booleanValue()) {
                    vatAmount = StandardFopDetalizationHelper.round(vatSum.multiply(vatKoef));
                    BigDecimal vatsRemainder = (BigDecimal)MiscUtil.guarded((Object)vatsRemainders.get(vatComponent), (Object)vatSum);
                    vatsRemainders.put(vatComponent, vatsRemainder.subtract(vatAmount));
                } else {
                    vatAmount = (BigDecimal)MiscUtil.guarded((Object)vatsRemainders.get(vatComponent), (Object)vatSum);
                }
            }
            fopDetalization.getComponents().addAll(StandardFopDetalizationHelper.buildDetailsItems(vatFopAmount, vatAmount, vatRate, false, this._travellers, this.adults, vatComponent, fopComponentSupplier));
        }
    }

    protected FopDetalization getPreviousFopDetalization(GeneralProductFop fop, ContractType contractType) {
        if (this.previousProduct == null) {
            return null;
        }
        List fops = GeneralProductHelper.getFops((BaseProduct)this.previousProduct, (ContractType)contractType);
        for (GeneralProductFop prevProdFop : fops) {
            if (GeneralProductHelper.getFopType((GeneralProductFop)prevProdFop) != FopType.PRODUCT || !MiscUtil.equals((Object)prevProdFop.getEquivalentAmount(), (Object)fop.getEquivalentAmount())) continue;
            return (FopDetalization)this.previousProduct.getFopDetalizations().get(prevProdFop.getUid());
        }
        return null;
    }

    private boolean correctVatComponents(FopDetalization prevFopDetalizationClone, List<VatComponentWrapper> productVatComponents, List<VatComponentWrapper> taxesVatComponents, List<VatComponentWrapper> serviceVatComponents, List<VatComponentWrapper> penaltyVatComponents, List<VatComponentWrapper> deductionVatComponents, List<VatComponentWrapper> specialTaxesVatComponents, List<VatComponentWrapper> specialServiceVatComponents) {
        HashMap<FopComponent, VatComponentWrapper> prevFopComponentsMap = new HashMap<FopComponent, VatComponentWrapper>();
        for (FopComponent fc2 : prevFopDetalizationClone.getComponents()) {
            VatComponentWrapper vc2 = this.findVatComponent(fc2, productVatComponents, taxesVatComponents, serviceVatComponents, penaltyVatComponents, deductionVatComponents, specialTaxesVatComponents, specialServiceVatComponents);
            if (vc2 == null) {
                return false;
            }
            prevFopComponentsMap.put(fc2, vc2);
        }
        prevFopComponentsMap.forEach((fc, vc) -> {
            if (!MiscUtil.equals((Object)fc.getVatRate(), (Object)vc.getRate())) {
                fc.setVatRate(vc.getRate());
                fc.setVatAmount(StandardFopDetalizationHelper.getVatAmount(fc.getAmount(), vc.getRate()));
            }
            vc.setBasis(vc.getBasis().subtract(fc.getAmount()));
            if (fc.getVatAmount() != null) {
                vc.setSum(MiscUtil.guarded((BigDecimal)vc.getSum()).subtract(fc.getVatAmount()));
            }
        });
        return true;
    }

    private VatComponentWrapper findVatComponent(FopComponent fc, List<VatComponentWrapper> productVatComponents, List<VatComponentWrapper> taxesVatComponents, List<VatComponentWrapper> serviceVatComponents, List<VatComponentWrapper> penaltyVatComponents, List<VatComponentWrapper> deductionVatComponents, List<VatComponentWrapper> specialTaxesVatComponents, List<VatComponentWrapper> specialServiceVatComponents) {
        if (fc.getType() == null) {
            return null;
        }
        if (!specialTaxesVatComponents.isEmpty() && fc.getType() == FopComponentType.TAXES) {
            for (VatComponentWrapper vc : specialTaxesVatComponents) {
                TaxesFopComponent tfc;
                if (!(fc instanceof TaxesFopComponent) || !MiscUtil.equals((Object)(tfc = (TaxesFopComponent)fc).getTaxes(), (Object)vc.getCode())) continue;
                return vc;
            }
        }
        if (!specialServiceVatComponents.isEmpty() && fc.getType() == FopComponentType.SERVICE) {
            for (VatComponentWrapper vc : specialServiceVatComponents) {
                AddServiceTypeFopComponent specFc;
                if (!(fc instanceof AddServiceTypeFopComponent) || !MiscUtil.equals((Object)(specFc = (AddServiceTypeFopComponent)fc).getServiceType().name(), (Object)vc.getCode())) continue;
                return vc;
            }
        }
        List<VatComponentWrapper> vatComponents = null;
        switch (fc.getType()) {
            case PENALTY: {
                vatComponents = penaltyVatComponents;
                break;
            }
            case DEDUCTION: {
                vatComponents = deductionVatComponents;
                break;
            }
            case TAXES: {
                vatComponents = taxesVatComponents;
                break;
            }
            case SERVICE: {
                vatComponents = serviceVatComponents;
                break;
            }
            case PRODUCT: {
                vatComponents = productVatComponents;
            }
        }
        if (CollectionUtil.isEmpty(vatComponents)) {
            return null;
        }
        for (VatComponentWrapper vc : vatComponents) {
            if (!MiscUtil.equals((Object)vc.getRate(), (Object)fc.getVatRate())) continue;
            return vc;
        }
        return vatComponents.size() == 1 ? vatComponents.get(0) : null;
    }

    private Supplier<FopComponent> fopComponentSupplier(FopComponentType fopComponentType) {
        return () -> {
            FopComponent result = new FopComponent();
            result.setType(fopComponentType);
            return result;
        };
    }
}

