/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.fopDetalization;

import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.BaseFopDetalizationBuilderTest;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.FeeVatRates;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.ProductFopDetalizationBuilder;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.StandardFopDetalizationHelper;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.VatComponentWrapper;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.VatComponentWrapperBuilder;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Test;

public class ProductFopDetalizationBuilderTest
extends BaseFopDetalizationBuilderTest {
    @Test
    public void testOneFopNoVatsOneTraveller() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Collections.emptyList();
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount)).setVatAmount(null)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopNoVatsNoTraveller() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Collections.emptyList();
        Collection<Traveller> travellers = null;
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount)).setVatAmount(null)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopNoVatsAdultAndChild() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Collections.emptyList();
        Traveller adult = new Traveller();
        List<Traveller> travellers = Arrays.asList(adult, new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).addAdults(Collections.singletonList(adult)).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount)).setVatAmount(null)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(BigDecimal.ZERO)).setVatAmount(null)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopOneVatOneTraveller() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        BigDecimal vatAmount = BigDecimal.valueOf(100L);
        double vatRate = 10.0;
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fopAmount).setSum(vatAmount).setRate(10.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount)).setVatAmount(vatAmount)).setVatRate(10.0)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopOnePartialVatOneTraveller() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1200L);
        BigDecimal noVatBasis = BigDecimal.valueOf(200L);
        BigDecimal vatAmount = BigDecimal.valueOf(100L);
        double vatRate = 10.0;
        BigDecimal vatBasis = fopAmount.subtract(noVatBasis);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(vatBasis).setSum(vatAmount).setRate(10.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vatBasis)).setVatAmount(vatAmount)).setVatRate(10.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(noVatBasis)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopOneVatTwoTravellers() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(177L);
        BigDecimal vatAmount = BigDecimal.valueOf(27L);
        double vatRate = 18.0;
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fopAmount).setSum(vatAmount).setRate(18.0).build());
        List<Traveller> travellers = Arrays.asList(new Traveller(), new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).addAdults(travellers).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(BigDecimal.valueOf(88.5))).setVatAmount(BigDecimal.valueOf(13.5))).setVatRate(18.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(BigDecimal.valueOf(88.5))).setVatAmount(BigDecimal.valueOf(13.5))).setVatRate(18.0)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopOneVatThreeTravellers() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(184L);
        BigDecimal vatAmount = BigDecimal.valueOf(28.07);
        double vatRate = 18.0;
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fopAmount).setSum(vatAmount).setRate(18.0).build());
        List<Traveller> travellers = Arrays.asList(new Traveller(), new Traveller(), new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(BigDecimal.valueOf(61.33))).setVatAmount(BigDecimal.valueOf(9.35))).setVatRate(18.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(BigDecimal.valueOf(61.33))).setVatAmount(BigDecimal.valueOf(9.35))).setVatRate(18.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(BigDecimal.valueOf(61.34))).setVatAmount(BigDecimal.valueOf(9.37))).setVatRate(18.0)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopTwoVatsOneTraveller() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        BigDecimal vatBasis1 = BigDecimal.valueOf(800L);
        BigDecimal vatAmount1 = BigDecimal.valueOf(160L);
        double vatRate1 = 20.0;
        BigDecimal vatBasis2 = BigDecimal.valueOf(200L);
        BigDecimal vatAmount2 = BigDecimal.valueOf(20L);
        double vatRate2 = 10.0;
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(vatBasis1).setSum(vatAmount1).setRate(20.0).build(), new VatComponentWrapperBuilder().setBasis(vatBasis2).setSum(vatAmount2).setRate(10.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vatBasis1)).setVatAmount(vatAmount1)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vatBasis2)).setVatAmount(vatAmount2)).setVatRate(10.0)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testTwoFopsTwoVatsOneTraveller() throws Exception {
        BigDecimal fopAmount1 = BigDecimal.valueOf(1000L);
        BigDecimal fopAmount2 = BigDecimal.valueOf(400L);
        BigDecimal vatBasis1 = BigDecimal.valueOf(800L);
        BigDecimal vatAmount1 = BigDecimal.valueOf(160L);
        double vatRate1 = 20.0;
        BigDecimal vatBasis2 = BigDecimal.valueOf(600L);
        BigDecimal vatAmount2 = BigDecimal.valueOf(60L);
        double vatRate2 = 10.0;
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount1).build(), new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount2).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(vatBasis1).setSum(vatAmount1).setRate(20.0).build(), new VatComponentWrapperBuilder().setBasis(vatBasis2).setSum(vatAmount2).setRate(10.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).build();
        BigDecimal fcAmount1 = fopAmount1.multiply(vatBasis1).divide(vatBasis1.add(vatBasis2), 2, 4);
        BigDecimal fcVatAmount1 = vatAmount1.multiply(fopAmount1).divide(fopAmount1.add(fopAmount2), 2, 4);
        BigDecimal fcVatAmount2 = vatAmount2.multiply(fopAmount1).divide(fopAmount1.add(fopAmount2), 2, 4);
        BigDecimal fcAmount2 = fopAmount2.multiply(vatBasis1).divide(vatBasis1.add(vatBasis2), 2, 4);
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fcAmount1)).setVatAmount(fcVatAmount1)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount1.subtract(fcAmount1))).setVatAmount(fcVatAmount2)).setVatRate(10.0)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
        fop = fops.get(1);
        fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fcAmount2)).setVatAmount(vatAmount1.subtract(fcVatAmount1))).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount2.subtract(fcAmount2))).setVatAmount(vatAmount2.subtract(fcVatAmount2))).setVatRate(10.0)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopWithPenalty() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        BigDecimal vatAmount = BigDecimal.valueOf(220L);
        double vatRate = 20.0;
        BigDecimal penalty = BigDecimal.valueOf(-200L);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fopAmount.subtract(penalty)).setSum(vatAmount).setRate(20.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).setPenalty(penalty).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount.subtract(penalty))).setVatAmount(vatAmount)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(penalty)).setVatAmount(null)).setType(FopComponentType.PENALTY)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testTwoFopsWithPenalty() throws Exception {
        BigDecimal fopAmount1 = BigDecimal.valueOf(100L);
        BigDecimal fopAmount2 = BigDecimal.valueOf(900L);
        BigDecimal penalty = BigDecimal.valueOf(-200L);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount1).build(), new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount2).build());
        List<VatComponentWrapper> vatComponents = Collections.emptyList();
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).setPenalty(penalty).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount1.subtract(penalty))).setVatAmount(null)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(penalty)).setVatAmount(null)).setType(FopComponentType.PENALTY)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
        fop = fops.get(1);
        fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount2)).setVatAmount(null)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testTwoFopsWithLargePenalty() throws Exception {
        BigDecimal fopAmount1 = BigDecimal.valueOf(600L);
        BigDecimal fopAmount2 = BigDecimal.valueOf(400L);
        BigDecimal penalty = BigDecimal.valueOf(700L);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount1).build(), new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount2).build());
        List<VatComponentWrapper> vatComponents = Collections.emptyList();
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).setPenalty(penalty.negate()).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount1.add(penalty))).setVatAmount(null)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(penalty.negate())).setVatAmount(null)).setType(FopComponentType.PENALTY)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
        fop = fops.get(1);
        fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount2)).setVatAmount(null)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopWithPenaltyVat() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(800L);
        BigDecimal vatAmount = BigDecimal.valueOf(220L);
        double vatRate = 20.0;
        BigDecimal penalty = BigDecimal.valueOf(200L);
        BigDecimal penaltyVatAmount = BigDecimal.valueOf(20L);
        double penaltyVatRate = 10.0;
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fopAmount.add(penalty)).setSum(vatAmount).setRate(20.0).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.PENALTY).setBasis(penalty).setSum(penaltyVatAmount).setRate(10.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).setPenalty(penalty.negate()).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount.add(penalty))).setVatAmount(vatAmount)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(penalty.negate())).setVatAmount(penaltyVatAmount.negate())).setVatRate(10.0)).setType(FopComponentType.PENALTY)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopWithPenaltyPartialVat() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(800L);
        BigDecimal vatAmount = BigDecimal.valueOf(220L);
        double vatRate = 20.0;
        BigDecimal penalty = BigDecimal.valueOf(-200L);
        BigDecimal penaltyVatBasis = BigDecimal.valueOf(-150L);
        BigDecimal penaltyVatAmount = BigDecimal.valueOf(15L);
        double penaltyVatRate = 10.0;
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fopAmount.subtract(penalty)).setSum(vatAmount).setRate(20.0).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.PENALTY).setBasis(penaltyVatBasis).setSum(penaltyVatAmount).setRate(10.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).setPenalty(penalty).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount.subtract(penalty))).setVatAmount(vatAmount)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(penaltyVatBasis)).setVatAmount(penaltyVatAmount)).setVatRate(10.0)).setType(FopComponentType.PENALTY)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(penalty.subtract(penaltyVatBasis))).setType(FopComponentType.PENALTY)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testTwoFopsOneVatWithPenalty() throws Exception {
        BigDecimal fopAmount1 = BigDecimal.valueOf(800L);
        BigDecimal fopAmount2 = BigDecimal.valueOf(500L);
        BigDecimal penalty = BigDecimal.valueOf(-200L);
        BigDecimal penaltyVatAmount = BigDecimal.valueOf(-20L);
        double penaltyVatRate = 10.0;
        BigDecimal totalFopAmountWithoutPenalty = fopAmount1.add(fopAmount2).subtract(penalty);
        BigDecimal vatAmount = BigDecimal.valueOf(300L);
        double vatRate = 20.0;
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount1).build(), new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount2).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(totalFopAmountWithoutPenalty).setSum(vatAmount).setRate(20.0).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.PENALTY).setBasis(penalty).setSum(penaltyVatAmount).setRate(10.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).setPenalty(penalty).build();
        BigDecimal fcVatAmount1 = vatAmount.multiply(fopAmount1.subtract(penalty)).divide(totalFopAmountWithoutPenalty, 2, 4);
        BigDecimal fcVatAmount2 = vatAmount.multiply(fopAmount2).divide(totalFopAmountWithoutPenalty, 2, 4);
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount1.subtract(penalty))).setVatAmount(fcVatAmount1)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(penalty)).setVatAmount(penaltyVatAmount)).setVatRate(10.0)).setType(FopComponentType.PENALTY)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
        fop = fops.get(1);
        fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount2)).setVatAmount(fcVatAmount2)).setVatRate(20.0)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopWithHiddenFees() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        BigDecimal hiddenAmount = BigDecimal.valueOf(200L);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).addCommission(hiddenAmount).build());
        List vatComponents = Collections.emptyList();
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers){

            @Override
            protected FeeProperties getFeeProperties(GeneralProductCommission commission) {
                return null;
            }
        }.build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount.subtract(hiddenAmount))).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(hiddenAmount)).setHidden()).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopWithHiddenVat() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        BigDecimal hiddenAmount = BigDecimal.valueOf(200L);
        double hiddenVatRate = 20.0;
        BigDecimal hiddenVatAmount = StandardFopDetalizationHelper.getVatAmount(hiddenAmount, 20.0);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).addCommission(hiddenAmount).build());
        List vatComponents = Collections.emptyList();
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        FeeVatRates feeVatRates = new FeeVatRates(null, new double[]{20.0, 20.0});
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers){

            @Override
            protected FeeProperties getFeeProperties(GeneralProductCommission commission) {
                return null;
            }
        }.setFeeVatRate(feeVatRates).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount.subtract(hiddenAmount))).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(hiddenAmount)).setVatAmount(hiddenVatAmount)).setVatRate(20.0)).setHidden()).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopWithTaxes() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        BigDecimal vatAmount = BigDecimal.valueOf(220L);
        double vatRate = 20.0;
        BigDecimal taxes = BigDecimal.valueOf(300L);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fopAmount.subtract(taxes)).setSum(vatAmount).setRate(20.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).separateTaxes(taxes).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount.subtract(taxes))).setVatAmount(vatAmount)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(taxes)).setVatAmount(null)).setType(FopComponentType.TAXES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopWithTaxesVat() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(800L);
        BigDecimal vatAmount = BigDecimal.valueOf(220L);
        double vatRate = 20.0;
        BigDecimal taxes = BigDecimal.valueOf(200L);
        BigDecimal taxesVatAmount = BigDecimal.valueOf(20L);
        double taxesVatRate = 10.0;
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fopAmount.subtract(taxes)).setSum(vatAmount).setRate(20.0).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.TAXES).setBasis(taxes).setSum(taxesVatAmount).setRate(10.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).separateTaxes(taxes).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount.subtract(taxes))).setVatAmount(vatAmount)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(taxes)).setVatAmount(taxesVatAmount)).setVatRate(10.0)).setType(FopComponentType.TAXES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testTwoFopsWithPreviousProduct() throws Exception {
        BigDecimal fopAmount1 = BigDecimal.valueOf(1000L);
        BigDecimal fopAmount2 = BigDecimal.valueOf(400L);
        final BigDecimal vatBasis1 = BigDecimal.valueOf(1000L);
        final BigDecimal vatAmount1 = BigDecimal.valueOf(200L);
        double vatRate1 = 20.0;
        BigDecimal vatBasis2 = BigDecimal.valueOf(400L);
        BigDecimal vatAmount2 = BigDecimal.valueOf(40L);
        double vatRate2 = 10.0;
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount1).setType(PaymentType.TICKET).build(), new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount2).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(vatBasis1).setSum(vatAmount1).setRate(20.0).build(), new VatComponentWrapperBuilder().setBasis(vatBasis2).setSum(vatAmount2).setRate(10.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers){

            @Override
            protected FopDetalization getPreviousFopDetalization(GeneralProductFop fop, ContractType contractType) {
                FopDetalization result = new FopDetalization();
                result.getComponents().add(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vatBasis1)).setVatAmount(vatAmount1)).setVatRate(20.0)).build());
                return result;
            }
        }.build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vatBasis1)).setVatAmount(vatAmount1)).setVatRate(20.0)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
        fop = fops.get(1);
        fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vatBasis2)).setVatAmount(vatAmount2)).setVatRate(10.0)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopAndZeroWithPreviousProduct() throws Exception {
        BigDecimal fopAmount1 = BigDecimal.valueOf(1000L);
        BigDecimal fopAmount2 = BigDecimal.valueOf(0L);
        final BigDecimal vatBasis1 = BigDecimal.valueOf(1000L);
        final BigDecimal vatAmount1 = BigDecimal.valueOf(200L);
        double vatRate1 = 20.0;
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount1).setType(PaymentType.TICKET).build(), new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount2).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(vatBasis1).setSum(vatAmount1).setRate(20.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers){

            @Override
            protected FopDetalization getPreviousFopDetalization(GeneralProductFop fop, ContractType contractType) {
                FopDetalization result = new FopDetalization();
                result.getComponents().add(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vatBasis1)).setVatAmount(vatAmount1)).setVatRate(20.0)).build());
                return result;
            }
        }.setCreateComponentsForZeroFop(true).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vatBasis1)).setVatAmount(vatAmount1)).setVatRate(20.0)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
        fop = fops.get(1);
        fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(BigDecimal.ZERO)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testTwoFopWithTaxesAndPreviousProduct() throws Exception {
        BigDecimal taxes1 = BigDecimal.valueOf(100L);
        BigDecimal vatBasis1 = BigDecimal.valueOf(200L);
        BigDecimal vatAmount1 = BigDecimal.valueOf(40L);
        double vatRate1 = 10.0;
        BigDecimal fopAmount1 = vatBasis1.add(taxes1);
        final BigDecimal taxes2 = BigDecimal.valueOf(300L);
        final BigDecimal vatBasis2 = BigDecimal.valueOf(1000L);
        final BigDecimal vatAmount2 = BigDecimal.valueOf(100L);
        double vatRate2 = 20.0;
        BigDecimal fopAmount2 = vatBasis2.add(taxes2);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount1).build(), new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount2).setType(PaymentType.TICKET).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(vatBasis1).setSum(vatAmount1).setRate(10.0).build(), new VatComponentWrapperBuilder().setBasis(vatBasis2).setSum(vatAmount2).setRate(20.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers){

            @Override
            protected FopDetalization getPreviousFopDetalization(GeneralProductFop fop, ContractType contractType) {
                FopDetalization result = new FopDetalization();
                result.getComponents().addAll(Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vatBasis2)).setVatAmount(vatAmount2)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(taxes2)).setType(FopComponentType.TAXES)).build()));
                return result;
            }
        }.separateTaxes(taxes1.add(taxes2)).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vatBasis1)).setVatAmount(vatAmount1)).setVatRate(10.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(taxes1)).setType(FopComponentType.TAXES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
        fop = fops.get(1);
        fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vatBasis2)).setVatAmount(vatAmount2)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(taxes2)).setType(FopComponentType.TAXES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testXtr9484() throws Exception {
        BigDecimal prevFopAmount = BigDecimal.valueOf(15382L);
        final BigDecimal prevFareAmount = BigDecimal.valueOf(10700L);
        final BigDecimal prevTaxYQAmount = BigDecimal.valueOf(3000L);
        final BigDecimal prevTaxYRAmount = BigDecimal.valueOf(540L);
        final BigDecimal prevTaxRIAmount = BigDecimal.valueOf(1142L);
        BigDecimal fop2Amount = BigDecimal.valueOf(5013L);
        BigDecimal fareAmount = BigDecimal.valueOf(10975L);
        BigDecimal taxYQAmount = BigDecimal.valueOf(4500L);
        BigDecimal taxYRAmount = BigDecimal.valueOf(810L);
        BigDecimal taxRIAmount = BigDecimal.valueOf(1510L);
        BigDecimal penaltyAmount = BigDecimal.valueOf(2600L);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(prevFopAmount).setType(PaymentType.TICKET).build(), new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fop2Amount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.FARE).setBasis(fareAmount).setSum(BigDecimal.valueOf(997.73)).setRate(10.0).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.TAXES).setCode("YR").setBasis(taxYRAmount).setSum(BigDecimal.valueOf(135L)).setRate(20.0).setSeparated().build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.TAXES).setCode("YQ").setBasis(taxYQAmount).setSum(BigDecimal.valueOf(409.09)).setRate(10.0).setSeparated().build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.TAXES).setCode("RI").setBasis(taxRIAmount).setSeparated().build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.PENALTY).setBasis(penaltyAmount).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers){

            @Override
            protected FopDetalization getPreviousFopDetalization(GeneralProductFop fop, ContractType contractType) {
                FopDetalization result = new FopDetalization();
                result.getComponents().addAll(Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setType(FopComponentType.PRODUCT)).setAmount(prevFareAmount)).setVatAmount(BigDecimal.ZERO)).setVatRate(0.0)).build(), ((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)new BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder().setType(FopComponentType.TAXES)).setTaxes("YQ").setAmount(prevTaxYQAmount)).setVatAmount(BigDecimal.ZERO)).setVatRate(0.0)).build(), ((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)new BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder().setType(FopComponentType.TAXES)).setTaxes("YR").setAmount(prevTaxYRAmount)).setVatAmount(BigDecimal.valueOf(90L))).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)new BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder().setType(FopComponentType.TAXES)).setTaxes("RI").setAmount(prevTaxRIAmount)).build()));
                return result;
            }
        }.separateTaxes(MiscUtil.sum((BigDecimal[])new BigDecimal[]{taxYQAmount, taxYRAmount, taxRIAmount})).setPenalty(penaltyAmount).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setType(FopComponentType.PRODUCT)).setAmount(prevFareAmount)).setVatAmount(BigDecimal.valueOf(972.73))).setVatRate(10.0)).build(), ((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)new BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder().setType(FopComponentType.TAXES)).setTaxes("YQ").setAmount(prevTaxYQAmount)).setVatAmount(BigDecimal.valueOf(272.73))).setVatRate(10.0)).build(), ((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)new BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder().setType(FopComponentType.TAXES)).setTaxes("YR").setAmount(prevTaxYRAmount)).setVatAmount(BigDecimal.valueOf(90L))).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)new BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder().setType(FopComponentType.TAXES)).setTaxes("RI").setAmount(prevTaxRIAmount)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
        fop = fops.get(1);
        fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setType(FopComponentType.PRODUCT)).setAmount(fareAmount.subtract(prevFareAmount))).setVatAmount(BigDecimal.valueOf(25L))).setVatRate(10.0)).build(), ((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)new BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder().setType(FopComponentType.TAXES)).setTaxes("YQ").setAmount(taxYQAmount.subtract(prevTaxYQAmount))).setVatAmount(BigDecimal.valueOf(136.36))).setVatRate(10.0)).build(), ((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)new BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder().setType(FopComponentType.TAXES)).setTaxes("YR").setAmount(taxYRAmount.subtract(prevTaxYRAmount))).setVatAmount(BigDecimal.valueOf(45L))).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)((BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder)new BaseFopDetalizationBuilderTest.TaxesFopComponentBuilder().setType(FopComponentType.TAXES)).setTaxes("RI").setAmount(taxRIAmount.subtract(prevTaxRIAmount))).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setType(FopComponentType.PENALTY)).setAmount(penaltyAmount)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testTwoFopWithZeroFareAndTaxesAndPreviousProduct() throws Exception {
        BigDecimal taxes1 = BigDecimal.valueOf(100L);
        BigDecimal vatBasis1 = BigDecimal.valueOf(0L);
        BigDecimal vatAmount1 = BigDecimal.valueOf(0L);
        double vatRate1 = 10.0;
        BigDecimal fopAmount1 = vatBasis1.add(taxes1);
        final BigDecimal taxes2 = BigDecimal.valueOf(300L);
        final BigDecimal vatBasis2 = BigDecimal.valueOf(1000L);
        final BigDecimal vatAmount2 = BigDecimal.valueOf(100L);
        double vatRate2 = 20.0;
        BigDecimal fopAmount2 = vatBasis2.add(taxes2);
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount1).build(), new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount2).setType(PaymentType.TICKET).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(vatBasis1).setSum(vatAmount1).setRate(10.0).build(), new VatComponentWrapperBuilder().setBasis(vatBasis2).setSum(vatAmount2).setRate(20.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers){

            @Override
            protected FopDetalization getPreviousFopDetalization(GeneralProductFop fop, ContractType contractType) {
                FopDetalization result = new FopDetalization();
                result.getComponents().addAll(Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vatBasis2)).setVatAmount(vatAmount2)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(taxes2)).setType(FopComponentType.TAXES)).build()));
                return result;
            }
        }.separateTaxes(taxes1.add(taxes2)).setCreateComponentsForZeroFop(true).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(BigDecimal.ZERO)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(taxes1)).setType(FopComponentType.TAXES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
        fop = fops.get(1);
        fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(vatBasis2)).setVatAmount(vatAmount2)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(taxes2)).setType(FopComponentType.TAXES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopWithServiceVat() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(800L);
        BigDecimal vatAmount = BigDecimal.valueOf(220L);
        double vatRate = 20.0;
        BigDecimal serviceAmount = BigDecimal.valueOf(200L);
        BigDecimal serviceVatAmount = BigDecimal.valueOf(20L);
        double serviceVatRate = 10.0;
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fopAmount.subtract(serviceAmount)).setSum(vatAmount).setRate(20.0).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.SERVICE).setBasis(serviceAmount).setSum(serviceVatAmount).setRate(10.0).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).setServiceAmount(serviceAmount).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount.subtract(serviceAmount))).setVatAmount(vatAmount)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(serviceAmount)).setVatAmount(serviceVatAmount)).setVatRate(10.0)).setType(FopComponentType.SERVICE)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneSeparatedTax() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(800L);
        BigDecimal vatAmount = BigDecimal.valueOf(80L);
        double vatRate = 10.0;
        BigDecimal taxAmount = BigDecimal.valueOf(200L);
        BigDecimal taxVatAmount = BigDecimal.valueOf(20L);
        double taxVatRate = 10.0;
        List<GeneralProductFop> fops = Arrays.asList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fopAmount.subtract(taxAmount)).setSum(vatAmount).setRate(10.0).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.TAXES).setBasis(taxAmount).setSum(taxVatAmount).setRate(10.0).setSeparated().build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount.subtract(taxAmount))).setVatAmount(vatAmount)).setVatRate(10.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(taxAmount)).setVatAmount(taxVatAmount)).setVatRate(10.0)).setType(FopComponentType.TAXES)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopWithDeduction() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        BigDecimal vatAmount = BigDecimal.valueOf(220L);
        double vatRate = 20.0;
        BigDecimal deduction = BigDecimal.valueOf(-150L);
        List<GeneralProductFop> fops = Collections.singletonList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fopAmount.subtract(deduction)).setSum(vatAmount).setRate(20.0).build(), new VatComponentWrapperBuilder().setBasis(deduction).setVatBasisType(VatBasisType.DEDUCTION).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).setDeduction(deduction).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount.subtract(deduction))).setVatAmount(vatAmount)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(deduction)).setVatAmount(null)).setType(FopComponentType.DEDUCTION)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }

    @Test
    public void testOneFopWithDeductionWithVat() throws Exception {
        BigDecimal fopAmount = BigDecimal.valueOf(1000L);
        BigDecimal vatAmount = BigDecimal.valueOf(220L);
        double vatRate = 20.0;
        BigDecimal deduction = BigDecimal.valueOf(-150L);
        BigDecimal deductionVat = BigDecimal.valueOf(-15L);
        double deductionVatRate = 10.0;
        List<GeneralProductFop> fops = Collections.singletonList(new BaseFopDetalizationBuilderTest.GeneralProductFopBuilder().setEquivalentAmount(fopAmount).build());
        List<VatComponentWrapper> vatComponents = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fopAmount.subtract(deduction)).setSum(vatAmount).setRate(20.0).build(), new VatComponentWrapperBuilder().setBasis(deduction).setSum(deductionVat).setRate(10.0).setVatBasisType(VatBasisType.DEDUCTION).build());
        List<Traveller> travellers = Collections.singletonList(new Traveller());
        Map<String, FopDetalization> fopDetalizationMap = new ProductFopDetalizationBuilder(fops, vatComponents, travellers).setDeduction(deduction).build();
        GeneralProductFop fop = fops.get(0);
        List fopComponentsAct = fopDetalizationMap.get(fop.getUid()).getComponents();
        List<FopComponent> fopComponentsExp = Arrays.asList(((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(fopAmount.subtract(deduction))).setVatAmount(vatAmount)).setVatRate(20.0)).build(), ((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)((BaseFopDetalizationBuilderTest.FopComponentBuilder)new BaseFopDetalizationBuilderTest.FopComponentBuilder().setAmount(deduction)).setVatAmount(deductionVat)).setVatRate(10.0)).setType(FopComponentType.DEDUCTION)).build());
        this.assertFopComponents(fopComponentsExp, fopComponentsAct);
    }
}

