/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.fopDetalization;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AddServiceTypeFopComponent;
import com.gridnine.xtrip.common.model.booking.AdditionalService;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.CategoryFopComponent;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceData;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceDataDetalization;
import com.gridnine.xtrip.common.model.booking.ContractRelationVatDetalization;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopComponentType;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.NomenclatureSettings;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.TaxesFopComponent;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractRelationType;
import com.gridnine.xtrip.common.model.rules.standard.nomenclatures.NomenclatureActionSet;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.FeeVatRates;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.FeesFopDetalizationBuilder;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.ProductFopDetalizationBuilder;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.VatComponentWrapper;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.VatComponentsCollector;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class StandardFopDetalizationHelper {
    private static Map<FopType, List<FopComponentType>> VALID_FOP_COMPONENT_TYPES = new HashMap<FopType, List<FopComponentType>>();
    private static List<ProductStatus> NEGATE_PRODUCT_STATUSES = Arrays.asList(ProductStatus.REFUND, ProductStatus.EXCHANGE);
    private static List<FopComponentType> FEE_COMPONENT_TYPES;

    public static void updateFopDetalizations(BaseProduct bp, boolean force) throws Exception {
        ProductHandler productHandler = HandlersRegistry.get().findProductHandler(bp.getClass());
        MessageHelper.removeMessages((Collection)productHandler.getValidationMessages(bp), (ValidationMessageCategory)ValidationMessageCategory.FOP_DETALIZATION);
        StandardFopDetalizationHelper.clearContractRelationFopDetalizations(bp, null);
        Map<GeneralProductContractRelationData, NomenclatureSettings> crNomenclatureSettings = StandardFopDetalizationHelper.getContractRelationNomenclatureSettings(bp);
        for (Map.Entry<GeneralProductContractRelationData, NomenclatureSettings> entry : crNomenclatureSettings.entrySet()) {
            GeneralProductContractRelationData contractRelation = entry.getKey();
            NomenclatureSettings nomenclatureSettings = entry.getValue();
            StandardFopDetalizationHelper.updateFopDetalizations(bp, contractRelation, nomenclatureSettings, force);
        }
    }

    public static void updateFopDetalizations(BaseProduct bp, GeneralProductContractRelationData contractRelation, NomenclatureSettings settings, boolean force) throws Exception {
        EntityReference payer;
        EntityContainer description;
        GeneralProductContractRelationData vendorCR;
        if (contractRelation == null) {
            return;
        }
        if (ShipmentHelper.hasRelatedShipment(bp, contractRelation.getFops())) {
            return;
        }
        ContractType contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
        ProductHandler productHandler = HandlersRegistry.get().findProductHandler(bp.getClass());
        if (settings == null) {
            StandardFopDetalizationHelper.clearContractRelationFopDetalizations(bp, contractRelation);
            return;
        }
        if (contractRelation.getGeneralData().getCurrency() == null) {
            StandardFopDetalizationHelper.clearContractRelationFopDetalizations(bp, contractRelation);
            productHandler.getValidationMessages(bp).add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.FOP_DETALIZATION_CONTRACT_CURRENCY_IS_NULL, (Object[])new Object[]{contractType}));
            return;
        }
        if (contractRelation.getGeneralData().getContractData().getContract() == null) {
            StandardFopDetalizationHelper.clearContractRelationFopDetalizations(bp, contractRelation);
            productHandler.getValidationMessages(bp).add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.FOP_DETALIZATION_CONTRACT_IS_NULL, (Object[])new Object[]{contractType}));
            return;
        }
        Object nomenclatureRulesHandler = ServerHandlersRegistry.get().findNomenclatureRulesHandler(bp.getClass());
        if (nomenclatureRulesHandler == null) {
            StandardFopDetalizationHelper.clearContractRelationFopDetalizations(bp, contractRelation);
            productHandler.getValidationMessages(bp).add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.FOP_DETALIZATION_NOMENCLATURE_HANDLER_IS_NULL, (Object[])new Object[]{contractType}));
            return;
        }
        RuleProxy<?, NomenclatureActionSet> proxy = ServerHandlersRegistry.get().findNomenclatureRulesHandler(bp.getClass()).createProxy((BaseProduct)bp);
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)settings.getRuleSet());
        NomenclatureActionSet nomenclatureActionSet = (NomenclatureActionSet)proxy.getActionSet();
        List fops = contractRelation.getFops();
        Collection travellers = productHandler.getTravellers(bp);
        if (CollectionUtil.isEmpty((Collection)travellers) && !productHandler.isNoTraveller()) {
            bp.getFopDetalizations().clear();
            productHandler.getValidationMessages(bp).add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.FOP_DETALIZATION_NO_TRAVELLERS, (Object[])new Object[]{contractType}));
            return;
        }
        HashSet<Traveller> adults = new HashSet<Traveller>();
        if (travellers != null) {
            travellers.forEach(tr -> {
                DictionaryReference passengerType = productHandler.getPassengerType(bp, tr);
                if (DictHelper.isAdultPassengerTypeCategory((DictionaryReference)passengerType)) {
                    adults.add((Traveller)tr);
                }
            });
        }
        List contractRelations = GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)bp);
        int crIndex = contractRelations.indexOf(contractRelation);
        GeneralProductContractRelationData technicalProviderCR = null;
        GeneralProductContractRelationData generalProductContractRelationData = vendorCR = crIndex > 0 ? (GeneralProductContractRelationData)contractRelations.get(crIndex - 1) : null;
        if (vendorCR != null && (description = EntityStorage.get().resolve(vendorCR.getDescription())) != null && PredefinedContractRelationType.TECHNICAL_PROVIDER_TO_AGENCY.equals((Object)((ContractRelationDescription)description.getEntity()).getPredefinedType())) {
            technicalProviderCR = vendorCR;
            vendorCR = crIndex - 2 >= 0 ? (GeneralProductContractRelationData)contractRelations.get(crIndex - 2) : null;
        }
        ProductStatus productStatus = productHandler.getStatus(bp);
        ArrayList<GeneralProductFop> productFops = new ArrayList<GeneralProductFop>();
        ArrayList<GeneralProductFop> feeFops = new ArrayList<GeneralProductFop>();
        for (GeneralProductFop fop : fops) {
            if (GeneralProductHelper.getFopType((GeneralProductFop)fop) == FopType.PRODUCT) {
                productFops.add(fop);
                continue;
            }
            feeFops.add(fop);
        }
        ContractRelationServiceData clientServiceData = contractRelation.getServiceData();
        StandardFopDetalizationHelper.checkVatDetalization(bp, (ProductHandler<BaseProduct>)productHandler, clientServiceData);
        ContractRelationServiceDataDetalization clientCRDetalization = clientServiceData.getDetalization();
        VatComponentsCollector vatComponentsCollector = new VatComponentsCollector(clientServiceData).addSpecialTaxes(clientCRDetalization.getTaxes());
        if (bp instanceof HotelProduct && clientCRDetalization.getAdditionalServices() != null) {
            HashMap<AdditionalService, AdditionalServiceType> hotelAdditionalServices = new HashMap<AdditionalService, AdditionalServiceType>();
            HotelProduct hp = (HotelProduct)bp;
            clientCRDetalization.getAdditionalServices().getAdditionalServices().forEach(as -> {
                com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService hotelAddService = (com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService)CollectionUtil.find((Iterable)hp.getAdditionalServices(), (String)as.getSource());
                if (hotelAddService != null) {
                    hotelAdditionalServices.put((AdditionalService)as, hotelAddService.getType());
                }
            });
            vatComponentsCollector.setAdditionalServices(hotelAdditionalServices);
        }
        List<VatComponentWrapper> rateVatComponents = vatComponentsCollector.collect();
        BigDecimal penalty = StandardFopDetalizationHelper.calcPenalty(clientCRDetalization, bp);
        BigDecimal deduction = StandardFopDetalizationHelper.calcDeduction(clientCRDetalization);
        if (NEGATE_PRODUCT_STATUSES.contains(productStatus)) {
            penalty = penalty.negate();
            deduction = MiscUtil.negate((BigDecimal)deduction);
        }
        double[] vendorFeeVatRate = null;
        if (vendorCR != null) {
            payer = vendorCR.getFops().stream().filter(f -> f.getType() != PaymentType.TICKET).map(GeneralProductFop::getPayer).filter(Objects::nonNull).findFirst().orElse(null);
            vendorFeeVatRate = GeneralProductHelper.getFeeVatRate((BaseProduct)bp, (EntityReference)vendorCR.getDescription(), (ContractRelationVatDetalization)vendorCR.getServiceData().getDetalization().getVat(), (EntityReference)payer);
        }
        payer = contractRelation.getFops().stream().filter(f -> f.getType() != PaymentType.TICKET).map(GeneralProductFop::getPayer).filter(Objects::nonNull).findFirst().orElse(null);
        double[] feeVatRate = GeneralProductHelper.getFeeVatRate((BaseProduct)bp, (EntityReference)contractRelation.getDescription(), (ContractRelationVatDetalization)contractRelation.getServiceData().getDetalization().getVat(), (EntityReference)payer);
        BigDecimal serviceFees = clientCRDetalization.getAdditionalFee();
        BigDecimal taxes = StandardFopDetalizationHelper.calcTaxes(clientCRDetalization, bp);
        HashMap<String, FopDetalization> fopDetalizationsNew = new HashMap<String, FopDetalization>();
        boolean createComponentsForZeroFop = !nomenclatureActionSet.isDisableCreateComponentsForZeroFop();
        ProductFopDetalizationBuilder productFopDetalizationBuilder = new ProductFopDetalizationBuilder(productFops, rateVatComponents, travellers).addAdults(adults).separateTaxes(taxes).setPenalty(penalty).setDeduction(deduction).setFeeVatRate(new FeeVatRates(productStatus, feeVatRate)).setServiceAmount(serviceFees).setCreateComponentsForZeroFop(createComponentsForZeroFop).setPreviousProduct(productHandler.getPreviousProduct(bp)).setContractType(contractType);
        fopDetalizationsNew.putAll(productFopDetalizationBuilder.build());
        List<GeneralProductCommission> ownFeesCommissions = StandardFopDetalizationHelper.getOwnFeesCommissions(contractRelation, vendorCR, technicalProviderCR);
        FeesFopDetalizationBuilder feesFopDetalizationBuilder = new FeesFopDetalizationBuilder(feeFops, travellers, vendorFeeVatRate, feeVatRate).addAdults(adults).addOwnFeesCommissions(ownFeesCommissions).setProductStatus(productStatus);
        fopDetalizationsNew.putAll(feesFopDetalizationBuilder.build());
        StandardFopDetalizationHelper.clearUnprocessedFops(fopDetalizationsNew, fops, productStatus);
        StandardFopDetalizationHelper.setNomenclatures(fopDetalizationsNew, nomenclatureActionSet);
        Set fopUids = fops.stream().map(BaseIdentity::getUid).collect(Collectors.toSet());
        Map<String, FopDetalization> fopDetalizationsOld = bp.getFopDetalizations().entrySet().stream().filter(entry -> fopUids.contains(entry.getKey())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (FopDetalization)entry.getValue()));
        StandardFopDetalizationHelper.mergeFopDetalizations(fopDetalizationsOld, fopDetalizationsNew);
        StandardFopDetalizationHelper.clearContractRelationFopDetalizations(bp, contractRelation);
        bp.getFopDetalizations().putAll(fopDetalizationsOld);
    }

    private static void clearContractRelationFopDetalizations(BaseProduct bp, GeneralProductContractRelationData contractRelation) {
        if (contractRelation == null) {
            Set fopUids = GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)bp).stream().flatMap(cr -> cr.getFops().stream()).map(BaseIdentity::getUid).collect(Collectors.toSet());
            bp.getFopDetalizations().entrySet().removeIf(entry -> !fopUids.contains(entry.getKey()));
            return;
        }
        Set fopUids = contractRelation.getFops().stream().map(BaseIdentity::getUid).collect(Collectors.toSet());
        bp.getFopDetalizations().entrySet().removeIf(entry -> fopUids.contains(entry.getKey()));
    }

    private static void setNomenclatures(Map<String, FopDetalization> fopDetalizationsNew, NomenclatureActionSet nomenclatureActionSet) {
        for (FopDetalization detalization : fopDetalizationsNew.values()) {
            for (FopComponent fopComponent : detalization.getComponents()) {
                DictionaryReference nomenclature;
                TaxesFopComponent fc;
                if (fopComponent instanceof TaxesFopComponent) {
                    fc = (TaxesFopComponent)fopComponent;
                    nomenclature = (DictionaryReference)nomenclatureActionSet.getSpecialTaxesNomenclatures().get(fc.getTaxes());
                    if (nomenclature != null) {
                        fopComponent.setNomenclature(nomenclature);
                        continue;
                    }
                    nomenclature = nomenclatureActionSet.getTaxesWithVatRateNomenclatures().entrySet().stream().filter(entry -> MiscUtil.equals(entry.getKey(), (Object)fc.getVatRate()) && entry.getValue() != null).map(Map.Entry::getValue).findFirst().orElse(null);
                    if (nomenclature != null) {
                        fopComponent.setNomenclature(nomenclature);
                        continue;
                    }
                }
                if (fopComponent instanceof AddServiceTypeFopComponent) {
                    fc = (AddServiceTypeFopComponent)fopComponent;
                    nomenclature = (DictionaryReference)nomenclatureActionSet.getAddServiceTypeNomenclatures().get(fc.getServiceType());
                    if (nomenclature != null) {
                        fopComponent.setNomenclature(nomenclature);
                        continue;
                    }
                }
                if (fopComponent instanceof CategoryFopComponent && fopComponent.getType() == FopComponentType.VENDOR_FEES) {
                    fc = (CategoryFopComponent)fopComponent;
                    nomenclature = (DictionaryReference)nomenclatureActionSet.getVendorFeesNomenclatures().get(fc.getCategory());
                    if (nomenclature != null) {
                        fopComponent.setNomenclature(nomenclature);
                        continue;
                    }
                }
                if (fopComponent instanceof CategoryFopComponent && fopComponent.getType() == FopComponentType.OWN_FEES) {
                    fc = (CategoryFopComponent)fopComponent;
                    nomenclature = (DictionaryReference)nomenclatureActionSet.getOwnFeesNomenclatures().get(fc.getCategory());
                    if (nomenclature != null) {
                        fopComponent.setNomenclature(nomenclature);
                        continue;
                    }
                }
                if (fopComponent.getType() == FopComponentType.TAXES && nomenclatureActionSet.getTaxesNomenclature() != null) {
                    fopComponent.setNomenclature(nomenclatureActionSet.getTaxesNomenclature());
                    continue;
                }
                if (fopComponent.getType() == FopComponentType.PENALTY && nomenclatureActionSet.getPenaltyNomenclature() != null) {
                    fopComponent.setNomenclature(nomenclatureActionSet.getPenaltyNomenclature());
                    continue;
                }
                if (fopComponent.getType() == FopComponentType.DEDUCTION && nomenclatureActionSet.getDeductionNomenclature() != null) {
                    fopComponent.setNomenclature(nomenclatureActionSet.getDeductionNomenclature());
                    continue;
                }
                if (fopComponent.getType() == FopComponentType.VENDOR_FEES && nomenclatureActionSet.getVendorFeeNomenclature() != null) {
                    fopComponent.setNomenclature(nomenclatureActionSet.getVendorFeeNomenclature());
                    continue;
                }
                if (fopComponent.getType() == FopComponentType.TECHNICAL_PROVIDER_FEES && nomenclatureActionSet.getTechnicalProviderFeeNomenclature() != null) {
                    fopComponent.setNomenclature(nomenclatureActionSet.getTechnicalProviderFeeNomenclature());
                    continue;
                }
                if (FEE_COMPONENT_TYPES.contains(fopComponent.getType()) && nomenclatureActionSet.getFeeNomenclature() != null) {
                    fopComponent.setNomenclature(nomenclatureActionSet.getFeeNomenclature());
                    continue;
                }
                if (fopComponent.getType() == FopComponentType.SERVICE && nomenclatureActionSet.getServiceNomenclature() != null) {
                    fopComponent.setNomenclature(nomenclatureActionSet.getServiceNomenclature());
                    continue;
                }
                if (fopComponent.getType() == FopComponentType.PRODUCT && fopComponent.isHidden() && nomenclatureActionSet.getHiddenFeeNomenclature() != null) {
                    fopComponent.setNomenclature(nomenclatureActionSet.getHiddenFeeNomenclature());
                    continue;
                }
                fopComponent.setNomenclature(nomenclatureActionSet.getProductNomenclature());
            }
        }
    }

    public static Map<GeneralProductContractRelationData, NomenclatureSettings> getContractRelationNomenclatureSettings(BaseProduct bp) {
        SalesChain salesChain = GeneralProductHelper.getHandler((BaseProduct)bp).getSalesChain(bp);
        SearchQuery nomenclatureQuery = new SearchQuery();
        nomenclatureQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)"entityType", (Object)NomenclatureSettings.class.getName()));
        List ctrs = StorageHelper.getEntityContainers((SearchQuery)nomenclatureQuery, BasicSystemSettingsIndex.class);
        NomenclatureSettings defaultSettings = StandardFopDetalizationHelper.getDefaultNomenclatureSettings(ctrs);
        HashMap<GeneralProductContractRelationData, NomenclatureSettings> result = new HashMap<GeneralProductContractRelationData, NomenclatureSettings>();
        for (GeneralProductContractRelationData cr : GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)bp)) {
            NomenclatureSettings nomenclatureSettings = null;
            if (GeneralProductHelper.getContractType((EntityReference)cr.getDescription()) != ContractType.VENDOR) {
                EntityReference supplierRef = GeneralProductHelper.getContractRelationSupplier((EntityReference)cr.getDescription(), (SalesChain)salesChain);
                nomenclatureSettings = (NomenclatureSettings)MiscUtil.guarded((Object)StandardFopDetalizationHelper.findNomenclatureSettings(ctrs, (EntityReference<Organization>)supplierRef), (Object)defaultSettings);
            }
            result.put(cr, nomenclatureSettings);
        }
        return result;
    }

    private static NomenclatureSettings getDefaultNomenclatureSettings(List<EntityContainer<BaseSystemSettings>> ctrs) {
        EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        if (allAgenciesProfile == null) {
            return null;
        }
        return StandardFopDetalizationHelper.findNomenclatureSettings(ctrs, (EntityReference<Organization>)allAgenciesProfile);
    }

    private static NomenclatureSettings findNomenclatureSettings(List<EntityContainer<BaseSystemSettings>> ctrs, EntityReference<Organization> agencyRef) {
        for (EntityContainer<BaseSystemSettings> ctr : ctrs) {
            NomenclatureSettings settings = (NomenclatureSettings)ctr.getEntity();
            if (!MiscUtil.equals((Object)settings.getAgency(), agencyRef)) continue;
            return settings;
        }
        return null;
    }

    private static boolean isProcessedFop(GeneralProductFop fop) {
        return true;
    }

    private static void clearUnprocessedFops(Map<String, FopDetalization> fopDetalizations, List<GeneralProductFop> fops, ProductStatus status) {
        Iterator<Map.Entry<String, FopDetalization>> it = fopDetalizations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, FopDetalization> entry = it.next();
            GeneralProductFop fop = (GeneralProductFop)CollectionUtil.find(fops, (String)entry.getKey());
            if (StandardFopDetalizationHelper.isProcessedFop(fop)) continue;
            it.remove();
        }
    }

    private static void checkFopDetalizations(BaseProduct bp, GeneralProductContractRelationData contractRelation, ProductHandler<BaseProduct> productHandler) {
        if (bp.getFopDetalizations() == null) {
            productHandler.getValidationMessages(bp).add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.FOP_DETALIZATION_IS_NULL));
            return;
        }
        ContractRelationServiceData clientServiceData = contractRelation.getServiceData();
        StandardFopDetalizationHelper.checkVatDetalization(bp, productHandler, clientServiceData);
        for (GeneralProductFop fop : contractRelation.getFops()) {
            BigDecimal detalizationAmount;
            FopDetalization fopDetalization = (FopDetalization)bp.getFopDetalizations().get(fop.getUid());
            if (fopDetalization == null) {
                productHandler.getValidationMessages(bp).add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.FOP_DETALIZATION_MISSING_FOR_FOP, (Object[])new Object[]{ContractType.CLIENT, fop.getType(), GeneralProductHelper.getFopType((GeneralProductFop)fop)}));
                continue;
            }
            BigDecimal fopAmount = MiscUtil.guarded((BigDecimal)fop.getEquivalentAmount());
            if (fopAmount.compareTo(detalizationAmount = fopDetalization.getComponents().stream().filter(Objects::nonNull).map(FopComponent::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
                productHandler.getValidationMessages(bp).add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.FOP_DETALIZATION_DIFFERENT_AMOUNTS_FOR_FOP, (Object[])new Object[]{fopAmount, detalizationAmount, ContractType.CLIENT, fop.getType(), GeneralProductHelper.getFopType((GeneralProductFop)fop)}));
            }
            List<FopComponentType> validFopComponentTypes = VALID_FOP_COMPONENT_TYPES.get(GeneralProductHelper.getFopType((GeneralProductFop)fop));
            for (FopComponent fopComponent : fopDetalization.getComponents()) {
                boolean vatRateIsNull;
                productHandler.getValidationMessages(bp).add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.FOP_DETALIZATION_NO_TRAVELLER, (Object[])new Object[]{ContractType.CLIENT, fop.getType(), GeneralProductHelper.getFopType((GeneralProductFop)fop)}));
                if (validFopComponentTypes == null || !validFopComponentTypes.contains(fopComponent.getType())) {
                    productHandler.getValidationMessages(bp).add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.FOP_DETALIZATION_INVALID_FOP_COMPONENT_TYPE, (Object[])new Object[]{fopComponent.getType(), validFopComponentTypes, ContractType.CLIENT, fop.getType(), GeneralProductHelper.getFopType((GeneralProductFop)fop)}));
                }
                boolean vatAmountIsNull = fopComponent.getVatAmount() == null;
                boolean bl = vatRateIsNull = fopComponent.getVatRate() == null;
                if ((!vatAmountIsNull || vatRateIsNull) && (vatAmountIsNull || !vatRateIsNull)) continue;
                productHandler.getValidationMessages(bp).add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.FOP_DETALIZATION_INVALID_FOP_COMPONENT_VAT, (Object[])new Object[]{fopComponent.getType(), ContractType.CLIENT, fop.getType(), GeneralProductHelper.getFopType((GeneralProductFop)fop)}));
            }
        }
    }

    private static void checkVatDetalization(BaseProduct bp, ProductHandler<BaseProduct> productHandler, ContractRelationServiceData clientServiceData) {
        ContractRelationVatDetalization vatDetalization = clientServiceData.getDetalization().getVat();
        if (vatDetalization == null) {
            return;
        }
        vatDetalization.getComponents().forEach(vc -> {
            if (!vc.getTaxesUids().isEmpty() && !vc.getBasisTypes().contains(VatBasisType.TAXES)) {
                productHandler.getValidationMessages(bp).add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.FOP_DETALIZATION_NO_TAX_BASIS_IN_VAT_DETALIZATION));
            }
        });
    }

    public static List<FopComponent> buildDetailsItems(FopComponentType fopComponentType, BigDecimal amount, BigDecimal vatAmount, Double vatRate, boolean hidden, Collection<Traveller> travellers) {
        return StandardFopDetalizationHelper.buildDetailsItems(fopComponentType, amount, vatAmount, vatRate, hidden, travellers, Collections.emptyList());
    }

    public static List<FopComponent> buildDetailsItems(FopComponentType fopComponentType, BigDecimal amount, BigDecimal vatAmount, Double vatRate, boolean hidden, Collection<Traveller> travellers, Collection<Traveller> adults) {
        return StandardFopDetalizationHelper.buildDetailsItems(amount, vatAmount, vatRate, hidden, travellers, adults, null, () -> {
            FopComponent result = new FopComponent();
            result.setType(fopComponentType);
            return result;
        });
    }

    public static List<FopComponent> buildDetailsItems(BigDecimal amount, BigDecimal vatAmount, Double vatRate, boolean hidden, Collection<Traveller> travellers, Collection<Traveller> adults, VatComponentWrapper vatComponent, Supplier<FopComponent> fopComponentSupplier) {
        ArrayList<FopComponent> result = new ArrayList<FopComponent>();
        BigDecimal travellerAmount = BigDecimal.ONE;
        if (travellers.isEmpty()) {
            travellers.add(null);
        } else {
            travellerAmount = adults.size() > 0 ? amount.divide(BigDecimal.valueOf(adults.size()), 2, 3) : amount.divide(BigDecimal.valueOf(travellers.size()), 2, 3);
        }
        BigDecimal remainderAmount = amount;
        boolean hasVat = vatAmount != null;
        BigDecimal vatSum = MiscUtil.guarded((BigDecimal)vatAmount);
        BigDecimal travellerVatAmount = adults.size() > 0 ? vatSum.divide(BigDecimal.valueOf(adults.size()), 2, 3) : vatSum.divide(BigDecimal.valueOf(travellers.size()), 2, 3);
        BigDecimal remainderVatAmount = vatSum;
        Iterator<Traveller> iterator = travellers.iterator();
        while (iterator.hasNext()) {
            boolean notAdultCase;
            Traveller traveller = iterator.next();
            FopComponent item = fopComponentSupplier.get();
            if (vatComponent != null && item instanceof TaxesFopComponent) {
                TaxesFopComponent tfc = (TaxesFopComponent)item;
                tfc.setTaxes(vatComponent.getCode());
            }
            if (vatComponent != null && item instanceof AddServiceTypeFopComponent) {
                AddServiceTypeFopComponent fc = (AddServiceTypeFopComponent)item;
                fc.getSources().addAll(vatComponent.getSources());
                fc.setServiceType((AdditionalServiceType)EnumUtil.fromNameSafe(AdditionalServiceType.class, (String)vatComponent.getCode(), null));
            }
            item.setHidden(hidden);
            item.setTraveller(traveller);
            item.setVatRate(vatRate);
            boolean bl = notAdultCase = adults.size() > 0 && !adults.contains(traveller);
            if (iterator.hasNext()) {
                if (notAdultCase) {
                    item.setAmount(BigDecimal.ZERO);
                    if (hasVat) {
                        item.setVatAmount(BigDecimal.ZERO);
                    }
                } else {
                    item.setAmount(travellerAmount);
                    remainderAmount = remainderAmount.subtract(travellerAmount);
                    if (hasVat) {
                        item.setVatAmount(travellerVatAmount);
                        remainderVatAmount = remainderVatAmount.subtract(travellerVatAmount);
                    }
                }
            } else {
                item.setAmount(remainderAmount);
                if (hasVat) {
                    item.setVatAmount(remainderVatAmount);
                }
            }
            result.add(item);
        }
        return result;
    }

    public static BigDecimal getVatAmount(BigDecimal totalWithVat, Double vatRate) {
        if (totalWithVat == null || vatRate == null) {
            return null;
        }
        VatAmount va = new VatAmount();
        va.setTotalVat(totalWithVat, vatRate.doubleValue());
        return va.getVatAmount();
    }

    public static BigDecimal round(BigDecimal value) {
        return value.setScale(2, 4);
    }

    public static BaseProduct getPreviousSellProduct(BaseProduct bp, ProductHandler<BaseProduct> ph) {
        BaseProduct prevProduct = ph.getPreviousProduct(bp);
        BaseProduct result = null;
        while (prevProduct != null) {
            if (ph.getStatus(prevProduct) == ProductStatus.SELL) {
                result = prevProduct;
            }
            prevProduct = ph.getPreviousProduct(prevProduct);
        }
        return result;
    }

    public static List<GeneralProductCommission> getOwnFeesCommissions(GeneralProductContractRelationData clientCR, GeneralProductContractRelationData subagentCR, GeneralProductContractRelationData technicalProviderCR) {
        if (subagentCR == null) {
            return clientCR.getCommissions();
        }
        List client = GeneralProductHelper.retainCommissions((List)clientCR.getCommissions(), (DictionaryReference)GeneralProductHelper.getCurrency((BaseContractRelationData)clientCR), (List)subagentCR.getCommissions(), (DictionaryReference)GeneralProductHelper.getCurrency((BaseContractRelationData)subagentCR));
        List result = new ArrayList(client);
        if (technicalProviderCR != null) {
            result = GeneralProductHelper.retainCommissions((List)client, (DictionaryReference)GeneralProductHelper.getCurrency((BaseContractRelationData)clientCR), (List)technicalProviderCR.getCommissions(), (DictionaryReference)GeneralProductHelper.getCurrency((BaseContractRelationData)technicalProviderCR));
        }
        return result.stream().filter(c -> {
            EntityContainer prop = EntityStorage.get().resolve(c.getCommissionProperties());
            return null == prop || FeeProperties.class.isAssignableFrom(prop.getEntityType()) || PaymentFeeProperties.class.isAssignableFrom(prop.getEntityType());
        }).collect(Collectors.toList());
    }

    public static void correctEmptyComponents(Map<String, FopDetalization> fopDetalizations, List<GeneralProductFop> fops, Collection<VatComponentWrapper> rateVatComponents, Collection<Traveller> travellers) {
        StandardFopDetalizationHelper.correctEmptyComponents(fopDetalizations, fops, rateVatComponents, travellers, Collections.emptyList());
    }

    public static void correctEmptyComponents(Map<String, FopDetalization> fopDetalizations, List<GeneralProductFop> fops, Collection<VatComponentWrapper> rateVatComponents, Collection<Traveller> travellers, Collection<Traveller> adults) {
        boolean isEmptyComponents = true;
        FopDetalization firstProductFD = null;
        for (Map.Entry<String, FopDetalization> entry : fopDetalizations.entrySet()) {
            FopDetalization fd = entry.getValue();
            if (!fd.getComponents().isEmpty()) {
                isEmptyComponents = false;
            }
            GeneralProductFop fop = (GeneralProductFop)CollectionUtil.find(fops, (String)entry.getKey());
            if (firstProductFD != null || GeneralProductHelper.getFopType((GeneralProductFop)fop) != FopType.PRODUCT) continue;
            firstProductFD = fd;
        }
        if (isEmptyComponents && firstProductFD != null) {
            VatComponentWrapper vatComponent = rateVatComponents.stream().filter(vc -> vc.getBasisType() != VatBasisType.PENALTY).findFirst().orElse(null);
            Double vatRate = null;
            BigDecimal vatAmount = null;
            if (vatComponent != null && vatComponent.getSum() != null) {
                vatRate = vatComponent.getRate();
                vatAmount = BigDecimal.ZERO;
            }
            firstProductFD.getComponents().addAll(StandardFopDetalizationHelper.buildDetailsItems(FopComponentType.PRODUCT, BigDecimal.ZERO, vatAmount, vatRate, false, travellers, adults));
        }
    }

    private static boolean sameComponent(FopComponent component1, FopComponent component2) {
        TaxesFopComponent c2;
        TaxesFopComponent c1;
        if (!MiscUtil.equals(component1.getClass(), component2.getClass())) {
            return false;
        }
        if (!MiscUtil.equals((Object)component1.getTraveller(), (Object)component2.getTraveller())) {
            return false;
        }
        if (!MiscUtil.equals((Object)component1.getType(), (Object)component2.getType())) {
            return false;
        }
        if (!MiscUtil.equals((Object)component1.getNomenclature(), (Object)component2.getNomenclature())) {
            return false;
        }
        if (!MiscUtil.equals((Object)component1.isHidden(), (Object)component2.isHidden())) {
            return false;
        }
        if (!MiscUtil.equals((Object)component1.getAmount(), (Object)component2.getAmount())) {
            return false;
        }
        if (!MiscUtil.equals((Object)component1.getVatAmount(), (Object)component2.getVatAmount())) {
            return false;
        }
        if (!MiscUtil.equals((Object)component1.getVatRate(), (Object)component2.getVatRate())) {
            return false;
        }
        if (!MiscUtil.equals((Object)component1.getShipment(), (Object)component2.getShipment())) {
            return false;
        }
        if (component1 instanceof TaxesFopComponent) {
            c1 = (TaxesFopComponent)component1;
            c2 = (TaxesFopComponent)component2;
            if (!MiscUtil.equals((Object)c1.getTaxes(), (Object)c2.getTaxes())) {
                return false;
            }
        }
        if (component1 instanceof CategoryFopComponent) {
            c1 = (CategoryFopComponent)component1;
            c2 = (CategoryFopComponent)component2;
            if (!MiscUtil.equals((Object)c1.getCategory(), (Object)c2.getCategory())) {
                return false;
            }
        }
        if (component1 instanceof AddServiceTypeFopComponent) {
            c1 = (AddServiceTypeFopComponent)component1;
            c2 = (AddServiceTypeFopComponent)component2;
            if (!CollectionUtil.equals((Collection)c1.getSources(), (Collection)c2.getSources(), (boolean)true)) {
                return false;
            }
        }
        return true;
    }

    private static void mergeFopComponents(List<FopComponent> targetComponents, List<FopComponent> sourceComponents) {
        ArrayList<FopComponent> resultComponents = new ArrayList<FopComponent>();
        for (FopComponent sourceComponent : sourceComponents) {
            FopComponent targetComponent = targetComponents.stream().filter(tc -> sourceComponent.getType() == tc.getType()).findFirst().orElse(null);
            if (targetComponent != null) {
                sourceComponent.setShipment(targetComponent.getShipment());
            }
            if ((targetComponent = (FopComponent)targetComponents.stream().filter(tc -> StandardFopDetalizationHelper.sameComponent(tc, sourceComponent)).findFirst().orElse(null)) == null) {
                targetComponent = sourceComponent;
            } else {
                targetComponents.remove(targetComponent);
            }
            resultComponents.add(targetComponent);
        }
        targetComponents.clear();
        targetComponents.addAll(resultComponents);
    }

    public static void mergeFopDetalizations(Map<String, FopDetalization> target, Map<String, FopDetalization> source) {
        for (Map.Entry<String, FopDetalization> entry : source.entrySet()) {
            String fopUid = entry.getKey();
            FopDetalization sourceFd = entry.getValue();
            FopDetalization targetFd = target.get(fopUid);
            if (targetFd == null) {
                targetFd = new FopDetalization();
                target.put(fopUid, targetFd);
            }
            List targetComponents = targetFd.getComponents();
            List sourceComponents = sourceFd.getComponents();
            StandardFopDetalizationHelper.mergeFopComponents(targetComponents, sourceComponents);
        }
        Iterator<Map.Entry<String, FopDetalization>> targetIt = target.entrySet().iterator();
        while (targetIt.hasNext()) {
            Map.Entry<String, FopDetalization> entry;
            entry = targetIt.next();
            if (source.get(entry.getKey()) != null) continue;
            targetIt.remove();
        }
    }

    private static BigDecimal calcPenalty(ContractRelationServiceDataDetalization detalization, BaseProduct bp) {
        BigDecimal result = MiscUtil.guarded((BigDecimal)detalization.getPenalty());
        return result;
    }

    private static BigDecimal calcDeduction(ContractRelationServiceDataDetalization detalization) {
        return MiscUtil.guarded((BigDecimal)detalization.getDeduction());
    }

    private static BigDecimal calcTaxes(ContractRelationServiceDataDetalization detalization, BaseProduct bp) {
        if (bp instanceof Product) {
            Product product = (Product)bp;
            return detalization.getTaxes().stream().filter(tax -> tax != null).map(SimpleTax::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return BigDecimal.ZERO;
    }

    private StandardFopDetalizationHelper() {
    }

    static {
        VALID_FOP_COMPONENT_TYPES.put(FopType.PRODUCT, Arrays.asList(FopComponentType.PRODUCT, FopComponentType.TAXES, FopComponentType.SERVICE, FopComponentType.PENALTY));
        VALID_FOP_COMPONENT_TYPES.put(FopType.SERVICE, Arrays.asList(FopComponentType.VENDOR_FEES, FopComponentType.OWN_FEES));
        VALID_FOP_COMPONENT_TYPES.put(FopType.PAYMENT, Arrays.asList(FopComponentType.VENDOR_FEES, FopComponentType.OWN_FEES));
        FEE_COMPONENT_TYPES = Arrays.asList(FopComponentType.VENDOR_FEES, FopComponentType.OWN_FEES);
    }
}

