/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.fopDetalization;

import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class VatComponentWrapper {
    private BigDecimal sum;
    private BigDecimal basis;
    private Double rate;
    private VatBasisType basisType;
    private boolean separated = false;
    private String code;
    private List<String> sources = new ArrayList<String>();

    public VatComponentWrapper() {
    }

    public VatComponentWrapper(VatComponent vatComponent) {
        this(vatComponent, VatComponentWrapper.getDefaultBasisType(vatComponent));
    }

    public VatComponentWrapper(VatComponent vatComponent, VatBasisType basisType) {
        this.sum = vatComponent.getSum();
        this.basis = vatComponent.getBasis();
        this.rate = vatComponent.getRate();
        this.basisType = basisType;
    }

    private static VatBasisType getDefaultBasisType(VatComponent vc) {
        if (vc.getBasisTypes().contains(VatBasisType.PENALTY)) {
            return VatBasisType.PENALTY;
        }
        if (vc.getBasisTypes().contains(VatBasisType.DEDUCTION)) {
            return VatBasisType.DEDUCTION;
        }
        if (vc.getBasisTypes().contains(VatBasisType.SERVICE)) {
            return VatBasisType.SERVICE;
        }
        return VatBasisType.FARE;
    }

    public BigDecimal getSum() {
        return this.sum;
    }

    public void setSum(BigDecimal sum) {
        this.sum = sum;
    }

    public BigDecimal getBasis() {
        return this.basis;
    }

    public void setBasis(BigDecimal basis) {
        this.basis = basis;
    }

    public Double getRate() {
        return this.rate;
    }

    public void setRate(Double rate) {
        this.rate = rate;
    }

    public VatBasisType getBasisType() {
        return this.basisType;
    }

    public void setBasisType(VatBasisType basisType) {
        this.basisType = basisType;
    }

    public boolean isSeparated() {
        return this.separated;
    }

    public void setSeparated(boolean separated) {
        this.separated = separated;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }
}

