/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.fopDetalization;

import com.gridnine.xtrip.common.model.booking.AdditionalService;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceData;
import com.gridnine.xtrip.common.model.booking.ContractRelationVatDetalization;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.StandardFopDetalizationHelper;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.VatComponentWrapper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VatComponentsCollector {
    private final ContractRelationServiceData clientServiceData;
    private boolean separateTaxes = false;
    private List<SimpleTax> specialTaxes = new ArrayList<SimpleTax>();
    private Map<AdditionalService, AdditionalServiceType> hotelAdditionalServices = Collections.emptyMap();
    private static List<VatBasisType> FARE_WITH_TAXES = Arrays.asList(VatBasisType.FARE, VatBasisType.TAXES);
    private static final String SEPARATOR = "-";
    private static DecimalFormat DF = new DecimalFormat("#.00");

    public VatComponentsCollector(ContractRelationServiceData clientServiceData) {
        this.clientServiceData = clientServiceData;
    }

    public VatComponentsCollector setSeparateTaxes(boolean value) {
        this.separateTaxes = value;
        return this;
    }

    public VatComponentsCollector addSpecialTaxes(List<SimpleTax> taxes) {
        this.specialTaxes.addAll(taxes);
        return this;
    }

    public VatComponentsCollector setAdditionalServices(Map<AdditionalService, AdditionalServiceType> hotelAdditionalServices) {
        this.hotelAdditionalServices = hotelAdditionalServices;
        return this;
    }

    public List<VatComponentWrapper> collect() throws Exception {
        ContractRelationVatDetalization vatDetalization = this.clientServiceData.getDetalization().getVat();
        List vatComponents = vatDetalization == null ? Collections.emptyList() : vatDetalization.getComponents();
        List<VatComponentWrapper> components = this.processVatComponents(vatComponents);
        if (components.isEmpty()) {
            return Collections.emptyList();
        }
        List<VatComponentWrapper> result = this.collectByRate(components);
        return result;
    }

    private List<VatComponentWrapper> processVatComponents(List<VatComponent> vatComponents) throws Exception {
        List components = XCloneHelper.cloneList(vatComponents);
        ArrayList<VatComponentWrapper> result = new ArrayList<VatComponentWrapper>();
        ArrayList<SimpleTax> unprocessedTaxes = new ArrayList<SimpleTax>(this.specialTaxes);
        HashMap<AdditionalService, AdditionalServiceType> unprocessedAdditionalServices = new HashMap<AdditionalService, AdditionalServiceType>(this.hotelAdditionalServices);
        for (VatComponent vc : components) {
            if (MiscUtil.isZero((BigDecimal)vc.getBasis(), (boolean)true)) continue;
            this.specialTaxes.stream().filter(tax -> vc.getTaxesUids().contains(tax.getUid())).forEach(tax -> {
                if (unprocessedTaxes.contains(tax)) {
                    result.add(this.extractSpecialTaxVatComponent(vc, (SimpleTax)tax));
                    unprocessedTaxes.remove(tax);
                }
            });
            if (MiscUtil.isZero((BigDecimal)vc.getBasis(), (boolean)true)) continue;
            if (vc.getBasisTypes().contains(VatBasisType.SERVICE)) {
                this.hotelAdditionalServices.forEach((addServ, addServType) -> {
                    if (MiscUtil.equals((Object)vc.getRate(), (Object)addServ.getVatRate()) && unprocessedAdditionalServices.containsKey(addServ)) {
                        result.add(this.extractHotelAddServiceVatComponent(vc, (AdditionalService)addServ, (AdditionalServiceType)addServType));
                        unprocessedAdditionalServices.remove(addServ);
                    }
                });
            }
            if (this.separateTaxes && vc.getBasisTypes().containsAll(FARE_WITH_TAXES)) {
                result.addAll(this.separateTaxes(vc));
                continue;
            }
            if (this.separateTaxes && vc.getBasisTypes().contains(VatBasisType.TAXES)) {
                result.add(new VatComponentWrapper(vc, VatBasisType.TAXES));
                continue;
            }
            result.add(new VatComponentWrapper(vc));
        }
        for (SimpleTax tax2 : unprocessedTaxes) {
            result.add(this.extractSpecialTaxVatComponent(null, tax2));
        }
        unprocessedAdditionalServices.forEach((addServ, addServType) -> result.add(this.extractHotelAddServiceVatComponent(null, (AdditionalService)addServ, (AdditionalServiceType)addServType)));
        return result;
    }

    private VatComponentWrapper extractSpecialTaxVatComponent(VatComponent vc, SimpleTax tax) {
        VatComponentWrapper result = new VatComponentWrapper();
        result.setSeparated(true);
        result.setCode(tax.getCode());
        result.setBasisType(VatBasisType.TAXES);
        result.setBasis(tax.getAmount());
        if (vc != null) {
            result.setRate(vc.getRate());
            boolean isLastPart = MiscUtil.equals((Object)vc.getBasis(), (Object)tax.getAmount());
            BigDecimal taxVat = isLastPart ? vc.getSum() : StandardFopDetalizationHelper.getVatAmount(tax.getAmount(), vc.getRate());
            result.setSum(taxVat);
            vc.setBasis(MiscUtil.sub((BigDecimal)vc.getBasis(), (BigDecimal[])new BigDecimal[]{tax.getAmount()}));
            vc.setSum(MiscUtil.sub((BigDecimal)vc.getSum(), (BigDecimal[])new BigDecimal[]{taxVat}));
        }
        return result;
    }

    private VatComponentWrapper extractHotelAddServiceVatComponent(VatComponent vc, AdditionalService addServ, AdditionalServiceType addServType) {
        VatComponentWrapper result = new VatComponentWrapper();
        result.setSeparated(true);
        result.setCode(addServType.name());
        result.getSources().add(addServ.getSource());
        result.setBasisType(VatBasisType.SERVICE);
        result.setBasis(addServ.getAmount());
        if (vc != null) {
            result.setRate(vc.getRate());
            BigDecimal vatAmount = addServ.getVatAmount();
            result.setSum(vatAmount);
            vc.setBasis(MiscUtil.sub((BigDecimal)vc.getBasis(), (BigDecimal[])new BigDecimal[]{addServ.getAmount()}));
            vc.setSum(MiscUtil.sub((BigDecimal)vc.getSum(), (BigDecimal[])new BigDecimal[]{vatAmount}));
        }
        return result;
    }

    private List<VatComponentWrapper> separateTaxes(VatComponent vc) {
        BigDecimal fare = MiscUtil.guarded((BigDecimal)this.clientServiceData.getDetalization().getFare());
        VatComponentWrapper fareVc = new VatComponentWrapper();
        fareVc.setBasisType(VatBasisType.FARE);
        fareVc.setRate(vc.getRate());
        fareVc.setBasis(fare);
        BigDecimal fareVatAmount = StandardFopDetalizationHelper.getVatAmount(fare, vc.getRate());
        fareVc.setSum(fareVatAmount);
        VatComponentWrapper taxesVc = new VatComponentWrapper();
        taxesVc.setBasisType(VatBasisType.TAXES);
        taxesVc.setRate(vc.getRate());
        taxesVc.setBasis(vc.getBasis().subtract(fare));
        taxesVc.setSum(vc.getSum().subtract(fareVatAmount));
        return Arrays.asList(fareVc, taxesVc);
    }

    private List<VatComponentWrapper> collectByRate(List<VatComponentWrapper> components) {
        ArrayList<VatComponentWrapper> result = new ArrayList<VatComponentWrapper>();
        HashMap<String, VatComponentWrapper> map = new HashMap<String, VatComponentWrapper>();
        for (VatComponentWrapper vatComponent : components) {
            String key = this.buildVatComponentKey(vatComponent);
            VatComponentWrapper rateVatComponent = (VatComponentWrapper)map.get(key);
            map.put(key, this.updateRateVatComponent(rateVatComponent, vatComponent));
        }
        result.addAll(map.values());
        return result;
    }

    private String buildVatComponentKey(VatComponentWrapper component) {
        StringBuilder sb = new StringBuilder();
        sb.append(component.getBasisType().name()).append(SEPARATOR);
        if (component.isSeparated()) {
            sb.append(component.getCode()).append(SEPARATOR);
        }
        sb.append(component.getRate() == null ? "NULL" : DF.format(component.getRate()));
        return sb.toString();
    }

    private VatComponentWrapper updateRateVatComponent(VatComponentWrapper rateVatComponent, VatComponentWrapper vatComponent) {
        if (rateVatComponent == null) {
            return vatComponent;
        }
        VatComponentWrapper result = rateVatComponent;
        result.setBasis(MiscUtil.sum((BigDecimal[])new BigDecimal[]{result.getBasis(), vatComponent.getBasis()}));
        result.setSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{result.getSum(), vatComponent.getSum()}));
        result.getSources().addAll(vatComponent.getSources());
        return result;
    }
}

