/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.fopDetalization;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.booking.AdditionalService;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceData;
import com.gridnine.xtrip.common.model.booking.ContractRelationVatDetalization;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.StandardFopDetalizationHelper;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.VatComponentBuilder;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.VatComponentWrapper;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.VatComponentWrapperBuilder;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.VatComponentsCollector;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class VatComponentsCollectorTest {
    private static BigDecimal fare = BigDecimal.valueOf(1000L);
    private static double fareRate = 10.0;
    private static BigDecimal fareVat = StandardFopDetalizationHelper.getVatAmount(fare, fareRate);

    @Test
    public void testFare() throws Exception {
        List<VatComponent> vatComponents = Arrays.asList(new VatComponentBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build());
        ContractRelationServiceData clientServiceData = this.buildContractRelationServiceData(vatComponents);
        List<VatComponentWrapper> componentsAct = new VatComponentsCollector(clientServiceData).collect();
        List<VatComponentWrapper> componentsExp = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build());
        this.assertVatComponents(componentsExp, componentsAct);
    }

    @Test
    public void testFareAndTaxes1() throws Exception {
        BigDecimal taxes = BigDecimal.valueOf(2000L);
        BigDecimal taxesVat = StandardFopDetalizationHelper.getVatAmount(taxes, fareRate);
        List<VatComponent> vatComponents = Arrays.asList(new VatComponentBuilder().addVatBasisType(VatBasisType.FARE).addVatBasisType(VatBasisType.TAXES).setBasis(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fare, taxes})).setSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fareVat, taxesVat})).setRate(fareRate).build());
        ContractRelationServiceData clientServiceData = this.buildContractRelationServiceData(vatComponents);
        List<VatComponentWrapper> componentsAct = new VatComponentsCollector(clientServiceData).collect();
        List<VatComponentWrapper> componentsExp = Arrays.asList(new VatComponentWrapperBuilder().setBasis(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fare, taxes})).setSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fareVat, taxesVat})).setRate(fareRate).build());
        this.assertVatComponents(componentsExp, componentsAct);
    }

    @Test
    public void testFareAndTaxes2() throws Exception {
        BigDecimal taxes = BigDecimal.valueOf(2000L);
        BigDecimal taxesVat = StandardFopDetalizationHelper.getVatAmount(taxes, fareRate);
        List<VatComponent> vatComponents = Arrays.asList(new VatComponentBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build(), new VatComponentBuilder().addVatBasisType(VatBasisType.TAXES).setBasis(taxes).setSum(taxesVat).setRate(fareRate).build());
        ContractRelationServiceData clientServiceData = this.buildContractRelationServiceData(vatComponents);
        List<VatComponentWrapper> componentsAct = new VatComponentsCollector(clientServiceData).collect();
        List<VatComponentWrapper> componentsExp = Arrays.asList(new VatComponentWrapperBuilder().setBasis(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fare, taxes})).setSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fareVat, taxesVat})).setRate(fareRate).build());
        this.assertVatComponents(componentsExp, componentsAct);
    }

    @Test
    public void testFareAndTaxes3() throws Exception {
        BigDecimal taxes = BigDecimal.valueOf(2000L);
        double taxesRate = 20.0;
        BigDecimal taxesVat = StandardFopDetalizationHelper.getVatAmount(taxes, taxesRate);
        List<VatComponent> vatComponents = Arrays.asList(new VatComponentBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build(), new VatComponentBuilder().addVatBasisType(VatBasisType.TAXES).setBasis(taxes).setSum(taxesVat).setRate(taxesRate).build());
        ContractRelationServiceData clientServiceData = this.buildContractRelationServiceData(vatComponents);
        List<VatComponentWrapper> componentsAct = new VatComponentsCollector(clientServiceData).collect();
        List<VatComponentWrapper> componentsExp = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build(), new VatComponentWrapperBuilder().setBasis(taxes).setSum(taxesVat).setRate(taxesRate).build());
        this.assertVatComponents(componentsExp, componentsAct);
    }

    @Test
    public void testSeparatedTaxes1() throws Exception {
        BigDecimal taxes = BigDecimal.valueOf(2000L);
        BigDecimal taxesVat = BigDecimal.valueOf(200L);
        List<VatComponent> vatComponents = Arrays.asList(new VatComponentBuilder().addVatBasisType(VatBasisType.FARE).addVatBasisType(VatBasisType.TAXES).setBasis(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fare, taxes})).setSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fareVat, taxesVat})).setRate(fareRate).build());
        ContractRelationServiceData clientServiceData = this.buildContractRelationServiceData(vatComponents);
        List<VatComponentWrapper> componentsAct = new VatComponentsCollector(clientServiceData).setSeparateTaxes(true).collect();
        List<VatComponentWrapper> componentsExp = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.TAXES).setBasis(taxes).setSum(taxesVat).setRate(fareRate).build());
        this.assertVatComponents(componentsExp, componentsAct);
    }

    @Test
    public void testSeparatedTaxes2() throws Exception {
        BigDecimal taxes = BigDecimal.valueOf(2000L);
        BigDecimal taxesVat = BigDecimal.valueOf(200L);
        List<VatComponent> vatComponents = Arrays.asList(new VatComponentBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build(), new VatComponentBuilder().addVatBasisType(VatBasisType.TAXES).setBasis(taxes).setSum(taxesVat).setRate(fareRate).build());
        ContractRelationServiceData clientServiceData = this.buildContractRelationServiceData(vatComponents);
        List<VatComponentWrapper> componentsAct = new VatComponentsCollector(clientServiceData).setSeparateTaxes(true).collect();
        List<VatComponentWrapper> componentsExp = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.TAXES).setBasis(taxes).setSum(taxesVat).setRate(fareRate).build());
        this.assertVatComponents(componentsExp, componentsAct);
    }

    @Test
    public void testFareAndService() throws Exception {
        BigDecimal service = BigDecimal.valueOf(2000L);
        BigDecimal serviceVat = StandardFopDetalizationHelper.getVatAmount(service, fareRate);
        List<VatComponent> vatComponents = Arrays.asList(new VatComponentBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build(), new VatComponentBuilder().addVatBasisType(VatBasisType.SERVICE).setBasis(service).setSum(serviceVat).setRate(fareRate).build());
        ContractRelationServiceData clientServiceData = this.buildContractRelationServiceData(vatComponents);
        List<VatComponentWrapper> componentsAct = new VatComponentsCollector(clientServiceData).collect();
        List<VatComponentWrapper> componentsExp = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.SERVICE).setBasis(service).setSum(serviceVat).setRate(fareRate).build());
        this.assertVatComponents(componentsExp, componentsAct);
    }

    @Test
    public void testSeparatedService1() throws Exception {
        BigDecimal service = BigDecimal.valueOf(2000L);
        BigDecimal serviceVat = StandardFopDetalizationHelper.getVatAmount(service, fareRate);
        BigDecimal sepService = BigDecimal.valueOf(800L);
        BigDecimal sepServiceVat = StandardFopDetalizationHelper.getVatAmount(sepService, fareRate);
        List<VatComponent> vatComponents = Arrays.asList(new VatComponentBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build(), new VatComponentBuilder().addVatBasisType(VatBasisType.SERVICE).setBasis(service).setSum(serviceVat).setRate(fareRate).build());
        HashMap<AdditionalService, AdditionalServiceType> additionalServiceMap = new HashMap<AdditionalService, AdditionalServiceType>();
        AdditionalService as = new AdditionalService();
        as.setAmount(sepService);
        as.setVatAmount(sepServiceVat);
        as.setVatRate(Double.valueOf(fareRate));
        additionalServiceMap.put(as, AdditionalServiceType.MEAL);
        ContractRelationServiceData clientServiceData = this.buildContractRelationServiceData(vatComponents);
        List<VatComponentWrapper> componentsAct = new VatComponentsCollector(clientServiceData).setAdditionalServices(additionalServiceMap).collect();
        List<VatComponentWrapper> componentsExp = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.SERVICE).setBasis(MiscUtil.sub((BigDecimal)service, (BigDecimal[])new BigDecimal[]{sepService})).setSum(MiscUtil.sub((BigDecimal)serviceVat, (BigDecimal[])new BigDecimal[]{sepServiceVat})).setRate(fareRate).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.SERVICE).setBasis(sepService).setSum(sepServiceVat).setRate(fareRate).setCode(AdditionalServiceType.MEAL.name()).setSeparated().build());
        this.assertVatComponents(componentsExp, componentsAct);
    }

    @Test
    public void testSeparatedService2() throws Exception {
        BigDecimal service = BigDecimal.valueOf(2000L);
        BigDecimal serviceVat = StandardFopDetalizationHelper.getVatAmount(service, fareRate);
        BigDecimal sepService1 = BigDecimal.valueOf(800L);
        BigDecimal sepServiceVat1 = StandardFopDetalizationHelper.getVatAmount(sepService1, fareRate);
        BigDecimal sepService2 = BigDecimal.valueOf(100L);
        BigDecimal sepServiceVat2 = StandardFopDetalizationHelper.getVatAmount(sepService2, fareRate);
        List<VatComponent> vatComponents = Arrays.asList(new VatComponentBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build(), new VatComponentBuilder().addVatBasisType(VatBasisType.SERVICE).setBasis(service).setSum(serviceVat).setRate(fareRate).build());
        HashMap<AdditionalService, AdditionalServiceType> additionalServiceMap = new HashMap<AdditionalService, AdditionalServiceType>();
        AdditionalService as = new AdditionalService();
        as.setAmount(sepService1);
        as.setVatAmount(sepServiceVat1);
        as.setVatRate(Double.valueOf(fareRate));
        additionalServiceMap.put(as, AdditionalServiceType.MEAL);
        as = new AdditionalService();
        as.setAmount(sepService2);
        as.setVatAmount(sepServiceVat2);
        as.setVatRate(Double.valueOf(fareRate));
        additionalServiceMap.put(as, AdditionalServiceType.MEAL);
        ContractRelationServiceData clientServiceData = this.buildContractRelationServiceData(vatComponents);
        List<VatComponentWrapper> componentsAct = new VatComponentsCollector(clientServiceData).setAdditionalServices(additionalServiceMap).collect();
        List<VatComponentWrapper> componentsExp = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.SERVICE).setBasis(MiscUtil.sub((BigDecimal)service, (BigDecimal[])new BigDecimal[]{sepService1, sepService2})).setSum(MiscUtil.sub((BigDecimal)serviceVat, (BigDecimal[])new BigDecimal[]{sepServiceVat1, sepServiceVat2})).setRate(fareRate).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.SERVICE).setBasis(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sepService1, sepService2})).setSum(MiscUtil.sum((BigDecimal[])new BigDecimal[]{sepServiceVat1, sepServiceVat2})).setRate(fareRate).setCode(AdditionalServiceType.MEAL.name()).setSeparated().build());
        this.assertVatComponents(componentsExp, componentsAct);
    }

    @Test
    public void testSpecialTaxes() throws Exception {
        BigDecimal tax1 = BigDecimal.valueOf(178L);
        BigDecimal tax2 = BigDecimal.valueOf(115L);
        double taxesRate = 20.0;
        BigDecimal taxesVat = BigDecimal.valueOf(48.83);
        ArrayList<SimpleTax> specialTaxes = new ArrayList<SimpleTax>();
        SimpleTax st = new SimpleTax();
        st.setAmount(tax1);
        st.setCode("RI");
        specialTaxes.add(st);
        st = new SimpleTax();
        st.setAmount(tax2);
        st.setCode("RI");
        specialTaxes.add(st);
        List<VatComponent> vatComponents = Arrays.asList(new VatComponentBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build(), new VatComponentBuilder().addVatBasisType(VatBasisType.TAXES).setBasis(MiscUtil.sum((BigDecimal[])new BigDecimal[]{tax1, tax2})).setSum(taxesVat).setRate(taxesRate).addTaxesUids(specialTaxes.stream().map(BaseIdentity::getUid).collect(Collectors.toList())).build());
        ContractRelationServiceData clientServiceData = this.buildContractRelationServiceData(vatComponents);
        List<VatComponentWrapper> componentsAct = new VatComponentsCollector(clientServiceData).addSpecialTaxes(specialTaxes).collect();
        List<VatComponentWrapper> componentsExp = Arrays.asList(new VatComponentWrapperBuilder().setBasis(fare).setSum(fareVat).setRate(fareRate).build(), new VatComponentWrapperBuilder().setVatBasisType(VatBasisType.TAXES).setBasis(MiscUtil.sum((BigDecimal[])new BigDecimal[]{tax1, tax2})).setSum(taxesVat).setRate(taxesRate).setCode("RI").setSeparated().build());
        this.assertVatComponents(componentsExp, componentsAct);
    }

    private ContractRelationServiceData buildContractRelationServiceData(Collection<VatComponent> vatComponents) {
        ContractRelationServiceData result = new ContractRelationServiceData();
        result.getDetalization().setFare(fare);
        result.getDetalization().setVat(new ContractRelationVatDetalization());
        result.getDetalization().getVat().getComponents().addAll(vatComponents);
        return result;
    }

    private void assertVatComponents(List<VatComponentWrapper> componentsExp, List<VatComponentWrapper> componentsAct) {
        Assert.assertEquals((long)componentsExp.size(), (long)componentsAct.size());
        componentsExp.sort(Comparator.comparing(VatComponentWrapper::getBasis));
        componentsAct.sort(Comparator.comparing(VatComponentWrapper::getBasis));
        for (int i = 0; i < componentsExp.size(); ++i) {
            VatComponentWrapper exp = componentsExp.get(i);
            VatComponentWrapper act = componentsAct.get(i);
            double delta = 1.0E-4;
            Assert.assertEquals((String)"basis", (double)exp.getBasis().doubleValue(), (double)act.getBasis().doubleValue(), (double)delta);
            Assert.assertEquals((String)"no vat", (Object)(exp.getSum() == null ? 1 : 0), (Object)(act.getSum() == null ? 1 : 0));
            Assert.assertEquals((String)"sum", (double)MiscUtil.guarded((BigDecimal)exp.getSum()).doubleValue(), (double)MiscUtil.guarded((BigDecimal)act.getSum()).doubleValue(), (double)delta);
            Assert.assertEquals((String)"not rate", (Object)(exp.getRate() == null ? 1 : 0), (Object)(act.getRate() == null ? 1 : 0));
            Assert.assertEquals((String)"rate", (double)MiscUtil.guarded((Double)exp.getRate()), (double)MiscUtil.guarded((Double)act.getRate()), (double)delta);
            Assert.assertEquals((String)"basisType", (Object)exp.getBasisType().name(), (Object)act.getBasisType().name());
            Assert.assertEquals((String)"code", (Object)exp.getCode(), (Object)act.getCode());
            Assert.assertEquals((String)"separated", (Object)exp.isSeparated(), (Object)act.isSeparated());
        }
    }
}

