/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.vat.air;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatCalculationSettings;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.GroovyShellHelper;
import com.gridnine.xtrip.server.model.helpers.vat.air.CommonAirProductVatHelper;
import com.gridnine.xtrip.server.model.helpers.vat.air.DPVatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.DefaultVatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.KZVatHelper;
import com.gridnine.xtrip.server.model.helpers.vat.air.N4VatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.RI20VatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.S7VatHelper;
import com.gridnine.xtrip.server.model.helpers.vat.air.SUVatHelper;
import com.gridnine.xtrip.server.model.helpers.vat.air.TchVatHelper;
import com.gridnine.xtrip.server.model.helpers.vat.air.U6VatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.UNVatHelper;
import com.gridnine.xtrip.server.model.helpers.vat.air.UTVatHelper;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AirProductVatCalculator {
    public static final String AIR_VAT_CALCULATION_SETTINGS_UID = "AIR_VAT_CALCULATION_SETTINGS";
    public static final String AIR_VAT_CALCULATION_SETTINGS_SYNCHRONIZATION_TASK_UID = "AIR_VAT_CALCULATION_SETTINGS_SYNCHRONIZATION_TASK";
    static final Logger log = LoggerFactory.getLogger(AirProductVatCalculator.class);
    static DictionaryReference<Airline> tchRef = new AirlineReference("\u04281");
    static final Date date_2015_03_11;
    static final Date date_2015_07_01;
    static final Date date_2015_11_01;
    static final Date date_2019_07_25;
    static final Date date_2020_07_01;
    public static final VatProductAdapter<Product, Tax, SegmentTariff, Segment> productAdapter;

    public static void updateVat(Product product) {
        if (AirProductHelper.isVatCalculated((Product)product) && product.getVendorVatDetalization() != null && GeneralProductHelper.isVendorVatDetalizationComplete((VatDetalization)product.getVendorVatDetalization())) {
            if (MiscUtil.equals((Object)AirProductVatCalculator.getTotalVat(product.getVendorVatDetalization().getComponents()), (Object)product.getTotalVendorEquivalentVatAmount())) {
                Iterator it = product.getValidationMessages().iterator();
                while (it.hasNext()) {
                    if (!StandartValidationMessageType.APVC_DIFFERENT_TOTAL_VAT.getErrorCode().equals(((ValidationMessage)it.next()).getErrorCode())) continue;
                    it.remove();
                    break;
                }
            }
            return;
        }
        MessageHelper.removeMessages((Collection)product.getValidationMessages(), (ValidationMessageCategory)ValidationMessageCategory.VAT_CALCULATION);
        if (product.getTicketType() == TicketType.FAKE) {
            return;
        }
        VatDetalization detalization = AirProductVatCalculator.calculateVendorVatDetalization(product, null, productAdapter);
        BigDecimal totalVat = AirProductVatCalculator.getTotalVat(detalization.getComponents());
        if (AirProductHelper.isVatCalculated((Product)product) && !MiscUtil.equals((Object)totalVat, (Object)product.getTotalVendorEquivalentVatAmount())) {
            product.getValidationMessages().add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.APVC_DIFFERENT_TOTAL_VAT, (Object[])new Object[]{product.getTotalVendorEquivalentVatAmount(), totalVat}));
        } else {
            product.setTotalVendorEquivalentVatAmount(totalVat);
        }
        product.setVendorVatCalculated(true);
        detalization.setDetalized(true);
        product.setVendorVatDetalization(detalization);
    }

    public static <P, T, ST, S> VatDetalization calculateVendorVatDetalization(P object, DictionaryReference<PassengerType> passengerType, VatProductAdapter<P, T, ST, S> adapter) {
        return AirProductVatCalculator.fillNoVatComponents(AirProductVatCalculator.calculateVat(object, passengerType, adapter), object, passengerType, adapter);
    }

    private static <P, T, ST, S> VatDetalization fillNoVatComponents(VatDetalization vatDetalization, P product, DictionaryReference<PassengerType> passengerType, VatProductAdapter<P, T, ST, S> adapter) {
        VatComponent comp;
        boolean addFareComponent = true;
        List<T> taxes = adapter.getTaxes(product, passengerType);
        Set taxesUids = taxes.stream().map(adapter::getUid).collect(Collectors.toSet());
        BigDecimal penalty = adapter.getPenalty(product);
        boolean addPenaltyComponent = penalty != null && BigDecimal.ZERO.compareTo(penalty) != 0;
        for (VatComponent item : vatDetalization.getComponents()) {
            if (item.getBasisTypes().contains(VatBasisType.FARE)) {
                addFareComponent = false;
            }
            if (item.getBasisTypes().contains(VatBasisType.PENALTY)) {
                addPenaltyComponent = false;
            }
            for (String taxUid : item.getTaxesUids()) {
                taxesUids.remove(taxUid);
            }
        }
        if (addFareComponent || !taxesUids.isEmpty()) {
            comp = new VatComponent();
            BigDecimal basis = BigDecimal.ZERO;
            if (addFareComponent) {
                basis = MiscUtil.sum((BigDecimal[])new BigDecimal[]{basis, adapter.getEquivalentFare(product, passengerType)});
                comp.getBasisTypes().add(VatBasisType.FARE);
            }
            if (!taxesUids.isEmpty()) {
                comp.getBasisTypes().add(VatBasisType.TAXES);
                for (String taxUid : taxesUids) {
                    comp.getTaxesUids().add(taxUid);
                    Object tax = null;
                    for (T t : taxes) {
                        if (!adapter.getUid(t).equals(taxUid)) continue;
                        tax = t;
                        break;
                    }
                    if (tax == null) continue;
                    basis = MiscUtil.sum((BigDecimal[])new BigDecimal[]{basis, adapter.getEquivalentAmount(tax)});
                }
            }
            comp.setBasis(basis);
            vatDetalization.getComponents().add(comp);
        }
        if (addPenaltyComponent) {
            comp = new VatComponent();
            comp.getBasisTypes().add(VatBasisType.PENALTY);
            ProductStatus status = adapter.getStatus(product);
            if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
                comp.setBasis(penalty.negate());
            } else {
                comp.setBasis(penalty);
            }
            vatDetalization.getComponents().add(comp);
        }
        return vatDetalization;
    }

    private static BigDecimal getTotalVat(List<VatComponent> components) {
        BigDecimal totalVat = null;
        for (VatComponent comp : components) {
            totalVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalVat, comp.getSum()});
        }
        return totalVat;
    }

    private static <P, T, ST, S> VatDetalization calculateVat(P product, DictionaryReference<PassengerType> passengerType, VatProductAdapter<P, T, ST, S> adapter) {
        VatDetalization result;
        Date issueDate = adapter.getIssueDate(product);
        if (issueDate == null && adapter.isAddValidationMessages()) {
            String productTitle = adapter.getTitle(product);
            log.warn(String.format("issue date is undefinded for product %s, VAT cannot be correctly calculated", productTitle));
            adapter.addValidationMessage(product, ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.APVC_NO_ISSUE_DATE));
        }
        if ((result = AirProductVatCalculator.invokeCustomVatCalculator(product, passengerType, adapter)) != null) {
            return result;
        }
        VatDetalization detalization = AirProductVatCalculator.calculateVatWithScript(product, passengerType, adapter);
        if (detalization == null) {
            detalization = AirProductVatCalculator.calculateVatWithOldLogic(product, passengerType, adapter);
        }
        return detalization;
    }

    private static <P, T, ST, S> VatDetalization calculateVatWithOldLogic(P product, DictionaryReference<PassengerType> passengerType, VatProductAdapter<P, T, ST, S> adapter) {
        Date issueDate = adapter.getIssueDate(product);
        DictionaryReference<Airline> validatingCarrier = adapter.getValidatingAirline(product);
        if (CommonAirProductVatHelper.isForeignAirline(validatingCarrier)) {
            if (AirProductVatCalculator.isTCHTicket(product, adapter)) {
                VatDetalization result = new VatDetalization();
                if (adapter.getMcoCategory(product) == MCOCategory.GROUP_PREPAYMENT) {
                    return result;
                }
                result.getComponents().addAll(CommonAirProductVatHelper.createZZVatComponents(product, passengerType, adapter));
                return result;
            }
            return new VatDetalization();
        }
        if (SystemHelper.isKazakhInstallation()) {
            return KZVatHelper.calculateVAT(product, passengerType, adapter);
        }
        String code = DictHelper.getCodeVariant(validatingCarrier, (CodeSystem[])new CodeSystem[]{CodeSystem.IATA});
        if (code == null) {
            String string = code = validatingCarrier == null ? null : validatingCarrier.getCode();
        }
        if (issueDate != null && issueDate.after(date_2020_07_01) && "N4".equals(code)) {
            return N4VatCalculator.calculateVAT(product, passengerType, adapter);
        }
        if (issueDate != null && !issueDate.before(date_2019_07_25) && ("N4".equals(code) || "\u041a\u041b".equals(code))) {
            return RI20VatCalculator.calculateVAT(product, passengerType, adapter);
        }
        if (code != null && ("SU".equals(code) || validatingCarrier != null && validatingCarrier.getCode().contains("555"))) {
            return SUVatHelper.calculateVAT(product, passengerType, adapter);
        }
        if (AirProductVatCalculator.isTCHTicket(product, adapter)) {
            return TchVatHelper.createTCHVAT(product, passengerType, adapter);
        }
        if ("UN".equals(code)) {
            return UNVatHelper.calculateUNVAT(product, passengerType, adapter);
        }
        if ("UT".equals(code)) {
            return UTVatHelper.calculateUTVAT(product, passengerType, adapter);
        }
        if (KZVatHelper.matches(product, adapter)) {
            return KZVatHelper.calculateVAT(product, passengerType, adapter);
        }
        if ("S7".equals(code)) {
            return S7VatHelper.calculateS7VAT(product, passengerType, adapter);
        }
        if ("U6".equals(code)) {
            return U6VatCalculator.calculateVAT(product, passengerType, adapter);
        }
        if ("DP".equals(code) || "\u0414\u0420".equals(code)) {
            return DPVatCalculator.calculateVAT(product, passengerType, adapter);
        }
        return DefaultVatCalculator.calculateVAT(product, passengerType, adapter);
    }

    private static <P, T, ST, S> VatDetalization calculateVatWithScript(P product, DictionaryReference<PassengerType> passengerType, VatProductAdapter<P, T, ST, S> adapter) {
        EntityContainer settingsCtr = EntityStorage.get().load(VatCalculationSettings.class, AIR_VAT_CALCULATION_SETTINGS_UID);
        if (settingsCtr != null && ((VatCalculationSettings)settingsCtr.getEntity()).isActive()) {
            VatDetalization detalization = new VatDetalization();
            Binding binding = new Binding();
            binding.setProperty("detalizationProperty", (Object)detalization);
            binding.setProperty("productProperty", product);
            binding.setProperty("passengerTypeProperty", passengerType);
            binding.setProperty("adapterProperty", adapter);
            GroovyShell shell = new GroovyShell(binding);
            try {
                GroovyShellHelper.wrapShellIntoCacheDecorator(shell).evaluate(((VatCalculationSettings)settingsCtr.getEntity()).getScript(), true);
                return detalization;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(AirProductVatCalculator.class).error("unable to calculate VAT", (Throwable)e);
                adapter.addValidationMessage(product, ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.UNABLE_TO_CALCULATE_VAT, (Throwable)e, (Object[])new Object[0]));
                return null;
            }
        }
        return null;
    }

    private static <P, T, ST, S> boolean isTCHTicket(P product, VatProductAdapter<P, T, ST, S> adapter) {
        String blankOwnerNumber = adapter.getBlankOwnerNumber(product);
        return ProfileHelper.isOrganizationCode(adapter.getBlankOwner(product), (String)"\u04281") || "99A".equals(blankOwnerNumber) || "99\u0410".equals(blankOwnerNumber);
    }

    public static <P, T, ST, S> VatDetalization invokeCustomVatCalculator(P product, DictionaryReference<PassengerType> passengerType, VatProductAdapter<P, T, ST, S> adapter) {
        if (!Environment.isPublished(VatCalculator.class)) {
            return null;
        }
        return ((VatCalculator)Environment.getPublished(VatCalculator.class)).calculateVat(product, passengerType, adapter);
    }

    private AirProductVatCalculator() {
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2015);
        cal.set(2, 2);
        cal.set(5, 11);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date_2015_03_11 = cal.getTime();
        cal = Calendar.getInstance();
        cal.set(1, 2015);
        cal.set(2, 6);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date_2015_07_01 = cal.getTime();
        cal = Calendar.getInstance();
        cal.set(1, 2015);
        cal.set(2, 10);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date_2015_11_01 = cal.getTime();
        cal = Calendar.getInstance();
        cal.set(1, 2019);
        cal.set(2, 6);
        cal.set(5, 25);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date_2019_07_25 = cal.getTime();
        cal = Calendar.getInstance();
        cal.set(1, 2020);
        cal.set(2, 6);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date_2020_07_01 = cal.getTime();
        productAdapter = new VatProductAdapter<Product, Tax, SegmentTariff, Segment>(){

            @Override
            public List<Tax> getTaxes(Product product, DictionaryReference<PassengerType> passengerType) {
                return product.getTaxes();
            }

            @Override
            public String getUid(Tax tax) {
                return tax.getUid();
            }

            @Override
            public BigDecimal getPenalty(Product product) {
                return product.getPenalty();
            }

            @Override
            public BigDecimal getEquivalentAmount(Tax tax) {
                return tax.getEquivalentAmount();
            }

            @Override
            public ProductStatus getStatus(Product product) {
                return product.getStatus();
            }

            @Override
            public BigDecimal getEquivalentFare(Product product, DictionaryReference<PassengerType> passengerType) {
                return AirProductHelper.getEquivalentFare((Product)product);
            }

            @Override
            public Date getIssueDate(Product product) {
                return product.getIssueDate();
            }

            @Override
            public boolean isAddValidationMessages() {
                return true;
            }

            @Override
            public String getTitle(Product product) {
                return AirProductHelper.getProductTitle((Product)product);
            }

            @Override
            public void addValidationMessage(Product product, ValidationMessage validationMessage) {
                product.getValidationMessages().add(validationMessage);
            }

            @Override
            public DictionaryReference<Airline> getValidatingAirline(Product product) {
                return product.getCarrier();
            }

            @Override
            public MCOCategory getMcoCategory(Product product) {
                return product.getMcoCategory();
            }

            @Override
            public ProductCategory getProductCategory(Product product) {
                return product.getProductCategory();
            }

            @Override
            public String getTaxCode(Tax tax) {
                return tax.getCode();
            }

            @Override
            public Date getVatIssueDate(Product prod) {
                Date date = prod.getIssueDate();
                if (prod.getStatus() == ProductStatus.EXCHANGE || prod.getStatus() == ProductStatus.REFUND && prod.getPreviousProduct() != null) {
                    date = prod.getPreviousProduct().getIssueDate();
                }
                return date;
            }

            @Override
            public List<SegmentTariff> getSegmentTariffs(Product product) {
                return product.getSegmentTariffs();
            }

            @Override
            public List<Segment> getSegments(SegmentTariff segmentTariff) {
                return segmentTariff.getSegments();
            }

            @Override
            public DictionaryReference<GeoLocation> getDepartureLocation(Segment seg) {
                return seg.getDepartureLocation();
            }

            @Override
            public DictionaryReference<GeoLocation> getArrivalLocation(Segment seg) {
                return seg.getArriveLocation();
            }

            @Override
            public EntityReference<Organization> getSupplier(Product product) {
                return AirProductHelper.getSupplier((Product)product);
            }

            @Override
            public String getBlankOwnerNumber(Product product) {
                return product.getBlankOwnerNumber();
            }

            @Override
            public EntityReference<Organization> getBlankOwner(Product product) {
                return product.getBlankOwnerRef();
            }

            @Override
            public Product getTransportationTypeProduct(Product product) {
                Product relProd;
                if (!(product.getMcoCategory() != MCOCategory.ADDITIONAL_SERVICES && product.getMcoCategory() != MCOCategory.SPECIAL_FOOD && product.getMcoCategory() != MCOCategory.EXCESS_LUGGAGE || product.getRelatedProducts().isEmpty() || (relProd = (Product)product.getRelatedProducts().get(0)).getTicketType() == TicketType.FAKE)) {
                    return relProd;
                }
                return product;
            }

            @Override
            public DictionaryReference<Airline> getMarketingAirline(Segment seg) {
                return seg.getAirline();
            }

            @Override
            public String getGdsCurrency(Product prod) {
                return prod.getGdsCurrency();
            }

            @Override
            public EntityReference<? extends BaseEntity> getGdsAccount(Product product) {
                return Environment.isPublished(VatCalculator.class) ? ((VatCalculator)Environment.getPublished(VatCalculator.class)).getGdsAccount(product) : null;
            }
        };
    }

    public static interface VatCalculator {
        public <P, T, ST, S> VatDetalization calculateVat(P var1, DictionaryReference<PassengerType> var2, VatProductAdapter<P, T, ST, S> var3);

        public <P extends Product> EntityReference<? extends BaseEntity> getGdsAccount(P var1);

        public <P extends Product> boolean suppressEndorsement(EntityReference<? extends BaseEntity> var1);
    }

    public static interface VatProductAdapter<P, T, ST, S> {
        public List<T> getTaxes(P var1, DictionaryReference<PassengerType> var2);

        public String getUid(T var1);

        public BigDecimal getPenalty(P var1);

        public BigDecimal getEquivalentAmount(T var1);

        public ProductStatus getStatus(P var1);

        public BigDecimal getEquivalentFare(P var1, DictionaryReference<PassengerType> var2);

        public Date getIssueDate(P var1);

        public boolean isAddValidationMessages();

        public String getTitle(P var1);

        public void addValidationMessage(P var1, ValidationMessage var2);

        public DictionaryReference<Airline> getValidatingAirline(P var1);

        public MCOCategory getMcoCategory(P var1);

        public ProductCategory getProductCategory(P var1);

        public String getTaxCode(T var1);

        public Date getVatIssueDate(P var1);

        public List<ST> getSegmentTariffs(P var1);

        public List<S> getSegments(ST var1);

        public DictionaryReference<GeoLocation> getDepartureLocation(S var1);

        public DictionaryReference<GeoLocation> getArrivalLocation(S var1);

        public EntityReference<Organization> getSupplier(P var1);

        public String getBlankOwnerNumber(P var1);

        public EntityReference<Organization> getBlankOwner(P var1);

        public P getTransportationTypeProduct(P var1);

        public DictionaryReference<Airline> getMarketingAirline(S var1);

        public String getGdsCurrency(P var1);

        default public EntityReference<? extends BaseEntity> getGdsAccount(P product) {
            return null;
        }
    }
}

