/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.vat.air;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.VatTransportationType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public final class CommonAirProductVatHelper {
    static TaxesVatCalculationParams zzVatParams = new TaxesVatCalculationParams(Collections.singleton("ZZ"), false);
    static TaxesVatCalculationParams riAndYQVatParams = new TaxesVatCalculationParams(Arrays.asList("RI", "YQ"), false);
    private static final Date date_2018_07_01;
    private static final Date date_2018_10_01;
    private static final Date date_2025_01_01;
    private static final Date date_2019_10_01;

    static <P, T, ST, S> List<VatComponent> createZZVatComponents(P prod, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        return CommonAirProductVatHelper.createComponents(prod, CommonAirProductVatHelper.getStandardVATRate(prod, adapter), false, zzVatParams, false, passengerType, adapter);
    }

    static <P, T, ST, S> List<VatComponent> createRIAndYQVatComponents(P prod, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        return CommonAirProductVatHelper.createComponents(prod, CommonAirProductVatHelper.getStandardVATRate(prod, adapter), false, riAndYQVatParams, true, true, passengerType, adapter);
    }

    static boolean isForeignAirline(DictionaryReference<Airline> validatingCarrier) {
        Country country;
        Airline validatingAirline = (Airline)DictionaryCache.get().resolveReference(validatingCarrier);
        return validatingAirline != null && (country = (Country)DictionaryCache.get().resolveReference(validatingAirline.getCountry())) != null && !country.isDomestic();
    }

    static <P, T, ST, S> boolean isHasVat(P product, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        VatTransportationType transportationType = CommonAirProductVatHelper.getTransportationType(adapter.getTransportationTypeProduct(product), adapter);
        return transportationType == VatTransportationType.VVL;
    }

    static <P, T, ST, S> List<VatComponent> createComponents(P prod, double rate, boolean includeFare, TaxesVatCalculationParams taxesParams, boolean separateComponents, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        return CommonAirProductVatHelper.createComponents(prod, rate, includeFare, taxesParams, separateComponents, false, passengerType, adapter);
    }

    static <P, T, ST, S> List<VatComponent> createComponents(P prod, double rate, boolean includeFare, TaxesVatCalculationParams taxesParams, boolean separateComponents, boolean groupTaxesWithSameCodes, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        Object comp;
        HashSet taxesUids;
        ArrayList<VatComponent> result = new ArrayList<VatComponent>();
        BigDecimal totalBasis = BigDecimal.ZERO;
        HashSet hashSet = taxesUids = separateComponents ? null : new HashSet();
        if (includeFare) {
            BigDecimal fare = MiscUtil.guarded((BigDecimal)adapter.getEquivalentFare(prod, passengerType));
            if (separateComponents) {
                comp = new VatComponent();
                comp.setBasis(fare);
                comp.setRate(Double.valueOf(rate));
                comp.setSum(CommonAirProductVatHelper.calculateVatAmount(fare, rate));
                comp.getBasisTypes().add(VatBasisType.FARE);
                result.add((VatComponent)comp);
            } else {
                totalBasis = totalBasis.add(fare);
            }
        }
        LinkedHashMap taxesMap = new LinkedHashMap();
        for (Object tax : adapter.getTaxes(prod, passengerType)) {
            String taxCode = adapter.getTaxCode(tax);
            if (taxesParams.excludeTaxeCodes && taxCode != null && taxesParams.taxCodes.contains(taxCode) || !taxesParams.excludeTaxeCodes && (taxCode == null || !taxesParams.taxCodes.contains(taxCode))) continue;
            String key = groupTaxesWithSameCodes && taxCode != null ? taxCode : adapter.getUid(tax);
            List taxes = (List)taxesMap.get(key);
            if (taxes == null) {
                taxes = new ArrayList();
                taxesMap.put(key, taxes);
            }
            taxes.add(tax);
        }
        for (List taxes : taxesMap.values()) {
            BigDecimal basis = BigDecimal.ZERO;
            HashSet<String> taxesUids2 = new HashSet<String>();
            for (Object tax : taxes) {
                basis = MiscUtil.sum((BigDecimal[])new BigDecimal[]{basis, adapter.getEquivalentAmount(tax)});
                taxesUids2.add(adapter.getUid(tax));
            }
            if (separateComponents) {
                VatComponent comp2 = new VatComponent();
                comp2.setBasis(basis);
                comp2.setRate(Double.valueOf(rate));
                comp2.setSum(CommonAirProductVatHelper.calculateVatAmount(basis, rate));
                comp2.getBasisTypes().add(VatBasisType.TAXES);
                comp2.getTaxesUids().addAll(taxesUids2);
                result.add(comp2);
                continue;
            }
            totalBasis = totalBasis.add(basis);
            taxesUids.addAll(taxesUids2);
        }
        if (!(separateComponents || taxesUids.isEmpty() && !includeFare)) {
            comp = new VatComponent();
            comp.setBasis(totalBasis);
            comp.setRate(Double.valueOf(rate));
            comp.setSum(CommonAirProductVatHelper.calculateVatAmount(totalBasis, rate));
            if (includeFare) {
                comp.getBasisTypes().add(VatBasisType.FARE);
            }
            if (!taxesUids.isEmpty()) {
                comp.getBasisTypes().add(VatBasisType.TAXES);
                comp.getTaxesUids().addAll(taxesUids);
            }
            result.add((VatComponent)comp);
        }
        return result;
    }

    public static BigDecimal calculateVatAmount(BigDecimal total, double rate) {
        return total.multiply(BigDecimal.valueOf(rate)).divide(BigDecimal.valueOf(100L).add(BigDecimal.valueOf(rate)), 2, RoundingMode.HALF_UP);
    }

    static <P, T, ST, S> double getReducedVATRate(P prod, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        double defaultVat;
        BigDecimal vat = DictHelper.getDefaultVat();
        double d = defaultVat = vat != null ? vat.doubleValue() : 18.0;
        if (SystemHelper.isRussianInstallation()) {
            Date date = adapter.getVatIssueDate(prod);
            if (date != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                int year = cal.get(1);
                int month = cal.get(2);
                if (year > 2015 || year == 2015 && month >= 6) {
                    return 10.0;
                }
            }
            return 10.0;
        }
        return defaultVat;
    }

    static <P, T, ST, S> double getStandardVATRate(P prod, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        double defaultVat;
        Date vatIssueDate = adapter.getVatIssueDate(prod);
        BigDecimal vat = DictHelper.getDefaultVat((Date)vatIssueDate);
        double d = defaultVat = vat != null ? vat.doubleValue() : 18.0;
        if (SystemHelper.isRussianInstallation()) {
            Date date = vatIssueDate;
            if (date != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                int year = cal.get(1);
                int month = cal.get(2);
                if (year >= 2019) {
                    return 20.0;
                }
            }
            return defaultVat;
        }
        return defaultVat;
    }

    private CommonAirProductVatHelper() {
    }

    static <P, T, ST, S> VatTransportationType getTransportationType(P prod, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        Date issueDate = adapter.getIssueDate(prod);
        boolean after20180101 = issueDate != null && issueDate.after(date_2018_07_01);
        boolean after20181001 = issueDate != null && issueDate.after(date_2018_10_01);
        boolean before20250101 = issueDate != null && issueDate.before(date_2025_01_01);
        boolean after20191001 = issueDate != null && !issueDate.before(date_2019_10_01);
        boolean hasDomestic = false;
        boolean hasInternational = false;
        boolean hasZeroVVL = false;
        boolean hasZVL = false;
        boolean hasMoscow = false;
        for (ST st : adapter.getSegmentTariffs(prod)) {
            for (S seg : adapter.getSegments(st)) {
                DictionaryReference<GeoLocation> arriveLocation = adapter.getArrivalLocation(seg);
                DictionaryReference<GeoLocation> departureLocation = adapter.getDepartureLocation(seg);
                String arrive = arriveLocation != null ? arriveLocation.getCode() : null;
                String depart = departureLocation != null ? departureLocation.getCode() : null;
                Country arriveCountry = DictHelper.findCountry((String)arrive);
                Country departCountry = DictHelper.findCountry((String)depart);
                if (arriveCountry == null || departCountry == null) continue;
                boolean departureIsDomestic = departCountry.isDomestic();
                boolean departureIsZeroVVL = before20250101 && AirProductHelper.isCrimea(departureLocation) || before20250101 && after20180101 && AirProductHelper.isKaliningrad(departureLocation) || before20250101 && after20181001 && AirProductHelper.isDVFO(departureLocation);
                boolean departureIsMoscow = AirProductHelper.isMoscow(departureLocation);
                boolean arrivalIsDomestic = arriveCountry.isDomestic();
                boolean arrivalIsZeroVVL = before20250101 && AirProductHelper.isCrimea(arriveLocation) || before20250101 && after20180101 && AirProductHelper.isKaliningrad(arriveLocation) || before20250101 && after20181001 && AirProductHelper.isDVFO(arriveLocation);
                boolean arrivalIsMoscow = AirProductHelper.isMoscow(arriveLocation);
                if (!departureIsDomestic && !arrivalIsDomestic) {
                    hasZVL = true;
                } else if (!departureIsDomestic || !arrivalIsDomestic) {
                    hasInternational = true;
                } else if (departureIsZeroVVL || arrivalIsZeroVVL) {
                    hasZeroVVL = true;
                } else {
                    hasDomestic = true;
                }
                if (!arrivalIsMoscow && !departureIsMoscow) continue;
                hasMoscow = true;
            }
        }
        if (!(hasZVL || hasDomestic || hasInternational || hasZeroVVL || hasZVL || hasMoscow)) {
            return VatTransportationType.UNDEFINED;
        }
        if (hasZVL && !hasDomestic && !hasInternational && !hasZeroVVL) {
            return VatTransportationType.ZVL;
        }
        if (hasInternational) {
            return VatTransportationType.MVL;
        }
        if (hasZeroVVL) {
            return VatTransportationType.ZERO_VVL;
        }
        if (after20191001 && !hasMoscow) {
            return VatTransportationType.ZERO_VVL;
        }
        return VatTransportationType.VVL;
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2018);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date_2018_07_01 = cal.getTime();
        cal.set(1, 2018);
        cal.set(2, 9);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date_2018_10_01 = cal.getTime();
        cal.set(1, 2025);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date_2025_01_01 = cal.getTime();
        cal.set(1, 2019);
        cal.set(2, 9);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date_2019_10_01 = cal.getTime();
    }

    static class TaxesVatCalculationParams {
        final Collection<String> taxCodes;
        final boolean excludeTaxeCodes;

        TaxesVatCalculationParams(Collection<String> taxCodes, boolean excludeTaxeCodes) {
            this.taxCodes = taxCodes;
            this.excludeTaxeCodes = excludeTaxeCodes;
        }
    }
}

