/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.vat.air;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.CommonAirProductVatHelper;
import java.util.Arrays;
import java.util.Collections;

final class DPVatCalculator {
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams yrTaxVatCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.singletonList("YR"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams taxesVatCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("YQ", "SA", "PS", "RU"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams taxesB110CalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("B110", "B", "B10", "B20"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams taxesSMSCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("SMSC", "SMSD", "SMSF", "SMSP"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams taxesExceptZZCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("ZZ", "CP"), true);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams restTaxesVatCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("YQ", "YR", "SA", "PS", "RU", "ZZ", "B110", "B", "B10", "B20", "CP", "SMSC", "SMSD", "SMSF", "SMSP"), true);

    static <P, T, ST, S> VatDetalization calculateVAT(P product, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        VatDetalization result = new VatDetalization();
        result.getComponents().addAll(CommonAirProductVatHelper.createZZVatComponents(product, passengerType, adapter));
        ProductCategory productCategory = adapter.getProductCategory(product);
        if (productCategory != ProductCategory.AIR && productCategory != ProductCategory.EXCESS_BAGAGE && adapter.getMcoCategory(product) != MCOCategory.EXCESS_LUGGAGE) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, taxesExceptZZCalculationParams, false, passengerType, adapter));
            return result;
        }
        if (CommonAirProductVatHelper.isHasVat(product, adapter)) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, taxesVatCalculationParams, true, passengerType, adapter));
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getStandardVATRate(product, adapter), false, yrTaxVatCalculationParams, false, passengerType, adapter));
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), false, taxesB110CalculationParams, true, passengerType, adapter));
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getStandardVATRate(product, adapter), false, taxesSMSCalculationParams, true, passengerType, adapter));
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, false, restTaxesVatCalculationParams, false, passengerType, adapter));
            return result;
        }
        result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, taxesExceptZZCalculationParams, false, passengerType, adapter));
        return result;
    }

    private DPVatCalculator() {
    }
}

