/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.vat.air;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.CommonAirProductVatHelper;
import java.util.Arrays;
import java.util.List;

final class DefaultVatCalculator {
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams taxesVatCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("YQ", "YR", "SA", "PS", "RU"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams taxesWithRIVatCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("YQ", "YR", "SA", "PS", "RU", "RI"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams taxesExceptZZCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("ZZ", "CP"), true);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams restTaxesVatCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("YQ", "YR", "SA", "PS", "RU", "ZZ", "CP"), true);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams restTaxesWithoutRIVatCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("YQ", "YR", "SA", "PS", "RU", "ZZ", "RI", "CP"), true);
    static final List<String> noRICarriers = Arrays.asList("SU", "DP", "UT");

    static <P, T, ST, S> VatDetalization calculateVAT(P product, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        boolean calculateRItax;
        VatDetalization result = new VatDetalization();
        MCOCategory mcoCategory = adapter.getMcoCategory(product);
        if (mcoCategory == MCOCategory.GROUP_PREPAYMENT) {
            return result;
        }
        result.getComponents().addAll(CommonAirProductVatHelper.createZZVatComponents(product, passengerType, adapter));
        ProductCategory productCategory = adapter.getProductCategory(product);
        if (productCategory != ProductCategory.AIR && productCategory != ProductCategory.EXCESS_BAGAGE && adapter.getMcoCategory(product) != MCOCategory.EXCESS_LUGGAGE) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, taxesExceptZZCalculationParams, false, passengerType, adapter));
            return result;
        }
        DictionaryReference<Airline> validatingAirline = adapter.getValidatingAirline(product);
        String code = DictHelper.getCodeVariant(validatingAirline, (CodeSystem[])new CodeSystem[]{CodeSystem.IATA});
        if (code == null) {
            code = validatingAirline == null ? null : validatingAirline.getCode();
        }
        boolean bl = calculateRItax = code == null || !noRICarriers.contains(code);
        if (CommonAirProductVatHelper.isHasVat(product, adapter)) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, calculateRItax ? taxesWithRIVatCalculationParams : taxesVatCalculationParams, true, passengerType, adapter));
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, false, calculateRItax ? restTaxesWithoutRIVatCalculationParams : restTaxesVatCalculationParams, false, passengerType, adapter));
            return result;
        }
        result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, taxesExceptZZCalculationParams, false, passengerType, adapter));
        return result;
    }

    private DefaultVatCalculator() {
    }
}

