/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.vat.air;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.CommonAirProductVatHelper;
import java.util.Collections;
import java.util.Date;

final class KZVatHelper {
    private static String KZ_COUNTRY_CODE = "KZ";
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams taxComponent = new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.emptyList(), true);

    private KZVatHelper() {
    }

    static <P, T, ST, S> boolean matches(P product, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        boolean isKZcarrier;
        Airline carrier = (Airline)DictionaryCache.get().resolveReference(adapter.getValidatingAirline(product));
        boolean bl = isKZcarrier = carrier != null && carrier.getCountry() != null && KZ_COUNTRY_CODE.equals(carrier.getCountry().getCode());
        if (!isKZcarrier) {
            return false;
        }
        EntityReference<Organization> supplierRef = adapter.getSupplier(product);
        EntityContainer supplierCtr = EntityStorage.get().resolve(supplierRef);
        if (supplierCtr == null) {
            return false;
        }
        DictionaryReference countryRef = ProfileHelper.getOrganizationCountry((Organization)((Organization)supplierCtr.getEntity()), (Date)adapter.getIssueDate(product));
        return countryRef != null && KZ_COUNTRY_CODE.equals(countryRef.getCode());
    }

    static <P, T, ST, S> VatDetalization calculateVAT(P product, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        VatDetalization result = new VatDetalization();
        MCOCategory mcoCategory = adapter.getMcoCategory(product);
        if (mcoCategory == MCOCategory.GROUP_PREPAYMENT) {
            return result;
        }
        if (KZVatHelper.isInternal(product, KZ_COUNTRY_CODE, adapter)) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 12.0, true, taxComponent, false, passengerType, adapter));
        } else {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, taxComponent, false, passengerType, adapter));
        }
        return result;
    }

    public static <P, T, ST, S> boolean isInternal(P product, String countryCode, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        if (TextUtil.isBlank((String)countryCode)) {
            return false;
        }
        for (ST st : adapter.getSegmentTariffs(product)) {
            for (S seg : adapter.getSegments(st)) {
                if (AirProductHelper.isLocationInCountry(adapter.getDepartureLocation(seg), (String)countryCode) && AirProductHelper.isLocationInCountry(adapter.getArrivalLocation(seg), (String)countryCode)) continue;
                return false;
            }
        }
        return true;
    }
}

