/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.vat.air;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.CommonAirProductVatHelper;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class N4VatCalculator {
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams otherTaxesCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("ZZ", "RI", "YQ", "YR", "TR", "M6", "CU", "Q5"), true);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams yrTaxCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("YR"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams yqTaxCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("YQ"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams riTaxCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("RI"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams trTaxCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("TR"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams m6TaxCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("M6"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams cuTaxCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("CU"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams q5TaxCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("Q5"), false);
    private static final Date date_2020_10_01;

    static <P, T, ST, S> VatDetalization calculateVAT(P product, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        VatDetalization result = new VatDetalization();
        result.getComponents().addAll(CommonAirProductVatHelper.createZZVatComponents(product, passengerType, adapter));
        Date issueDate = adapter.getIssueDate(product);
        if (issueDate == null || issueDate.before(date_2020_10_01)) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getStandardVATRate(product, adapter), false, yqTaxCalculationParams, true, true, passengerType, adapter));
        }
        result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getStandardVATRate(product, adapter), false, otherTaxesCalculationParams, true, true, passengerType, adapter));
        if (!CommonAirProductVatHelper.isHasVat(product, adapter)) {
            if (issueDate != null && !issueDate.before(date_2020_10_01)) {
                result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, false, yqTaxCalculationParams, true, true, passengerType, adapter));
            }
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, false, riTaxCalculationParams, true, true, passengerType, adapter));
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, false, trTaxCalculationParams, true, true, passengerType, adapter));
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, false, m6TaxCalculationParams, true, true, passengerType, adapter));
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, false, cuTaxCalculationParams, true, true, passengerType, adapter));
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, false, q5TaxCalculationParams, true, true, passengerType, adapter));
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, yrTaxCalculationParams, true, true, passengerType, adapter));
            return result;
        }
        if (issueDate != null && !issueDate.before(date_2020_10_01)) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), false, yqTaxCalculationParams, true, true, passengerType, adapter));
        }
        result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), false, riTaxCalculationParams, true, true, passengerType, adapter));
        result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), false, trTaxCalculationParams, true, true, passengerType, adapter));
        result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), false, m6TaxCalculationParams, true, true, passengerType, adapter));
        result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), false, cuTaxCalculationParams, true, true, passengerType, adapter));
        result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), false, q5TaxCalculationParams, true, true, passengerType, adapter));
        result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, yrTaxCalculationParams, true, true, passengerType, adapter));
        return result;
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2020);
        cal.set(2, 9);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date_2020_10_01 = cal.getTime();
    }
}

