/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.helpers.vat.air;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.gridnine.xtrip.server.model.helpers.vat.air.CommonAirProductVatHelper;
import java.util.Arrays;
import java.util.Collections;

public class RI20VatCalculator {
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams taxesExceptZZandRIandYQCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("ZZ", "RI", "YQ"), true);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams taxesVatCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("YR", "SA", "PS", "RU"), false);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams restTaxesVatCalculationParams = new CommonAirProductVatHelper.TaxesVatCalculationParams(Arrays.asList("YR", "SA", "PS", "RU", "ZZ", "RI", "YQ", "CP"), true);
    private static final CommonAirProductVatHelper.TaxesVatCalculationParams noTaxesComp = new CommonAirProductVatHelper.TaxesVatCalculationParams(Collections.emptyList(), false);

    static <P, T, ST, S> VatDetalization calculateVAT(P product, DictionaryReference<PassengerType> passengerType, AirProductVatCalculator.VatProductAdapter<P, T, ST, S> adapter) {
        VatDetalization result = new VatDetalization();
        MCOCategory mcoCategory = adapter.getMcoCategory(product);
        if (mcoCategory == MCOCategory.GROUP_PREPAYMENT) {
            return result;
        }
        result.getComponents().addAll(CommonAirProductVatHelper.createZZVatComponents(product, passengerType, adapter));
        result.getComponents().addAll(CommonAirProductVatHelper.createRIAndYQVatComponents(product, passengerType, adapter));
        if (adapter.getMcoCategory(product) == MCOCategory.EXCESS_LUGGAGE || adapter.getProductCategory(product) == ProductCategory.EXCESS_BAGAGE) {
            if (CommonAirProductVatHelper.isHasVat(product, adapter)) {
                result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, noTaxesComp, true, passengerType, adapter));
            } else {
                result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, noTaxesComp, true, passengerType, adapter));
            }
            return result;
        }
        ProductCategory productCategory = adapter.getProductCategory(product);
        if (productCategory != ProductCategory.AIR) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, taxesExceptZZandRIandYQCalculationParams, false, true, passengerType, adapter));
            return result;
        }
        if (!CommonAirProductVatHelper.isHasVat(product, adapter)) {
            result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, true, taxesExceptZZandRIandYQCalculationParams, false, true, passengerType, adapter));
            return result;
        }
        result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, CommonAirProductVatHelper.getReducedVATRate(product, adapter), true, taxesVatCalculationParams, true, true, passengerType, adapter));
        result.getComponents().addAll(CommonAirProductVatHelper.createComponents(product, 0.0, false, restTaxesVatCalculationParams, false, true, passengerType, adapter));
        return result;
    }
}

